/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.communication.controller;

import com.google.protobuf.Message;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.openbase.jul.communication.config.CommunicatorConfig;
import org.openbase.jul.communication.data.RPCResponse;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.TimeoutException;
import org.openbase.jul.pattern.controller.Remote;
import org.openbase.type.communication.ScopeType;

public interface RPCRemote<M extends Message>
extends Remote<M> {
    public void init(ScopeType.Scope var1) throws InitializationException, InterruptedException;

    public void init(ScopeType.Scope var1, CommunicatorConfig var2) throws InitializationException, InterruptedException;

    public void init(String var1) throws InitializationException, InterruptedException;

    public ScopeType.Scope getScope() throws NotAvailableException;

    @Deprecated
    default public <R> R callMethod(String methodName, Class<R> returnClazz) throws CouldNotPerformException, InterruptedException {
        try {
            return (R)this.callMethodAsync(methodName, returnClazz).get();
        }
        catch (ExecutionException e) {
            throw (CouldNotPerformException)e.getCause();
        }
    }

    @Deprecated
    default public <R, T> R callMethod(String methodName, Class<R> returnClazz, T argument) throws CouldNotPerformException, InterruptedException {
        try {
            return (R)this.callMethodAsync(methodName, returnClazz, argument).get();
        }
        catch (ExecutionException e) {
            throw (CouldNotPerformException)e.getCause();
        }
    }

    @Deprecated
    default public <R> R callMethod(String methodName, Class<R> returnClazz, long timeout) throws CouldNotPerformException, TimeoutException, InterruptedException {
        try {
            return (R)this.callMethodAsync(methodName, returnClazz).get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (java.util.concurrent.TimeoutException e) {
            throw new TimeoutException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw (CouldNotPerformException)e.getCause();
        }
    }

    @Deprecated
    default public <R, T> R callMethod(String methodName, Class<R> returnClazz, T argument, long timeout) throws CouldNotPerformException, TimeoutException, InterruptedException {
        try {
            return (R)this.callMethodAsync(methodName, returnClazz, argument).get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (java.util.concurrent.TimeoutException e) {
            throw new TimeoutException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw (CouldNotPerformException)e.getCause();
        }
    }

    public <R> Future<RPCResponse<R>> callMethodAsync(String var1, Class<R> var2);

    public <R, T> Future<RPCResponse<R>> callMethodAsync(String var1, Class<R> var2, T var3);
}

