/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.communication.controller;

import com.google.protobuf.Descriptors;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import org.openbase.jps.core.JPService;
import org.openbase.jul.communication.config.CommunicatorConfig;
import org.openbase.jul.communication.controller.AbstractControllerServer;
import org.openbase.jul.communication.controller.RPCRemote;
import org.openbase.jul.communication.controller.RPCUtils;
import org.openbase.jul.communication.data.RPCResponse;
import org.openbase.jul.communication.exception.RPCException;
import org.openbase.jul.communication.exception.RPCResolvedException;
import org.openbase.jul.communication.iface.CommunicatorFactory;
import org.openbase.jul.communication.iface.RPCClient;
import org.openbase.jul.communication.iface.Subscriber;
import org.openbase.jul.communication.jp.JPComHost;
import org.openbase.jul.communication.mqtt.CommunicatorFactoryImpl;
import org.openbase.jul.communication.mqtt.DefaultCommunicatorConfig;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.ExceptionProcessor;
import org.openbase.jul.exception.FatalImplementationErrorException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.InvalidStateException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.NotInitializedException;
import org.openbase.jul.exception.ShutdownInProgressException;
import org.openbase.jul.exception.StackTracePrinter;
import org.openbase.jul.exception.TimeoutException;
import org.openbase.jul.exception.VerificationFailedException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.extension.protobuf.processing.MessageProcessor;
import org.openbase.jul.extension.protobuf.processing.SimpleMessageProcessor;
import org.openbase.jul.extension.type.iface.TransactionIdProvider;
import org.openbase.jul.extension.type.processing.ScopeProcessor;
import org.openbase.jul.iface.Activatable;
import org.openbase.jul.pattern.CompletableFutureLite;
import org.openbase.jul.pattern.Observable;
import org.openbase.jul.pattern.ObservableImpl;
import org.openbase.jul.pattern.Observer;
import org.openbase.jul.pattern.controller.Remote;
import org.openbase.jul.pattern.provider.DataProvider;
import org.openbase.jul.schedule.FutureProcessor;
import org.openbase.jul.schedule.GlobalCachedExecutorService;
import org.openbase.jul.schedule.SyncObject;
import org.openbase.jul.schedule.TimeoutSplitter;
import org.openbase.jul.schedule.WatchDog;
import org.openbase.type.communication.EventType;
import org.openbase.type.communication.ScopeType;
import org.openbase.type.domotic.state.ConnectionStateType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRemoteClient<M extends Message>
implements RPCRemote<M>,
TransactionIdProvider {
    public static final long REQUEST_TIMEOUT = TimeUnit.SECONDS.toMillis(15L);
    public static final long PING_TIMEOUT = TimeUnit.SECONDS.toMillis(5L);
    public static final long PING_TEST_TIMEOUT = TimeUnit.SECONDS.toMillis(1L);
    public static final long CONNECTION_TIMEOUT = TimeUnit.SECONDS.toMillis(60L);
    public static final long RECONNECT_AFTER_CONNECTION_LOST_DELAY_OFFSET = 50L;
    public static final long RECONNECT_AFTER_CONNECTION_LOST_DELAY_SEED = 100L;
    public static final long METHOD_CALL_START_TIMEOUT = 500L;
    public static final double METHOD_CALL_TIMEOUT_MULTIPLIER = 1.2;
    public static final long METHOD_CALL_MAX_TIMEOUT = TimeUnit.SECONDS.toMillis(30L);
    private static final Random JITTER_RANDOM = new Random();
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Function2<EventType.Event, Map<String, String>, Unit> mainHandler;
    private final SyncObject syncMonitor = new SyncObject("SyncMonitor");
    private final SyncObject connectionMonitor = new SyncObject("ConnectionMonitor");
    private final SyncObject maintainerLock = new SyncObject("MaintainerLock");
    private final SyncObject pingLock = new SyncObject("PingLock");
    private final Class<M> dataClass;
    private final ObservableImpl<Remote<?>, ConnectionStateType.ConnectionState.State> connectionStateObservable = new ObservableImpl((Object)this);
    private final ObservableImpl<DataProvider<M>, M> internalPrioritizedDataObservable = new ObservableImpl((Object)this);
    private final ObservableImpl<DataProvider<M>, M> dataObservable = new ObservableImpl((Object)this);
    private final SyncObject dataUpdateMonitor = new SyncObject("DataUpdateMonitor");
    protected Object maintainer;
    protected ScopeType.Scope scope;
    private Subscriber subscriber;
    private WatchDog subscriberWatchDog;
    private WatchDog rpcClientWatchDog;
    private RPCClient rpcClient;
    private ConnectionStateType.ConnectionState.State connectionState;
    private Observer<WatchDog, WatchDog.ServiceState> middlewareFailureObserver;
    private Observer<WatchDog, WatchDog.ServiceState> middlewareReadyObserver;
    private long connectionPing;
    private long lastPingReceived;
    private CompletableFutureLite<M> syncFuture;
    private Future<M> syncTask;
    private M data;
    private boolean initialized;
    private MessageProcessor<Message, M> messageProcessor;
    private Set<StackTraceElement[]> reinitStackTraces = new HashSet<StackTraceElement[]>();
    private volatile boolean shutdownInitiated;
    private long newestEventTime = 0L;
    private long newestEventTimeNano = 0L;
    private boolean connectionFailure = false;
    private Future<Long> pingTask = null;
    private volatile long transactionId = -1L;
    private final CommunicatorFactory factory = CommunicatorFactoryImpl.Companion.getInstance();
    private final CommunicatorConfig defaultCommunicatorConfig = DefaultCommunicatorConfig.Companion.getInstance();

    public AbstractRemoteClient(Class<M> dataClass) {
        this.dataClass = dataClass;
        this.mainHandler = this.generateHandler();
        this.initialized = false;
        this.shutdownInitiated = false;
        this.rpcClient = null;
        this.subscriber = null;
        this.connectionState = ConnectionStateType.ConnectionState.State.DISCONNECTED;
        this.connectionPing = -1L;
        this.lastPingReceived = -1L;
        this.messageProcessor = new SimpleMessageProcessor(dataClass);
        this.connectionStateObservable.setExecutorService((ExecutorService)GlobalCachedExecutorService.getInstance().getExecutorService());
        this.middlewareFailureObserver = (source, watchDogState) -> {
            switch (watchDogState) {
                case FAILED: {
                    this.logger.warn("Broker at " + (String)JPService.getValue(JPComHost.class, (Object)"?") + " not responding.");
                    this.setConnectionState(ConnectionStateType.ConnectionState.State.DISCONNECTED);
                }
            }
        };
        this.middlewareReadyObserver = (source, watchDogState) -> {
            switch (watchDogState) {
                case RUNNING: {
                    this.rpcClientWatchDog.waitForServiceActivation();
                    this.requestData();
                }
            }
        };
    }

    private static long generateTimeout(long currentTimeout) {
        return Math.min(METHOD_CALL_MAX_TIMEOUT, (long)((double)currentTimeout * 1.2 + JITTER_RANDOM.nextDouble() * 1000.0));
    }

    protected void setMessageProcessor(MessageProcessor<Message, M> messageProcessor) {
        this.messageProcessor = messageProcessor;
    }

    @Override
    public void init(ScopeType.Scope scope) throws InitializationException, InterruptedException {
        this.init(scope, this.defaultCommunicatorConfig);
    }

    @Override
    public void init(String scope) throws InitializationException, InterruptedException {
        try {
            this.init(ScopeProcessor.generateScope((String)scope));
        }
        catch (NullPointerException | CouldNotPerformException ex) {
            throw new InitializationException((Object)this, ex);
        }
    }

    protected void postInit() throws InitializationException, InterruptedException {
    }

    @Override
    public void init(ScopeType.Scope scope, CommunicatorConfig communicatorConfig) throws InitializationException, InterruptedException {
        this.internalInit(scope, communicatorConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalInit(ScopeType.Scope scope, CommunicatorConfig communicatorConfig) throws InitializationException, InterruptedException {
        SyncObject syncObject = this.maintainerLock;
        synchronized (syncObject) {
            try {
                this.verifyMaintainability();
                if (this.isActive()) {
                    this.setConnectionState(ConnectionStateType.ConnectionState.State.RECONNECTING);
                } else {
                    this.setConnectionState(ConnectionStateType.ConnectionState.State.REINITIALIZING);
                }
                CommunicatorConfig internalCommunicatorConfig = communicatorConfig;
                if (scope == null) {
                    throw new NotAvailableException("scope");
                }
                if (this.initialized | this.subscriberWatchDog != null | this.rpcClientWatchDog != null) {
                    this.deactivate();
                    this.reset();
                }
                this.scope = scope;
                this.logger.debug("Init AbstractControllerServer for component " + this.getClass().getSimpleName() + " on " + ScopeProcessor.generateStringRep((ScopeType.Scope)scope));
                this.initSubscriber(scope, internalCommunicatorConfig);
                this.initRemoteServer(scope, internalCommunicatorConfig);
                this.addHandler(this.mainHandler, true);
                this.postInit();
                this.initialized = true;
                switch (this.getConnectionState()) {
                    case RECONNECTING: {
                        this.activate();
                        break;
                    }
                    case REINITIALIZING: {
                        this.setConnectionState(ConnectionStateType.ConnectionState.State.DISCONNECTED);
                    }
                }
            }
            catch (CouldNotPerformException ex) {
                throw new InitializationException((Object)this, (Throwable)ex);
            }
        }
    }

    private void initSubscriber(ScopeType.Scope scope, CommunicatorConfig communicatorConfig) throws CouldNotPerformException {
        try {
            this.subscriber = this.factory.createSubscriber(ScopeProcessor.concat((ScopeType.Scope)scope, (ScopeType.Scope)AbstractControllerServer.SCOPE_SUFFIX_STATUS), communicatorConfig);
            this.subscriberWatchDog = new WatchDog((Activatable)this.subscriber, "Subscriber[" + ScopeProcessor.generateStringRep((ScopeType.Scope)this.subscriber.getScope()) + "]");
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not create Subscriber on scope [" + String.valueOf(scope) + "]!", (Throwable)ex);
        }
    }

    private void initRemoteServer(ScopeType.Scope scope, CommunicatorConfig communicatorConfig) throws CouldNotPerformException {
        try {
            this.rpcClient = this.factory.createRPCClient(ScopeProcessor.concat((ScopeType.Scope)scope, (ScopeType.Scope)AbstractControllerServer.SCOPE_SUFFIX_CONTROL), communicatorConfig);
            this.rpcClientWatchDog = new WatchDog((Activatable)this.rpcClient, "RPCClient[" + ScopeProcessor.generateStringRep((ScopeType.Scope)this.rpcClient.getScope()) + "]");
            this.subscriberWatchDog.addObserver(this.middlewareReadyObserver);
            this.subscriberWatchDog.addObserver(this.middlewareFailureObserver);
            this.rpcClientWatchDog.addObserver(this.middlewareFailureObserver);
        }
        catch (RuntimeException ex) {
            throw new CouldNotPerformException("Could not create RPCClient on scope [" + String.valueOf(scope) + "]!", (Throwable)ex);
        }
    }

    public void verifyMaintainability() throws VerificationFailedException {
        if (this.isLocked()) {
            throw new VerificationFailedException("Manipulation of " + String.valueOf(this) + " is currently not valid because the maintains is protected by another instance! Did you try to modify an instance which is locked by a managed instance pool?");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocked() {
        SyncObject syncObject = this.maintainerLock;
        synchronized (syncObject) {
            return this.maintainer != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(Object maintainer) throws CouldNotPerformException {
        SyncObject syncObject = this.maintainerLock;
        synchronized (syncObject) {
            if (this.maintainer != null) {
                throw new CouldNotPerformException("Could not lock remote because it is already locked by another instance!");
            }
            this.maintainer = maintainer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(Object maintainer) throws CouldNotPerformException {
        SyncObject syncObject = this.maintainerLock;
        synchronized (syncObject) {
            if (this.maintainer != null && this.maintainer != maintainer) {
                throw new CouldNotPerformException("Could not unlock remote because it is locked by another instance!");
            }
            this.maintainer = null;
        }
    }

    public Class<M> getDataClass() {
        return this.dataClass;
    }

    public void addHandler(Function2<EventType.Event, Map<String, String>, Unit> handler, boolean wait) throws InterruptedException, CouldNotPerformException {
        this.subscriber.registerDataHandler(handler);
    }

    protected Function2<EventType.Event, Map<String, String>, Unit> generateHandler() {
        return (event, userProperties) -> {
            block2: {
                try {
                    this.logger.debug("Internal notification: " + event.toString());
                    this.applyEventUpdate((EventType.Event)event, (Map<String, String>)userProperties);
                }
                catch (Exception ex) {
                    if (ExceptionProcessor.isCausedBySystemShutdown((Throwable)ex)) break block2;
                    ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Internal notification failed!", (Throwable)ex), (Logger)this.logger);
                }
            }
            return null;
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate() throws InterruptedException, CouldNotPerformException {
        SyncObject syncObject = this.maintainerLock;
        synchronized (syncObject) {
            if (this.isActive()) {
                return;
            }
            try {
                this.verifyMaintainability();
                this.validateInitialization();
                this.setConnectionState(ConnectionStateType.ConnectionState.State.CONNECTING);
                this.rpcClientWatchDog.activate();
                this.subscriberWatchDog.activate();
            }
            catch (CouldNotPerformException ex) {
                throw new InvalidStateException("Could not activate remote service!", (Throwable)ex);
            }
        }
    }

    public void activate(boolean waitForData) throws InterruptedException, CouldNotPerformException {
        this.activate();
        if (waitForData) {
            this.waitForData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate(Object maintainer) throws InterruptedException, CouldNotPerformException {
        if (!this.isLocked() || this.maintainer.equals(maintainer)) {
            SyncObject syncObject = this.maintainerLock;
            synchronized (syncObject) {
                this.unlock(maintainer);
                this.activate();
                this.lock(maintainer);
            }
        } else {
            throw new VerificationFailedException("[" + String.valueOf(maintainer) + "] is not the current maintainer of this remote");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate(Object maintainer) throws InterruptedException, CouldNotPerformException, VerificationFailedException {
        if (this.maintainer.equals(maintainer)) {
            SyncObject syncObject = this.maintainerLock;
            synchronized (syncObject) {
                this.unlock(maintainer);
                this.deactivate();
                this.lock(maintainer);
            }
        } else {
            throw new VerificationFailedException("[" + String.valueOf(maintainer) + "] is not the current maintainer of this remote");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate() throws InterruptedException, CouldNotPerformException {
        SyncObject syncObject = this.maintainerLock;
        synchronized (syncObject) {
            try {
                this.verifyMaintainability();
                this.validateInitialization();
            }
            catch (InvalidStateException ex) {
                return;
            }
            if (this.connectionState != ConnectionStateType.ConnectionState.State.RECONNECTING) {
                this.skipSyncTasks();
                this.setConnectionState(ConnectionStateType.ConnectionState.State.DISCONNECTED);
                if (this.pingTask != null && !this.pingTask.isDone()) {
                    this.pingTask.cancel(true);
                }
            }
            if (this.subscriberWatchDog != null) {
                this.subscriberWatchDog.deactivate();
            }
            if (this.rpcClientWatchDog != null) {
                this.rpcClientWatchDog.deactivate();
            }
        }
        syncObject = this.connectionMonitor;
        synchronized (syncObject) {
            this.connectionMonitor.notifyAll();
        }
    }

    public void reset() throws CouldNotPerformException {
        try {
            this.verifyMaintainability();
            this.initialized = false;
            if (this.subscriberWatchDog != null) {
                this.subscriberWatchDog.shutdown();
                this.subscriberWatchDog = null;
                this.subscriber = null;
            }
            if (this.rpcClientWatchDog != null) {
                this.rpcClientWatchDog.shutdown();
                this.rpcClientWatchDog = null;
                this.rpcClient = null;
            }
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not reset " + String.valueOf(this) + "!", (Throwable)ex);
        }
    }

    protected void reinit() throws InterruptedException, CouldNotPerformException {
        this.reinit(this.scope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reinit(ScopeType.Scope scope) throws InterruptedException, CouldNotPerformException {
        if (this.shutdownInitiated) {
            throw new ShutdownInProgressException((Object)this);
        }
        StackTraceElement[] stackTraceElement = Thread.currentThread().getStackTrace();
        try {
            SyncObject syncObject = this.maintainerLock;
            synchronized (syncObject) {
                this.reinitStackTraces.add(stackTraceElement);
                try {
                    if (this.reinitStackTraces.size() > 1) {
                        for (StackTraceElement[] trace : this.reinitStackTraces) {
                            StackTracePrinter.printStackTrace((String)"Duplicated reinit call by:", (StackTraceElement[])trace, (Logger)this.logger, (LogLevel)LogLevel.WARN);
                        }
                        throw new FatalImplementationErrorException("Duplicated reinit detected!", (Object)this);
                    }
                    this.logger.debug("Reinit " + String.valueOf(this));
                    Object currentMaintainer = this.maintainer;
                    try {
                        this.maintainer = null;
                        this.internalInit(scope, this.defaultCommunicatorConfig);
                    }
                    catch (CouldNotPerformException ex) {
                        throw new CouldNotPerformException("Could not reinit " + String.valueOf(this) + "!", (Throwable)ex);
                    }
                    finally {
                        this.maintainer = currentMaintainer;
                    }
                }
                finally {
                    this.reinitStackTraces.remove(stackTraceElement);
                }
            }
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not reinitialize " + String.valueOf(this) + "!", (Throwable)ex);
        }
    }

    public void reinit(Object maintainer) throws InterruptedException, CouldNotPerformException, VerificationFailedException {
        this.reinit(this.scope, maintainer);
    }

    public void reinit(ScopeType.Scope scope, Object maintainer) throws InterruptedException, CouldNotPerformException, VerificationFailedException {
        if (!this.maintainer.equals(maintainer)) {
            throw new VerificationFailedException("Manipulation of " + String.valueOf(this) + "is not valid using lock[" + String.valueOf(this.maintainerLock) + "]");
        }
        this.reinit(scope);
    }

    public boolean isConnected() {
        return this.connectionState == ConnectionStateType.ConnectionState.State.CONNECTED;
    }

    public ConnectionStateType.ConnectionState.State getConnectionState() {
        return this.connectionState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setConnectionState(ConnectionStateType.ConnectionState.State connectionState) {
        SyncObject syncObject = this.connectionMonitor;
        synchronized (syncObject) {
            block17: {
                if (this.connectionState == ConnectionStateType.ConnectionState.State.RECONNECTING && connectionState == ConnectionStateType.ConnectionState.State.CONNECTED) {
                    return;
                }
                if (this.connectionState.equals((Object)connectionState)) {
                    return;
                }
                if (this.shutdownInitiated && connectionState != ConnectionStateType.ConnectionState.State.DISCONNECTED) {
                    return;
                }
                ConnectionStateType.ConnectionState.State oldConnectionState = this.connectionState;
                this.connectionState = connectionState;
                switch (connectionState) {
                    case DISCONNECTED: {
                        break;
                    }
                    case CONNECTING: {
                        if (!this.isActive() || oldConnectionState == ConnectionStateType.ConnectionState.State.DISCONNECTED) break;
                        this.connectionFailure = true;
                        try {
                            Thread.sleep((long)(JITTER_RANDOM.nextDouble() * 100.0) + 50L);
                            this.requestData();
                        }
                        catch (InterruptedException ex) {
                            Thread.currentThread().interrupt();
                        }
                        break;
                    }
                    case CONNECTED: {
                        if (this.connectionFailure) {
                            this.logger.info("Connection reestablished " + String.valueOf(this));
                        } else {
                            this.logger.debug("Connection established " + String.valueOf(this));
                        }
                        this.connectionFailure = false;
                        GlobalCachedExecutorService.submit(() -> {
                            SyncObject syncObject = this.pingLock;
                            synchronized (syncObject) {
                                if (this.pingTask != null && !this.pingTask.isDone()) {
                                    try {
                                        this.pingTask.get();
                                    }
                                    catch (CancellationException | ExecutionException ex) {
                                        return;
                                    }
                                    catch (InterruptedException ex) {
                                        Thread.currentThread().interrupt();
                                        return;
                                    }
                                }
                                this.ping();
                            }
                        });
                    }
                }
                this.connectionMonitor.notifyAll();
                try {
                    this.connectionStateObservable.notifyObservers((Object)connectionState);
                }
                catch (CouldNotPerformException ex) {
                    if (ExceptionProcessor.isCausedBySystemShutdown((Throwable)ex)) break block17;
                    ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not notify ConnectionState[" + String.valueOf(connectionState) + "] change to all observers!", (Throwable)ex), (Logger)this.logger);
                }
            }
        }
    }

    public boolean isActive() {
        try {
            return this.subscriberWatchDog.isActive() && this.rpcClientWatchDog.isActive();
        }
        catch (NullPointerException ex) {
            return false;
        }
    }

    @Override
    public <R> Future<RPCResponse<R>> callMethodAsync(String methodName, Class<R> returnClazz) {
        return this.callMethodAsync(methodName, returnClazz, null);
    }

    @Override
    public <R> R callMethod(String methodName, Class<R> returnClazz) throws CouldNotPerformException, InterruptedException {
        return this.callMethod(methodName, null);
    }

    @Override
    public <R, T> R callMethod(String methodName, Class<R> returnClazz, T argument) throws CouldNotPerformException, InterruptedException {
        return this.callMethod(methodName, returnClazz, argument, -1L);
    }

    @Override
    public <R> R callMethod(String methodName, Class<R> returnClazz, long timeout) throws CouldNotPerformException, InterruptedException {
        return this.callMethod(methodName, returnClazz, null, timeout);
    }

    @Override
    public <R, T> R callMethod(String methodName, Class<R> returnClazz, T argument, long timeout) throws CouldNotPerformException, InterruptedException {
        String shortArgument = RPCUtils.argumentToString(argument);
        this.validateMiddleware();
        long retryTimeout = 500L;
        long validTimeout = timeout;
        try {
            this.logger.debug("Calling method [" + methodName + "(" + shortArgument + ")] on scope: " + ScopeProcessor.generateStringRep((ScopeType.Scope)this.rpcClient.getScope()));
            if (!this.isConnected()) {
                this.waitForConnectionState(ConnectionStateType.ConnectionState.State.CONNECTED, timeout);
            }
            if (timeout > -1L) {
                retryTimeout = Math.min(500L, validTimeout);
            }
            while (true) {
                if (!this.isActive()) {
                    throw new InvalidStateException("Remote service is not active!");
                }
                try {
                    Object returnValue;
                    this.logger.debug("Calling method [" + methodName + "(" + shortArgument + ")] on scope: " + ScopeProcessor.generateStringRep((ScopeType.Scope)this.rpcClient.getScope()));
                    this.rpcClientWatchDog.waitForServiceActivation(timeout, TimeUnit.MILLISECONDS);
                    try {
                        returnValue = ((RPCResponse)this.rpcClient.callMethod(methodName, returnClazz, new Object[]{argument}).get(retryTimeout, TimeUnit.MILLISECONDS)).getResponse();
                    }
                    catch (ExecutionException e) {
                        throw (CouldNotPerformException)e.getCause();
                    }
                    if (retryTimeout != 500L && retryTimeout > 15000L) {
                        this.logger.info("Method[" + methodName + "(" + shortArgument + ")] returned! Continue processing...");
                    }
                    return (R)returnValue;
                }
                catch (java.util.concurrent.TimeoutException | TimeoutException ex) {
                    if (timeout != -1L) {
                        if ((validTimeout -= retryTimeout) <= 0L) {
                            ExceptionPrinter.printHistory((Throwable)ex, (Logger)this.logger, (LogLevel)LogLevel.WARN);
                            throw new TimeoutException("Could not call remote Method[" + methodName + "(" + shortArgument + ")] on Scope[" + ScopeProcessor.generateStringRep((ScopeType.Scope)this.rpcClient.getScope()) + "] in Time[" + timeout + "ms].");
                        }
                        retryTimeout = Math.min(AbstractRemoteClient.generateTimeout(retryTimeout), validTimeout);
                    } else {
                        retryTimeout = AbstractRemoteClient.generateTimeout(retryTimeout);
                    }
                    if (retryTimeout > 15000L) {
                        ExceptionPrinter.printHistory((Throwable)ex, (Logger)this.logger, (LogLevel)LogLevel.WARN);
                        this.logger.warn("Waiting for RPCServer[" + ScopeProcessor.generateStringRep((ScopeType.Scope)this.rpcClient.getScope()) + "] to call method [" + methodName + "(" + shortArgument + ")]. Next retry timeout in " + (int)Math.floor(retryTimeout / 1000L) + " sec.");
                    } else {
                        ExceptionPrinter.printHistory((Throwable)ex, (Logger)this.logger, (LogLevel)LogLevel.DEBUG);
                        this.logger.debug("Waiting for RPCServer[" + ScopeProcessor.generateStringRep((ScopeType.Scope)this.rpcClient.getScope()) + "] to call method [" + methodName + "(" + shortArgument + ")]. Next retry timeout in " + (int)Math.floor(retryTimeout / 1000L) + " sec.");
                    }
                    Thread.yield();
                    continue;
                }
                break;
            }
        }
        catch (TimeoutException ex) {
            throw ex;
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not call remote Method[" + methodName + "(" + shortArgument + ")] on Scope[" + ScopeProcessor.generateStringRep((ScopeType.Scope)this.rpcClient.getScope()) + "].", (Throwable)ex);
        }
    }

    @Override
    public <R, T> Future<RPCResponse<R>> callMethodAsync(final String methodName, final Class<R> returnClazz, final T argument) {
        try {
            this.waitForMiddleware(1000L, TimeUnit.SECONDS);
            this.validateMiddleware();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return FutureProcessor.canceledFuture((Exception)ex);
        }
        catch (CouldNotPerformException ex) {
            return FutureProcessor.canceledFuture((Exception)((Object)ex));
        }
        return GlobalCachedExecutorService.submit((Callable)new Callable<RPCResponse<R>>(){
            private Future<RPCResponse<R>> internalCallFuture;

            @Override
            public RPCResponse<R> call() throws Exception {
                String shortArgument = RPCUtils.argumentToString(argument);
                try {
                    try {
                        AbstractRemoteClient.this.logger.debug("Calling method async [" + methodName + "(" + shortArgument + ")] on scope: " + ScopeProcessor.generateStringRep((ScopeType.Scope)AbstractRemoteClient.this.rpcClient.getScope()));
                        if (!AbstractRemoteClient.this.isConnected()) {
                            try {
                                AbstractRemoteClient.this.waitForConnectionState(ConnectionStateType.ConnectionState.State.CONNECTED, CONNECTION_TIMEOUT);
                            }
                            catch (TimeoutException ex) {
                                throw new CouldNotPerformException("Cannot not call async method[" + methodName + "(" + shortArgument + ")] on [" + String.valueOf(this) + "] in connectionState[" + String.valueOf(AbstractRemoteClient.this.connectionState) + "]", (Throwable)ex);
                            }
                        }
                        long currentTime = System.nanoTime();
                        AbstractRemoteClient.this.rpcClientWatchDog.waitForServiceActivation();
                        this.internalCallFuture = argument == null ? AbstractRemoteClient.this.rpcClient.callMethod(methodName, returnClazz, new Object[0]) : AbstractRemoteClient.this.rpcClient.callMethod(methodName, returnClazz, new Object[]{argument});
                        while (!Thread.currentThread().isInterrupted()) {
                            if (TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - currentTime) > RPCUtils.RPC_TIMEOUT) {
                                throw new TimeoutException("RPCMethod call timeout");
                            }
                            try {
                                return this.internalCallFuture.get(REQUEST_TIMEOUT, TimeUnit.MILLISECONDS);
                            }
                            catch (java.util.concurrent.TimeoutException ex) {
                                try {
                                    if (AbstractRemoteClient.this.getConnectionState() != ConnectionStateType.ConnectionState.State.RECONNECTING) {
                                        AbstractRemoteClient.this.ping().get(REQUEST_TIMEOUT, TimeUnit.MILLISECONDS);
                                        continue;
                                    }
                                    AbstractRemoteClient.this.waitForConnectionState(ConnectionStateType.ConnectionState.State.CONNECTING);
                                }
                                catch (CancellationException | ExecutionException | java.util.concurrent.TimeoutException exx) {
                                    if (this.internalCallFuture == null) continue;
                                    this.internalCallFuture.cancel(true);
                                }
                            }
                            catch (ExecutionException ex) {
                                if (ex.getCause() instanceof RPCException) {
                                    throw new RPCResolvedException("Remote call failed!", (RPCException)ex.getCause());
                                }
                                throw ex;
                            }
                        }
                        throw new InterruptedException();
                    }
                    catch (InterruptedException ex) {
                        if (this.internalCallFuture != null) {
                            this.internalCallFuture.cancel(true);
                        }
                        throw ex;
                    }
                    catch (InvalidStateException ex) {
                        switch (AbstractRemoteClient.this.connectionState) {
                            case CONNECTING: 
                            case CONNECTED: {
                                try {
                                    AbstractRemoteClient.this.reinit();
                                    break;
                                }
                                catch (CouldNotPerformException exx) {
                                    ExceptionPrinter.printHistory((String)"Recovering middleware connection failed!", (Throwable)exx, (Logger)AbstractRemoteClient.this.logger);
                                }
                            }
                        }
                        throw ex;
                    }
                }
                catch (InterruptedException | CancellationException | CouldNotPerformException ex) {
                    throw new CouldNotPerformException("Could not call remote Method[" + methodName + "(" + shortArgument + ")] on Scope[" + ScopeProcessor.generateStringRep((ScopeType.Scope)AbstractRemoteClient.this.rpcClient.getScope()) + "].", ex);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<M> requestData() {
        this.logger.debug(String.valueOf(this) + " requestData...");
        try {
            this.validateInitialization();
            SyncObject syncObject = this.syncMonitor;
            synchronized (syncObject) {
                if (this.syncTask != null && !this.syncTask.isDone()) {
                    this.syncTask.cancel(true);
                }
                if (this.syncFuture == null || this.syncFuture.isDone()) {
                    this.syncFuture = new CompletableFutureLite();
                }
                this.syncTask = this.sync();
                return this.syncFuture;
            }
        }
        catch (CouldNotPerformException ex) {
            return FutureProcessor.canceledFuture(this.getDataClass(), (Exception)((Object)new CouldNotPerformException("Could not request data!", (Throwable)ex)));
        }
    }

    private Future<M> sync() {
        this.logger.trace("Synchronization of Remote[" + String.valueOf(this) + "] triggered...");
        try {
            this.validateInitialization();
            try {
                SyncTaskCallable syncCallable = new SyncTaskCallable();
                Future currentSyncTask = GlobalCachedExecutorService.submit((Callable)syncCallable);
                syncCallable.setRelatedFuture(currentSyncTask);
                return currentSyncTask;
            }
            catch (NullPointerException | RejectedExecutionException ex) {
                throw new CouldNotPerformException("Could not request the current status.", (Throwable)ex);
            }
        }
        catch (CouldNotPerformException ex) {
            return FutureProcessor.canceledFuture((Exception)((Object)ex));
        }
    }

    protected RPCClient getRpcClient() {
        return this.rpcClient;
    }

    protected Future<RPCResponse<M>> internalRequestStatus() {
        return this.rpcClient.callMethod("requestStatus", this.getDataClass(), new Object[0]);
    }

    protected M applyEventUpdate(EventType.Event event, Map<String, String> userProperties) throws CouldNotPerformException, InterruptedException {
        return this.applyEventUpdate(event, userProperties, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private M applyEventUpdate(EventType.Event event, Map<String, String> userProperties, Future<M> relatedFuture) throws CouldNotPerformException, InterruptedException {
        SyncObject syncObject = this.dataUpdateMonitor;
        synchronized (syncObject) {
            if (event == null) {
                throw new NotAvailableException("event");
            }
            if (relatedFuture != null && relatedFuture.isCancelled()) {
                return this.data;
            }
            Message dataUpdate = null;
            if (event.hasPayload()) {
                try {
                    dataUpdate = event.getPayload().unpack(this.getDataClass());
                }
                catch (InvalidProtocolBufferException e) {
                    throw new CouldNotPerformException("Event data does not match " + this.getDataClass().getSimpleName(), (Throwable)e);
                }
            }
            if (dataUpdate == null) {
                this.logger.debug("Received dataUpdate null while in connection state[" + this.getConnectionState().name() + "]");
                if (this.getConnectionState() == ConnectionStateType.ConnectionState.State.RECONNECTING) {
                    return (M)dataUpdate;
                }
                ExceptionPrinter.printVerboseMessage((String)("Remote connection to Controller[" + ScopeProcessor.generateStringRep((ScopeType.Scope)this.getScope()) + "] was detached because the controller shutdown was initiated."), (Logger)this.logger);
                this.transactionId = 0L;
                this.setConnectionState(ConnectionStateType.ConnectionState.State.CONNECTING);
                return (M)dataUpdate;
            }
            try {
                dataUpdate = (Message)this.messageProcessor.process((Object)event.getPayload().unpack(this.getDataClass()));
            }
            catch (CouldNotPerformException ex) {
                throw new CouldNotPerformException("Could not process message", (Throwable)ex);
            }
            catch (InvalidProtocolBufferException ex) {
                throw new CouldNotPerformException("Received data of unexpected type!. Expected [" + this.getDataClass().getSimpleName() + "]", (Throwable)ex);
            }
            try {
                if (!this.validateAndUpdateEventTimestamp(userProperties)) {
                    this.logger.debug("Skip event on scope[" + this.getScopeStringRep() + "] because event seems to be outdated!");
                    return this.data;
                }
            }
            catch (CouldNotPerformException ex) {
                ExceptionPrinter.printHistory((String)("Data message does not contain valid creation timestamp on scope " + this.getScopeStringRep()), (Throwable)ex, (Logger)this.logger);
            }
            this.applyDataUpdate(dataUpdate);
            return (M)dataUpdate;
        }
    }

    public boolean validateAndUpdateEventTimestamp(Map<String, String> userProperties) throws CouldNotPerformException {
        if (!userProperties.containsKey("TIMESTAMP_MS") || !userProperties.containsKey("TIMESTAMP_NANO")) {
            throw new NotAvailableException("Timestamp in MQTT user properties!");
        }
        try {
            long eventTimeMs = Long.parseLong(userProperties.get("TIMESTAMP_MS"));
            long eventTimeNano = Long.parseLong(userProperties.get("TIMESTAMP_NANO"));
            if (eventTimeMs < this.newestEventTime) {
                return false;
            }
            if (eventTimeMs > this.newestEventTime) {
                this.newestEventTime = eventTimeMs;
                this.newestEventTimeNano = eventTimeNano;
                return true;
            }
            if (eventTimeNano <= this.newestEventTimeNano) {
                return false;
            }
            this.newestEventTime = eventTimeMs;
            this.newestEventTimeNano = eventTimeNano;
            return true;
        }
        catch (NumberFormatException ex) {
            String timeMs = userProperties.get("TIMESTAMP_MS");
            String timeNano = userProperties.get("TIMESTAMP_NANO");
            throw new CouldNotPerformException("One of the timestamps milliseconds[" + timeMs + "] or nanoseconds[" + timeNano + "] cannot be interpreted as a number", (Throwable)ex);
        }
    }

    public void shutdown() {
        try {
            this.verifyMaintainability();
        }
        catch (VerificationFailedException ex) {
            throw new RuntimeException("Can not shutdown " + String.valueOf(this) + "!", ex);
        }
        this.shutdownInitiated = true;
        try {
            this.dataObservable.shutdown();
        }
        finally {
            try {
                this.deactivate();
            }
            catch (InterruptedException | CouldNotPerformException ex) {
                ExceptionPrinter.printHistory((String)("Could not shutdown " + String.valueOf(this) + "!"), (Throwable)ex, (Logger)this.logger);
            }
        }
    }

    public M getData() throws NotAvailableException {
        if (this.data == null) {
            throw new NotAvailableException("data");
        }
        return this.data;
    }

    protected void setData(M data) {
        block6: {
            block5: {
                if (data == null) {
                    new FatalImplementationErrorException((Object)this, (Throwable)new NotAvailableException("data"));
                }
                this.data = data;
                try {
                    this.notifyPrioritizedObservers(data);
                }
                catch (CouldNotPerformException ex) {
                    if (ExceptionProcessor.isCausedBySystemShutdown((Throwable)ex)) break block5;
                    ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not notify data update!", (Throwable)ex), (Logger)this.logger);
                }
            }
            try {
                this.dataObservable.notifyObservers(data);
            }
            catch (CouldNotPerformException ex) {
                if (ExceptionProcessor.isCausedBySystemShutdown((Throwable)ex)) break block6;
                ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not notify data update to all observer!", (Throwable)ex), (Logger)this.logger);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void notifyPrioritizedObservers(M data) throws CouldNotPerformException {
        long newTransactionId;
        block5: {
            try {
                this.internalPrioritizedDataObservable.notifyObservers(data);
                newTransactionId = (Long)this.getDataField("transaction_id");
                if (newTransactionId >= this.transactionId || this.transactionId == 0L) break block5;
            }
            catch (CouldNotPerformException ex) {
                try {
                    throw ex;
                }
                catch (Throwable throwable) {
                    long newTransactionId2 = (Long)this.getDataField("transaction_id");
                    if (newTransactionId2 < this.transactionId && this.transactionId != 0L) {
                        this.logger.warn("RemoteService {} received a data object with an older transaction id {} than {}", new Object[]{this, newTransactionId2, this.transactionId});
                    }
                    this.logger.trace("update transaction id from {} to {}", (Object)this.transactionId, (Object)newTransactionId2);
                    this.transactionId = newTransactionId2;
                    throw throwable;
                }
            }
            this.logger.warn("RemoteService {} received a data object with an older transaction id {} than {}", new Object[]{this, newTransactionId, this.transactionId});
        }
        this.logger.trace("update transaction id from {} to {}", (Object)this.transactionId, (Object)newTransactionId);
        this.transactionId = newTransactionId;
    }

    public boolean isDataAvailable() {
        return this.data != null && this.dataObservable.isValueAvailable();
    }

    public void waitForData() throws CouldNotPerformException, InterruptedException {
        try {
            if (this.isDataAvailable()) {
                return;
            }
            this.waitForMiddleware();
            this.logger.debug("Wait for " + this.toString() + " data...");
            this.getDataFuture().get();
            this.dataObservable.waitForValue();
        }
        catch (CancellationException | ExecutionException ex) {
            if (this.shutdownInitiated) {
                throw new ShutdownInProgressException((Object)this);
            }
            throw new CouldNotPerformException("Could not wait for data!", (Throwable)ex);
        }
    }

    public void waitForData(long timeout, TimeUnit timeUnit) throws CouldNotPerformException, InterruptedException {
        try {
            if (this.isDataAvailable()) {
                return;
            }
            TimeoutSplitter timeoutSplitter = new TimeoutSplitter(timeout, timeUnit);
            this.waitForMiddleware(timeoutSplitter.getTime(), timeoutSplitter.getTimeUnit());
            this.getDataFuture().get(timeout, timeUnit);
            this.dataObservable.waitForValue(timeoutSplitter.getTime(), timeoutSplitter.getTimeUnit());
        }
        catch (CancellationException | ExecutionException | java.util.concurrent.TimeoutException | CouldNotPerformException ex) {
            if (this.shutdownInitiated) {
                throw new ShutdownInProgressException((Object)this);
            }
            throw new NotAvailableException("Data is not yet available!", ex);
        }
    }

    protected final Object getDataField(String name) throws CouldNotPerformException {
        try {
            Descriptors.FieldDescriptor findFieldByName = this.getData().getDescriptorForType().findFieldByName(name);
            if (findFieldByName == null) {
                throw new NotAvailableException("Field[" + name + "] does not exist for type " + this.getData().getClass().getName());
            }
            return this.getData().getField(findFieldByName);
        }
        catch (Exception ex) {
            throw new CouldNotPerformException("Could not return value of field [" + name + "] for " + this.getClass().getSimpleName(), (Throwable)ex);
        }
    }

    protected final boolean hasDataField(String name) throws CouldNotPerformException {
        try {
            Descriptors.FieldDescriptor findFieldByName = this.getData().getDescriptorForType().findFieldByName(name);
            if (findFieldByName == null) {
                return false;
            }
            return this.getData().hasField(findFieldByName);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void validateInitialization() throws InvalidStateException {
        if (!this.initialized) {
            if (this.shutdownInitiated) {
                throw new NotInitializedException((Object)this, (Throwable)new ShutdownInProgressException((Object)this));
            }
            throw new NotInitializedException((Object)this);
        }
    }

    public void validateActivation() throws InvalidStateException {
        this.validateInitialization();
        if (!this.isActive()) {
            throw new InvalidStateException(String.valueOf(this) + " not activated!");
        }
    }

    public void validateMiddleware() throws InvalidStateException {
        this.validateActivation();
        try {
            if (this.subscriber == null) {
                throw new InvalidStateException("Subscriber not initialized!");
            }
            if (!this.subscriber.isActive()) {
                throw new InvalidStateException("Subscriber not active!");
            }
            if (!this.subscriberWatchDog.isServiceRunning()) {
                throw new InvalidStateException("Subscriber service not running!");
            }
        }
        catch (CouldNotPerformException ex) {
            throw new InvalidStateException("Subscriber of " + String.valueOf(this) + " not connected to middleware!", (Throwable)ex);
        }
        try {
            if (this.rpcClient == null) {
                throw new InvalidStateException("RemoteServer not initialized!");
            }
            if (!this.rpcClient.isActive()) {
                throw new InvalidStateException("RemoteServer not active!");
            }
            if (!this.rpcClientWatchDog.isServiceRunning()) {
                throw new InvalidStateException("RemoteServer service not running!");
            }
        }
        catch (CouldNotPerformException ex) {
            throw new InvalidStateException("RemoteServer of " + String.valueOf(this) + " not connected to middleware!", (Throwable)ex);
        }
    }

    public void validateData() throws InvalidStateException {
        if (this.shutdownInitiated) {
            throw new InvalidStateException((Throwable)new ShutdownInProgressException((Object)this));
        }
        if (!this.isDataAvailable()) {
            throw new InvalidStateException(String.valueOf(this) + " not synchronized yet!", (Throwable)new NotAvailableException("data"));
        }
    }

    public void waitForMiddleware() throws CouldNotPerformException, InterruptedException {
        if (this.subscriberWatchDog == null) {
            throw new NotAvailableException("subscriberWatchDog");
        }
        if (this.rpcClientWatchDog == null) {
            throw new NotAvailableException("remoteServiceWatchDog");
        }
        this.subscriberWatchDog.waitForServiceActivation();
        this.rpcClientWatchDog.waitForServiceActivation();
    }

    public void waitForMiddleware(long timeout, TimeUnit timeUnit) throws CouldNotPerformException, InterruptedException {
        if (this.subscriberWatchDog == null) {
            throw new NotAvailableException("subscriberWatchDog");
        }
        if (this.rpcClientWatchDog == null) {
            throw new NotAvailableException("remoteServiceWatchDog");
        }
        TimeoutSplitter timeoutSplitter = new TimeoutSplitter(timeout, timeUnit);
        this.subscriberWatchDog.waitForServiceActivation(timeoutSplitter.getTime(), TimeUnit.MILLISECONDS);
        this.rpcClientWatchDog.waitForServiceActivation(timeoutSplitter.getTime(), TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForConnectionState(ConnectionStateType.ConnectionState.State connectionState, long timeout) throws InterruptedException, TimeoutException, CouldNotPerformException {
        SyncObject syncObject = this.connectionMonitor;
        synchronized (syncObject) {
            boolean delayDetected = false;
            while (!Thread.currentThread().isInterrupted()) {
                if (this.connectionState.equals((Object)connectionState)) {
                    if (delayDetected) {
                        this.logger.info("Continue processing because " + this.getClass().getSimpleName().replace("Remote", "") + "[" + this.getScopeStringRep() + "] is now " + this.connectionState.name().toLowerCase() + ".");
                    }
                    return;
                }
                this.failOnShutdown("Waiting for connectionState[" + connectionState.name() + "] in connectionState[" + this.connectionState.name() + "] on shutdown");
                if (timeout == 0L) {
                    this.connectionMonitor.wait(15000L);
                    if (this.connectionState.equals((Object)connectionState)) continue;
                    this.failOnShutdown("Waiting for connectionState[" + connectionState.name() + "] in connectionState[" + this.connectionState.name() + "] on shutdown");
                    delayDetected = true;
                    this.logger.info("Wait for " + this.connectionState.name().toLowerCase() + " " + this.getClass().getSimpleName().replace("Remote", "") + "[" + this.getScopeStringRep() + "] to be " + connectionState.name().toLowerCase() + "...");
                    this.connectionMonitor.wait();
                    continue;
                }
                this.connectionMonitor.wait(timeout);
                if (this.connectionState.equals((Object)connectionState)) continue;
                throw new TimeoutException("Timeout expired!");
            }
        }
    }

    private void failOnShutdown(String message) throws ShutdownInProgressException {
        if (this.shutdownInitiated) {
            throw new ShutdownInProgressException(message);
        }
    }

    private String getScopeStringRep() {
        try {
            return ScopeProcessor.generateStringRep((ScopeType.Scope)this.scope);
        }
        catch (CouldNotPerformException ex) {
            return "?";
        }
    }

    public void waitForConnectionState(ConnectionStateType.ConnectionState.State connectionState) throws InterruptedException, CouldNotPerformException {
        block2: {
            try {
                this.waitForConnectionState(connectionState, 0L);
            }
            catch (TimeoutException ex) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    @Override
    public ScopeType.Scope getScope() throws NotAvailableException {
        if (this.scope == null) {
            throw new NotAvailableException("scope", (Throwable)new InvalidStateException("remote service not initialized yet!"));
        }
        return this.scope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyDataUpdate(M data) {
        if (data == null) {
            new FatalImplementationErrorException((Object)this, (Throwable)new NotAvailableException("data"));
        }
        this.data = data;
        CompletableFutureLite<M> currentSyncFuture = null;
        Future<M> currentSyncTask = null;
        SyncObject syncObject = this.syncMonitor;
        synchronized (syncObject) {
            if (this.syncFuture != null) {
                currentSyncFuture = this.syncFuture;
                currentSyncTask = this.syncTask;
                this.syncFuture = null;
                this.syncTask = null;
            }
        }
        if (currentSyncFuture != null) {
            currentSyncFuture.complete(data);
        }
        if (currentSyncTask != null && !currentSyncTask.isDone()) {
            currentSyncTask.cancel(false);
        }
        this.setConnectionState(ConnectionStateType.ConnectionState.State.CONNECTED);
        try {
            this.notifyPrioritizedObservers(data);
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not notify data update!", (Throwable)ex), (Logger)this.logger);
        }
        try {
            this.dataObservable.notifyObservers(data);
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not notify data update to all observer!", (Throwable)ex), (Logger)this.logger);
        }
    }

    protected Observable<DataProvider<M>, M> getInternalPrioritizedDataObservable() {
        return this.internalPrioritizedDataObservable;
    }

    public void addDataObserver(Observer<DataProvider<M>, M> observer) {
        this.dataObservable.addObserver(observer);
    }

    public void removeDataObserver(Observer<DataProvider<M>, M> observer) {
        this.dataObservable.removeObserver(observer);
    }

    public void addConnectionStateObserver(Observer<Remote<?>, ConnectionStateType.ConnectionState.State> observer) {
        this.connectionStateObservable.addObserver(observer);
    }

    public void removeConnectionStateObserver(Observer<Remote<?>, ConnectionStateType.ConnectionState.State> observer) {
        this.connectionStateObservable.removeObserver(observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Long> ping() {
        SyncObject syncObject = this.pingLock;
        synchronized (syncObject) {
            if (this.shutdownInitiated) {
                return FutureProcessor.canceledFuture(Long.class, (Exception)((Object)new CouldNotPerformException("Ping canceled because of system shutdown!")));
            }
            if (this.pingTask == null || this.pingTask.isDone()) {
                this.pingTask = GlobalCachedExecutorService.submit(() -> {
                    Long l;
                    block16: {
                        ConnectionStateType.ConnectionState.State previousConnectionState = this.connectionState;
                        this.validateMiddleware();
                        Future internalTask = null;
                        try {
                            internalTask = this.rpcClient.callMethod("ping", Long.class, new Object[]{System.currentTimeMillis()});
                            Long requestTime = (Long)((RPCResponse)internalTask.get(JPService.testMode() ? PING_TEST_TIMEOUT : PING_TIMEOUT, TimeUnit.MILLISECONDS)).getResponse();
                            this.lastPingReceived = System.currentTimeMillis();
                            this.connectionPing = this.lastPingReceived - requestTime;
                            l = this.connectionPing;
                            if (internalTask == null || internalTask.isDone()) break block16;
                            internalTask.cancel(true);
                        }
                        catch (Throwable throwable) {
                            try {
                                if (internalTask != null && !internalTask.isDone()) {
                                    internalTask.cancel(true);
                                }
                                throw throwable;
                            }
                            catch (java.util.concurrent.TimeoutException ex) {
                                SyncObject requestTime = this.connectionMonitor;
                                synchronized (requestTime) {
                                    if (previousConnectionState == ConnectionStateType.ConnectionState.State.CONNECTED && this.connectionState == ConnectionStateType.ConnectionState.State.CONNECTED) {
                                        this.logger.warn("Remote connection to Controller[" + ScopeProcessor.generateStringRep((ScopeType.Scope)this.getScope()) + "] lost!");
                                        this.setConnectionState(ConnectionStateType.ConnectionState.State.CONNECTING);
                                    }
                                }
                                throw ex;
                            }
                            catch (InvalidStateException ex) {
                                switch (this.connectionState) {
                                    case CONNECTING: 
                                    case CONNECTED: {
                                        try {
                                            this.reinit();
                                            break;
                                        }
                                        catch (CouldNotPerformException exx) {
                                            ExceptionPrinter.printHistory((String)"Recovering middleware connection failed!", (Throwable)exx, (Logger)this.logger);
                                        }
                                    }
                                }
                                throw ex;
                            }
                        }
                    }
                    return l;
                });
            }
            return this.pingTask;
        }
    }

    public Long getPing() {
        return this.connectionPing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void skipSyncTasks() {
        CompletableFutureLite<M> currentSyncFuture = null;
        Future<M> currentSyncTask = null;
        SyncObject syncObject = this.syncMonitor;
        synchronized (syncObject) {
            if (this.syncFuture != null) {
                if (this.shutdownInitiated) {
                    currentSyncFuture = this.syncFuture;
                    this.syncFuture = null;
                }
                currentSyncTask = this.syncTask;
                this.syncTask = null;
            }
        }
        try {
            if (currentSyncFuture != null) {
                currentSyncFuture.cancel(true);
            }
        }
        catch (CancellationException ex) {
            ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not cancel synchronization because the cancellation was canceled!", (Throwable)ex), (Logger)this.logger, (LogLevel)LogLevel.WARN);
        }
        try {
            if (currentSyncTask != null) {
                currentSyncTask.cancel(true);
            }
        }
        catch (CancellationException ex) {
            ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not cancel synchronization because the cancellation was canceled!", (Throwable)ex), (Logger)this.logger, (LogLevel)LogLevel.WARN);
        }
    }

    public String toString() {
        try {
            return this.getClass().getSimpleName() + "[scope:" + ScopeProcessor.generateStringRep((ScopeType.Scope)this.scope) + "]";
        }
        catch (CouldNotPerformException ex) {
            return this.getClass().getSimpleName() + "[scope:?]";
        }
    }

    public long getTransactionId() throws NotAvailableException {
        if (this.transactionId == -1L) {
            throw new NotAvailableException("transaction id");
        }
        return this.transactionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSyncRunning() {
        SyncObject syncObject = this.syncMonitor;
        synchronized (syncObject) {
            return this.syncFuture != null && !this.syncFuture.isDone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void restartSyncTask() throws CouldNotPerformException {
        SyncObject syncObject = this.syncMonitor;
        synchronized (syncObject) {
            if (this.syncTask != null && !this.syncTask.isDone()) {
                this.syncTask.cancel(true);
                this.syncTask = null;
            }
            this.requestData();
        }
    }

    private class SyncTaskCallable
    implements Callable<M> {
        private Future<M> relatedFuture;

        private SyncTaskCallable() {
        }

        public void setRelatedFuture(Future<M> relatedFuture) {
            this.relatedFuture = relatedFuture;
        }

        private boolean isRelatedFutureCancelled() {
            return this.relatedFuture != null && this.relatedFuture.isCancelled();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public M call() throws CouldNotPerformException {
            Future internalFuture = null;
            boolean active = AbstractRemoteClient.this.isActive();
            ExecutionException lastException = null;
            try {
                try {
                    Message receivedData;
                    SyncObject syncObject;
                    AbstractRemoteClient.this.logger.trace("Request controller synchronization.");
                    long timeout = 500L;
                    while (true) {
                        if (Thread.interrupted()) {
                            throw new InterruptedException();
                        }
                        Thread.yield();
                        if (AbstractRemoteClient.this.getConnectionState() == ConnectionStateType.ConnectionState.State.RECONNECTING) {
                            AbstractRemoteClient.this.waitForConnectionState(ConnectionStateType.ConnectionState.State.CONNECTING);
                            AbstractRemoteClient.this.waitForMiddleware();
                        }
                        syncObject = AbstractRemoteClient.this.maintainerLock;
                        synchronized (syncObject) {
                            active = AbstractRemoteClient.this.isActive();
                            if (!active) {
                                if (!AbstractRemoteClient.this.shutdownInitiated) throw new InvalidStateException("Remote service is not active within ConnectionState[" + AbstractRemoteClient.this.getConnectionState().name() + "] and sync will be triggered after reactivation, so current sync is skipped.!");
                                if (AbstractRemoteClient.this.syncFuture == null) throw new InvalidStateException("Remote service is not active within ConnectionState[" + AbstractRemoteClient.this.getConnectionState().name() + "] and sync will be triggered after reactivation, so current sync is skipped.!");
                                if (AbstractRemoteClient.this.syncFuture.isDone()) throw new InvalidStateException("Remote service is not active within ConnectionState[" + AbstractRemoteClient.this.getConnectionState().name() + "] and sync will be triggered after reactivation, so current sync is skipped.!");
                                AbstractRemoteClient.this.syncFuture.cancel(true);
                                throw new InvalidStateException("Remote service is not active within ConnectionState[" + AbstractRemoteClient.this.getConnectionState().name() + "] and sync will be triggered after reactivation, so current sync is skipped.!");
                            }
                        }
                        AbstractRemoteClient.this.waitForMiddleware();
                        if (AbstractRemoteClient.this.shutdownInitiated) {
                            if (!AbstractRemoteClient.this.shutdownInitiated) return null;
                            if (AbstractRemoteClient.this.syncFuture == null) return null;
                            if (AbstractRemoteClient.this.syncFuture.isDone()) return null;
                            AbstractRemoteClient.this.syncFuture.cancel(true);
                            return null;
                        }
                        try {
                            AbstractRemoteClient.this.ping().get();
                            RPCResponse response = AbstractRemoteClient.this.internalRequestStatus().get(REQUEST_TIMEOUT, TimeUnit.MILLISECONDS);
                            try {
                                if (!AbstractRemoteClient.this.validateAndUpdateEventTimestamp(response.getProperties())) {
                                    AbstractRemoteClient.this.logger.debug("Skip request data on scope[" + AbstractRemoteClient.this.getScopeStringRep() + "] because an outdated event was received!");
                                    AbstractRemoteClient.this.applyDataUpdate(AbstractRemoteClient.this.data);
                                }
                            }
                            catch (CouldNotPerformException ex) {
                                ExceptionPrinter.printHistory((String)("Request data response does not contain valid creation timestamp on scope " + AbstractRemoteClient.this.getScopeStringRep()), (Throwable)ex, (Logger)AbstractRemoteClient.this.logger);
                            }
                            receivedData = (Message)response.getResponse();
                            if (timeout == 500L || timeout <= 15000L || !this.isRelatedFutureCancelled()) break;
                            AbstractRemoteClient.this.logger.info("Got response from Controller[" + ScopeProcessor.generateStringRep((ScopeType.Scope)AbstractRemoteClient.this.getScope()) + "] and continue processing.");
                        }
                        catch (ExecutionException | java.util.concurrent.TimeoutException ex) {
                            try {
                                if (ExceptionProcessor.isCausedByInterruption((Throwable)ex)) {
                                    throw new InterruptedException();
                                }
                                if (internalFuture != null) {
                                    internalFuture.cancel(true);
                                }
                                if (this.isRelatedFutureCancelled()) {
                                    Object m = AbstractRemoteClient.this.data;
                                    return m;
                                }
                                timeout = AbstractRemoteClient.generateTimeout(timeout);
                                if (ex instanceof ExecutionException && !(ExceptionProcessor.getInitialCause((Throwable)ex) instanceof java.util.concurrent.TimeoutException) && !(ExceptionProcessor.getInitialCause((Throwable)ex) instanceof TimeoutException)) {
                                    if (lastException == null) {
                                        lastException = (ExecutionException)ex;
                                    } else if (ExceptionProcessor.getInitialCauseMessage((Throwable)ex).equals(ExceptionProcessor.getInitialCauseMessage((Throwable)lastException))) {
                                        new FatalImplementationErrorException("Sync task failed twice with the same reason", (Object)this, (Throwable)ex);
                                    } else {
                                        lastException = (ExecutionException)ex;
                                    }
                                }
                                if (timeout > 15000L) {
                                    AbstractRemoteClient.this.logger.warn("Controller[" + ScopeProcessor.generateStringRep((ScopeType.Scope)AbstractRemoteClient.this.getScope()) + "] does not respond: " + ExceptionProcessor.getInitialCauseMessage((Throwable)ex) + "  Next retry timeout in " + (int)Math.floor(timeout / 1000L) + " sec.");
                                    continue;
                                }
                                AbstractRemoteClient.this.logger.debug("Controller[" + ScopeProcessor.generateStringRep((ScopeType.Scope)AbstractRemoteClient.this.getScope()) + "] does not respond: +ExceptionProcessor.getInitialCauseMessage(ex)+  Next retry timeout in " + (int)Math.floor(timeout / 1000L) + " sec.");
                                continue;
                            }
                            finally {
                                Thread.sleep(timeout);
                                continue;
                            }
                        }
                        break;
                    }
                    syncObject = AbstractRemoteClient.this.dataUpdateMonitor;
                    synchronized (syncObject) {
                        if (this.relatedFuture != null && this.relatedFuture.isCancelled()) {
                            return AbstractRemoteClient.this.data;
                        }
                    }
                    AbstractRemoteClient.this.applyDataUpdate(receivedData);
                    return receivedData;
                }
                catch (InterruptedException ex) {
                    if (internalFuture == null) return null;
                    internalFuture.cancel(true);
                    return null;
                }
            }
            catch (CancellationException | RejectedExecutionException | CouldNotPerformException ex) {
                if (!AbstractRemoteClient.this.shutdownInitiated && active && !AbstractRemoteClient.this.getConnectionState().equals((Object)ConnectionStateType.ConnectionState.State.DISCONNECTED) && !ExceptionProcessor.isCausedBySystemShutdown((Throwable)ex)) {
                    AbstractRemoteClient.this.syncTask = AbstractRemoteClient.this.sync();
                    throw (CouldNotPerformException)ExceptionPrinter.printHistoryAndReturnThrowable((Throwable)new CouldNotPerformException("Sync failed of " + AbstractRemoteClient.this.getScopeStringRep() + ". Try to recover...", ex), (Logger)AbstractRemoteClient.this.logger, (LogLevel)LogLevel.DEBUG);
                }
                AbstractRemoteClient.this.logger.debug("Sync aborted: " + ExceptionProcessor.getInitialCauseMessage((Throwable)ex));
                throw new CouldNotPerformException("Sync aborted of " + AbstractRemoteClient.this.getScopeStringRep(), ex);
            }
            catch (Exception ex) {
                throw (FatalImplementationErrorException)ExceptionPrinter.printHistoryAndReturnThrowable((Throwable)new FatalImplementationErrorException((Object)this, (Throwable)ex), (Logger)AbstractRemoteClient.this.logger);
            }
        }
    }
}

