/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.communication.controller;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.Descriptors;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kr.pe.kwonnam.slf4jlambda.LambdaLogger;
import kr.pe.kwonnam.slf4jlambda.LambdaLoggerFactory;
import org.openbase.jul.annotation.RPCMethod;
import org.openbase.jul.communication.config.CommunicatorConfig;
import org.openbase.jul.communication.iface.CommunicatorFactory;
import org.openbase.jul.communication.iface.Publisher;
import org.openbase.jul.communication.iface.RPCServer;
import org.openbase.jul.communication.mqtt.CommunicatorFactoryImpl;
import org.openbase.jul.communication.mqtt.DefaultCommunicatorConfig;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.ExceptionProcessor;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.InvalidStateException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.NotInitializedException;
import org.openbase.jul.exception.ShutdownInProgressException;
import org.openbase.jul.exception.TimeoutException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.extension.protobuf.BuilderSyncSetup;
import org.openbase.jul.extension.protobuf.ClosableDataBuilder;
import org.openbase.jul.extension.protobuf.ClosableDataBuilderImpl;
import org.openbase.jul.extension.protobuf.ClosableInterruptibleDataBuilderImpl;
import org.openbase.jul.extension.protobuf.MessageObservable;
import org.openbase.jul.extension.type.iface.ScopeProvider;
import org.openbase.jul.extension.type.iface.TransactionIdProvider;
import org.openbase.jul.extension.type.processing.ScopeProcessor;
import org.openbase.jul.iface.Activatable;
import org.openbase.jul.iface.Pingable;
import org.openbase.jul.iface.Readyable;
import org.openbase.jul.iface.Shutdownable;
import org.openbase.jul.pattern.ChangeListener;
import org.openbase.jul.pattern.Observer;
import org.openbase.jul.pattern.controller.MessageController;
import org.openbase.jul.pattern.provider.DataProvider;
import org.openbase.jul.schedule.BundledReentrantReadWriteLock;
import org.openbase.jul.schedule.CloseableInterruptibleReadLockWrapper;
import org.openbase.jul.schedule.CloseableInterruptibleWriteLockWrapper;
import org.openbase.jul.schedule.CloseableLockProvider;
import org.openbase.jul.schedule.CloseableReadLockWrapper;
import org.openbase.jul.schedule.CloseableWriteLockWrapper;
import org.openbase.jul.schedule.FutureProcessor;
import org.openbase.jul.schedule.GlobalCachedExecutorService;
import org.openbase.jul.schedule.ReadWriteLock;
import org.openbase.jul.schedule.SyncObject;
import org.openbase.jul.schedule.TimeoutSplitter;
import org.openbase.jul.schedule.WatchDog;
import org.openbase.type.communication.EventType;
import org.openbase.type.communication.ScopeType;
import org.openbase.type.domotic.state.AvailabilityStateType;
import org.slf4j.Logger;

public abstract class AbstractControllerServer<M extends AbstractMessage, MB extends AbstractMessage.Builder<MB>>
implements MessageController<M, MB>,
ScopeProvider,
DataProvider<M>,
Readyable,
TransactionIdProvider {
    public static final String SCOPE_ELEMENT_SUFFIX_CONTROL = "/ctrl";
    public static final String SCOPE_ELEMENT_SUFFIX_STATUS = "/status";
    public static final ScopeType.Scope SCOPE_SUFFIX_CONTROL = ScopeProcessor.generateScope((String)"/ctrl");
    public static final ScopeType.Scope SCOPE_SUFFIX_STATUS = ScopeProcessor.generateScope((String)"/status");
    private static final long NOTIFICATION_TIMEOUT = TimeUnit.SECONDS.toMillis(15L);
    public static final String RPC_REQUEST_STATUS = "requestStatus";
    protected final LambdaLogger logger = LambdaLoggerFactory.getLogger(this.getClass());
    private final Shutdownable.ShutdownDaemon shutdownDaemon;
    protected Publisher publisher;
    protected RPCServer server;
    protected WatchDog publisherWatchDog;
    protected WatchDog serverWatchDog;
    private final MB dataBuilder;
    private final Class<M> messageClass;
    private final SyncObject transactionIdLock = new SyncObject(this.getClass());
    protected final ReentrantReadWriteLock dataLock;
    private final BundledReentrantReadWriteLock manageLock;
    private final ReentrantReadWriteLock.ReadLock dataBuilderReadLock;
    private final ReentrantReadWriteLock.WriteLock dataBuilderWriteLock;
    protected ScopeType.Scope scope;
    private final SyncObject controllerAvailabilityMonitor = new SyncObject("ControllerAvailabilityMonitor");
    private AvailabilityStateType.AvailabilityState.State availabilityState;
    private volatile boolean initialized;
    private volatile boolean destroyed;
    private final MessageObservable dataObserver;
    private Future initialDataSyncFuture;
    private volatile long transaction_id = 0L;
    private final CommunicatorFactory factory = CommunicatorFactoryImpl.Companion.getInstance();

    public AbstractControllerServer(MB builder) throws InstantiationException {
        this.logger.debug("Create AbstractControllerServer for component " + this.getClass().getSimpleName() + ".");
        this.dataBuilder = builder;
        try {
            if (builder == null) {
                throw new NotAvailableException("builder");
            }
            this.availabilityState = AvailabilityStateType.AvailabilityState.State.OFFLINE;
            this.dataLock = new ReentrantReadWriteLock();
            this.dataBuilderReadLock = this.dataLock.readLock();
            this.dataBuilderWriteLock = this.dataLock.writeLock();
            this.manageLock = new BundledReentrantReadWriteLock(this.dataLock, true, (Object)this);
            this.messageClass = this.detectDataClass();
            this.dataObserver = new MessageObservable((Object)this);
            this.dataObserver.setExecutorService((ExecutorService)GlobalCachedExecutorService.getInstance().getExecutorService());
            this.initialized = false;
            this.destroyed = false;
            this.shutdownDaemon = Shutdownable.registerShutdownHook((Shutdownable)this, (long)this.getShutdownDelay());
        }
        catch (CouldNotPerformException ex) {
            throw new InstantiationException((Object)this, (Throwable)ex);
        }
    }

    protected long getShutdownDelay() {
        return 0L;
    }

    public void init(ScopeType.Scope scope) throws InitializationException, InterruptedException {
        this.init(scope, DefaultCommunicatorConfig.Companion.getInstance());
    }

    public void init(String scope) throws InitializationException, InterruptedException {
        try {
            this.init(ScopeProcessor.generateScope((String)scope));
        }
        catch (NullPointerException | CouldNotPerformException ex) {
            throw new InitializationException((Object)this, ex);
        }
    }

    public void init(ScopeType.Scope scope, CommunicatorConfig communicatorConfig) throws InitializationException, InterruptedException {
        this.manageLock.lockWriteInterruptibly((Object)this);
        try {
            boolean alreadyActivated = this.isActive();
            CommunicatorConfig internalCommunicatorConfig = communicatorConfig;
            if (scope == null) {
                throw new NotAvailableException("scope");
            }
            if (this.initialized | this.publisherWatchDog != null | this.serverWatchDog != null) {
                this.deactivate();
                this.reset();
            }
            this.scope = scope;
            String scopeStringRep = ScopeProcessor.generateStringRep((ScopeType.Scope)scope).toLowerCase();
            ScopeType.Scope internalScope = ScopeProcessor.generateScope((String)scopeStringRep);
            this.logger.debug("Init AbstractControllerServer for component " + this.getClass().getSimpleName() + " on " + scopeStringRep);
            this.publisher = this.factory.createPublisher(ScopeProcessor.concat((ScopeType.Scope)internalScope, (ScopeType.Scope)SCOPE_SUFFIX_STATUS), internalCommunicatorConfig);
            this.publisherWatchDog = new WatchDog((Activatable)this.publisher, "Publisher[" + ScopeProcessor.generateStringRep((ScopeType.Scope)this.publisher.getScope()) + "]");
            this.server = this.factory.createRPCServer(ScopeProcessor.concat((ScopeType.Scope)internalScope, (ScopeType.Scope)SCOPE_SUFFIX_CONTROL), internalCommunicatorConfig);
            this.registerMethods(this.server);
            try {
                this.server.registerMethods(Pingable.class, (Object)this);
            }
            catch (InvalidStateException invalidStateException) {
                // empty catch block
            }
            try {
                this.server.registerMethods(this.getClass(), (Object)this);
            }
            catch (InvalidStateException invalidStateException) {
                // empty catch block
            }
            this.serverWatchDog = new WatchDog((Activatable)this.server, "RPCServer[" + ScopeProcessor.generateStringRep((ScopeType.Scope)this.server.getScope()) + "]");
            this.publisherWatchDog.addObserver((source, data) -> {
                if (data == WatchDog.ServiceState.RUNNING) {
                    this.initialDataSyncFuture = GlobalCachedExecutorService.submit(() -> {
                        block4: {
                            try {
                                if (this.publisherWatchDog.isServiceDone() || this.serverWatchDog.isServiceDone()) {
                                    return;
                                }
                                this.publisherWatchDog.waitForServiceActivation();
                                this.serverWatchDog.waitForServiceActivation();
                                this.setAvailabilityState(AvailabilityStateType.AvailabilityState.State.ONLINE);
                                this.notifyChange();
                            }
                            catch (InterruptedException ex) {
                                Thread.currentThread().interrupt();
                            }
                            catch (CouldNotPerformException ex) {
                                if (ExceptionProcessor.isCausedBySystemShutdown((Throwable)ex)) break block4;
                                ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not trigger data sync!", (Throwable)ex), (Logger)this.logger, (LogLevel)LogLevel.ERROR);
                            }
                        }
                    });
                }
            });
            this.postInit();
            this.initialized = true;
            if (alreadyActivated) {
                this.activate();
            }
        }
        catch (NullPointerException | CouldNotPerformException ex) {
            throw new InitializationException((Object)this, ex);
        }
        finally {
            this.manageLock.unlockWrite((Object)this);
        }
    }

    protected void postInit() throws InitializationException, InterruptedException {
    }

    private Class<M> detectDataClass() throws CouldNotPerformException {
        try {
            Class<?> clazz = this.dataBuilder.getClass().getEnclosingClass();
            if (clazz == null) {
                throw new NotAvailableException("message class");
            }
            return clazz;
        }
        catch (NullPointerException | SecurityException | NotAvailableException ex) {
            throw new CouldNotPerformException("Could not detect message class of builder " + this.dataBuilder.getClass().getName() + "!", ex);
        }
    }

    public Class<M> getDataClass() {
        return this.messageClass;
    }

    public void activate() throws InterruptedException, CouldNotPerformException {
        this.manageLock.lockWriteInterruptibly((Object)this);
        try {
            this.validateInitialization();
            this.logger.debug("Activate AbstractControllerServer for: " + String.valueOf(this) + " on " + ScopeProcessor.generateStringRep((ScopeType.Scope)this.scope));
            this.setAvailabilityState(AvailabilityStateType.AvailabilityState.State.ACTIVATING);
            assert (this.serverWatchDog != null);
            assert (this.publisherWatchDog != null);
            this.serverWatchDog.activate();
            this.publisherWatchDog.activate();
        }
        finally {
            this.manageLock.unlockWrite((Object)this);
        }
    }

    public void deactivate() throws InterruptedException, CouldNotPerformException {
        this.manageLock.lockWriteInterruptibly((Object)this);
        try {
            try {
                this.validateInitialization();
            }
            catch (InvalidStateException ex) {
                this.manageLock.unlockWrite((Object)this);
                return;
            }
            if (this.initialDataSyncFuture != null && !this.initialDataSyncFuture.isDone()) {
                this.initialDataSyncFuture.cancel(true);
            }
            this.logger.debug("Deactivate AbstractControllerServer for: " + String.valueOf(this) + " on " + ScopeProcessor.generateStringRep((ScopeType.Scope)this.scope));
            if (this.serverWatchDog != null) {
                this.serverWatchDog.deactivate();
            }
            this.setAvailabilityState(AvailabilityStateType.AvailabilityState.State.DEACTIVATING);
            if (this.publisherWatchDog != null) {
                this.publisherWatchDog.deactivate();
            }
            this.setAvailabilityState(AvailabilityStateType.AvailabilityState.State.OFFLINE);
        }
        finally {
            this.manageLock.unlockWrite((Object)this);
        }
    }

    private void reset() {
        this.manageLock.lockWrite((Object)this);
        try {
            this.initialized = false;
            if (this.serverWatchDog != null) {
                this.serverWatchDog.shutdown();
                this.serverWatchDog = null;
            }
            if (this.publisherWatchDog != null) {
                this.publisherWatchDog.shutdown();
                this.publisherWatchDog = null;
            }
        }
        finally {
            this.manageLock.unlockWrite((Object)this);
        }
    }

    public void shutdown() {
        try {
            this.deactivate();
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((String)("Could not deactivate " + String.valueOf(this) + " during shutdown!"), (Throwable)ex, (Logger)this.logger);
        }
        catch (InterruptedException ex) {
            this.logger.debug("Deactivation of " + String.valueOf(this) + " skipped because of interruption. Shutdown will be continued...");
        }
        this.reset();
        this.destroyed = true;
        if (this.shutdownDaemon != null) {
            this.shutdownDaemon.cancel();
        }
    }

    public boolean isActive() {
        try {
            this.validateInitialization();
        }
        catch (InvalidStateException ex) {
            return false;
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return false;
        }
        return this.publisherWatchDog.isActive() && this.serverWatchDog.isActive();
    }

    public M getData() throws NotAvailableException {
        try {
            return (M)((AbstractMessage)this.cloneDataBuilder().build());
        }
        catch (Exception ex) {
            throw new NotAvailableException("Data", (Throwable)new CouldNotPerformException("Could not build message!", (Throwable)ex));
        }
    }

    public Future<M> getDataFuture() {
        try {
            return FutureProcessor.completedFuture(this.getData());
        }
        catch (NotAvailableException ex) {
            CompletableFuture future = new CompletableFuture();
            future.completeExceptionally(ex);
            return future;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAvailabilityState(AvailabilityStateType.AvailabilityState.State controllerAvailability) throws InterruptedException {
        SyncObject syncObject = this.controllerAvailabilityMonitor;
        synchronized (syncObject) {
            block14: {
                if (this.availabilityState.equals((Object)controllerAvailability)) {
                    return;
                }
                this.availabilityState = controllerAvailability;
                this.logger.debug(String.valueOf(this) + " is now " + controllerAvailability.name());
                try {
                    block15: {
                        if (!this.availabilityState.equals((Object)AvailabilityStateType.AvailabilityState.State.DEACTIVATING)) break block14;
                        this.validateInitialization();
                        if (this.publisher.isActive()) break block15;
                        this.logger.debug("Skip update notification because connection not established.");
                        return;
                    }
                    try {
                        try {
                            this.publisher.publish(EventType.Event.newBuilder().build(), true);
                        }
                        catch (CouldNotPerformException ex) {
                            throw new CouldNotPerformException("Could not notify change of " + String.valueOf(this) + "!", (Throwable)ex);
                        }
                    }
                    catch (NotInitializedException ex) {
                        this.logger.debug("Skip update notification because instance is not initialized.");
                    }
                    catch (CouldNotPerformException ex) {
                        ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not update communication service state in internal data object!", (Throwable)ex), (Logger)this.logger);
                    }
                }
                finally {
                    this.controllerAvailabilityMonitor.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForAvailabilityState(AvailabilityStateType.AvailabilityState.State availabilityState) throws InterruptedException {
        SyncObject syncObject = this.controllerAvailabilityMonitor;
        synchronized (syncObject) {
            while (!Thread.currentThread().isInterrupted()) {
                if (this.availabilityState.equals((Object)availabilityState)) {
                    return;
                }
                this.controllerAvailabilityMonitor.wait();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MB cloneDataBuilder() {
        try {
            this.dataBuilderReadLock.lockInterruptibly();
            try {
                AbstractMessage.Builder builder = this.dataBuilder.clone();
                return (MB)builder;
            }
            finally {
                this.dataBuilderReadLock.unlock();
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while cloning data builder", ex);
        }
    }

    public BuilderSyncSetup<MB> getBuilderSetup() {
        return new BuilderSyncSetup(this.dataBuilder, this.dataBuilderReadLock, this.dataBuilderWriteLock, (ChangeListener)this);
    }

    @Deprecated
    public ClosableDataBuilder<MB> getDataBuilder(Object consumer) {
        return new ClosableDataBuilderImpl(this.getBuilderSetup(), consumer);
    }

    @Deprecated
    public ClosableDataBuilder<MB> getDataBuilder(Object consumer, BuilderSyncSetup.NotificationStrategy notificationStrategy) {
        return new ClosableDataBuilderImpl(this.getBuilderSetup(), consumer, notificationStrategy);
    }

    public ClosableDataBuilder<MB> getDataBuilderInterruptible(Object consumer) throws InterruptedException {
        return new ClosableInterruptibleDataBuilderImpl(this.getBuilderSetup(), consumer);
    }

    public ClosableDataBuilder<MB> getDataBuilderInterruptible(Object consumer, BuilderSyncSetup.NotificationStrategy notificationStrategy) throws InterruptedException {
        return new ClosableInterruptibleDataBuilderImpl(this.getBuilderSetup(), consumer, notificationStrategy);
    }

    protected CloseableWriteLockWrapper getManageWriteLock(Object consumer) {
        return new CloseableWriteLockWrapper((ReadWriteLock)new BundledReentrantReadWriteLock(this.manageLock, true, consumer));
    }

    protected CloseableReadLockWrapper getManageReadLock(Object consumer) {
        return new CloseableReadLockWrapper((ReadWriteLock)new BundledReentrantReadWriteLock(this.manageLock, true, consumer));
    }

    protected CloseableWriteLockWrapper getManageWriteLockInterruptible(Object consumer) throws InterruptedException {
        return new CloseableInterruptibleWriteLockWrapper((ReadWriteLock)new BundledReentrantReadWriteLock(this.manageLock, true, consumer));
    }

    protected CloseableReadLockWrapper getManageReadLockInterruptible(Object consumer) throws InterruptedException {
        return new CloseableInterruptibleReadLockWrapper((ReadWriteLock)new BundledReentrantReadWriteLock(this.manageLock, true, consumer));
    }

    protected CloseableLockProvider getManageLock() {
        return new CloseableLockProvider(){

            public CloseableReadLockWrapper getCloseableReadLock(Object consumer) {
                return AbstractControllerServer.this.getManageReadLock(consumer);
            }

            public CloseableWriteLockWrapper getCloseableWriteLock(Object consumer) {
                return AbstractControllerServer.this.getManageWriteLock(consumer);
            }
        };
    }

    public ScopeType.Scope getScope() throws NotAvailableException {
        if (this.scope == null) {
            throw new NotAvailableException("scope", (Throwable)new InvalidStateException("communication service not initialized yet!"));
        }
        return this.scope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyChange() throws CouldNotPerformException, InterruptedException {
        M newData;
        block15: {
            this.logger.debug("Notify data change of {}", (Object)this);
            this.manageLock.lockWriteInterruptibly((Object)this);
            try {
                this.validateInitialization();
            }
            catch (NotInitializedException ex) {
                if (this.destroyed) {
                    this.manageLock.unlockWrite((Object)this);
                    return;
                }
                throw ex;
            }
            newData = this.updateDataToPublish(this.cloneDataBuilder());
            EventType.Event event = EventType.Event.newBuilder().setPayload(Any.pack(newData)).build();
            if (this.isActive()) {
                try {
                    this.waitForMiddleware(NOTIFICATION_TIMEOUT, TimeUnit.MILLISECONDS);
                    this.publisher.publish(event, true);
                }
                catch (TimeoutException ex) {
                    if (ExceptionProcessor.isCausedBySystemShutdown((Throwable)ex)) {
                        throw ex;
                    }
                    ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Skip data update notification because middleware is not ready since " + TimeUnit.MILLISECONDS.toSeconds(NOTIFICATION_TIMEOUT) + " seconds of " + String.valueOf(this) + "!", (Throwable)ex), (Logger)this.logger, (LogLevel)LogLevel.WARN);
                }
                catch (CouldNotPerformException ex) {
                    if (ExceptionProcessor.isCausedBySystemShutdown((Throwable)ex)) {
                        throw ex;
                    }
                    ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not inform about data change of " + String.valueOf(this) + "!", (Throwable)ex), (Logger)this.logger);
                }
            }
            try {
                this.notifyDataUpdate(newData);
                break block15;
            }
            catch (CouldNotPerformException ex) {
                ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not notify data update!", (Throwable)ex), (Logger)this.logger);
            }
            break block15;
            finally {
                this.manageLock.unlockWrite((Object)this);
            }
        }
        this.dataObserver.notifyObservers(newData);
    }

    protected M updateDataToPublish(MB dataBuilder) throws CouldNotPerformException {
        return (M)((AbstractMessage)dataBuilder.build());
    }

    protected void notifyDataUpdate(M data) throws CouldNotPerformException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setDataField(int fieldNumber, Object value) throws CouldNotPerformException {
        try {
            this.dataBuilderWriteLock.lockInterruptibly();
            try {
                Descriptors.FieldDescriptor findFieldByName = this.dataBuilder.getDescriptorForType().findFieldByNumber(fieldNumber);
                if (findFieldByName == null) {
                    throw new NotAvailableException("Field[" + fieldNumber + "] does not exist for type " + this.dataBuilder.getClass().getName());
                }
                this.dataBuilder.setField(findFieldByName, value);
            }
            finally {
                this.dataBuilderWriteLock.unlock();
            }
        }
        catch (NullPointerException | CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not set field [" + fieldNumber + "=" + String.valueOf(value) + "] for " + String.valueOf(this), ex);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while setting data field [" + fieldNumber + "]", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setDataField(String fieldName, Object value) throws CouldNotPerformException {
        try {
            this.dataBuilderWriteLock.lockInterruptibly();
            try {
                Descriptors.FieldDescriptor findFieldByName = this.dataBuilder.getDescriptorForType().findFieldByName(fieldName);
                if (findFieldByName == null) {
                    throw new NotAvailableException("Field[" + fieldName + "] does not exist for type " + this.dataBuilder.getClass().getName());
                }
                this.dataBuilder.setField(findFieldByName, value);
            }
            finally {
                this.dataBuilderWriteLock.unlock();
            }
        }
        catch (NullPointerException | CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not set field [" + fieldName + "=" + String.valueOf(value) + "] for " + String.valueOf(this), ex);
        }
        catch (InterruptedException ex) {
            throw new RuntimeException("Interrupted while setting data field [" + fieldName + "]", ex);
        }
    }

    protected final Object getDataField(String name) throws NotAvailableException {
        try {
            MB dataClone = this.cloneDataBuilder();
            Descriptors.FieldDescriptor findFieldByName = dataClone.getDescriptorForType().findFieldByName(name);
            if (findFieldByName == null) {
                throw new NotAvailableException("Field[" + name + "] does not exist for type " + dataClone.getClass().getName());
            }
            return dataClone.getField(findFieldByName);
        }
        catch (Exception ex) {
            throw new NotAvailableException(this.getClass(), name, (Throwable)ex);
        }
    }

    protected final boolean hasDataField(String name) throws CouldNotPerformException {
        try {
            MB dataClone = this.cloneDataBuilder();
            Descriptors.FieldDescriptor findFieldByName = dataClone.getDescriptorForType().findFieldByName(name);
            if (findFieldByName == null) {
                return false;
            }
            return dataClone.hasField(findFieldByName);
        }
        catch (Exception ex) {
            return false;
        }
    }

    protected final boolean supportsDataField(String name) throws CouldNotPerformException {
        try {
            Descriptors.FieldDescriptor findFieldByName = this.dataBuilder.getDescriptorForType().findFieldByName(name);
            return findFieldByName != null;
        }
        catch (NullPointerException ex) {
            return false;
        }
    }

    protected final Descriptors.FieldDescriptor getDataFieldDescriptor(int fieldId) {
        return this.cloneDataBuilder().getDescriptorForType().findFieldByNumber(fieldId);
    }

    public AvailabilityStateType.AvailabilityState.State getControllerAvailabilityState() {
        return this.availabilityState;
    }

    public void validateInitialization() throws NotInitializedException, InterruptedException {
        this.manageLock.lockReadInterruptibly((Object)this);
        try {
            if (!this.initialized) {
                if (this.shutdownDaemon.isShutdownInProgress()) {
                    throw new NotInitializedException("server", (Throwable)new ShutdownInProgressException("server"));
                }
                throw new NotInitializedException("server");
            }
        }
        finally {
            this.manageLock.unlockRead((Object)this);
        }
    }

    public void validateActivation() throws InvalidStateException {
        if (this.isShutdownInProgress()) {
            throw new InvalidStateException((Throwable)new ShutdownInProgressException((Object)this));
        }
        if (!this.isActive()) {
            throw new InvalidStateException(String.valueOf(this) + " not activated!");
        }
    }

    public void validateMiddleware() throws InvalidStateException {
        this.validateActivation();
        if (this.publisher == null || !this.publisher.isActive() || !this.publisherWatchDog.isServiceRunning()) {
            throw new InvalidStateException("Publisher of " + String.valueOf(this) + " not connected to middleware!");
        }
        if (this.server == null || !this.server.isActive() || !this.serverWatchDog.isServiceRunning()) {
            throw new InvalidStateException("Server of " + String.valueOf(this) + " not connected to middleware!");
        }
    }

    public void waitForMiddleware(long timeout, TimeUnit timeUnit) throws InterruptedException, CouldNotPerformException {
        TimeoutSplitter timeSplit = new TimeoutSplitter(timeout, timeUnit);
        this.validateActivation();
        this.publisherWatchDog.waitForServiceActivation(timeSplit.getTime(), TimeUnit.MILLISECONDS);
        this.serverWatchDog.waitForServiceActivation(timeSplit.getTime(), TimeUnit.MILLISECONDS);
    }

    public boolean isDataBuilderWriteLockedByCurrentThread() {
        return this.dataBuilderWriteLock.isHeldByCurrentThread();
    }

    public Future<Long> ping(Long timestamp) {
        try {
            this.validateMiddleware();
        }
        catch (InvalidStateException e) {
            try {
                this.waitForMiddleware(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                FutureProcessor.canceledFuture(Long.class, (Exception)ex);
            }
            catch (CouldNotPerformException ex) {
                FutureProcessor.canceledFuture(Long.class, (Exception)((Object)ex));
            }
        }
        return FutureProcessor.completedFuture((Object)timestamp);
    }

    @RPCMethod
    public M requestStatus() throws CouldNotPerformException {
        this.logger.trace("requestStatus of {}", (Object)this);
        try {
            return this.getData();
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw (CouldNotPerformException)ExceptionPrinter.printHistoryAndReturnThrowable((Throwable)new CouldNotPerformException("Could not request status update.", (Throwable)ex), (Logger)this.logger, (LogLevel)LogLevel.ERROR);
        }
    }

    public abstract void registerMethods(RPCServer var1) throws CouldNotPerformException;

    public boolean isDataAvailable() {
        return true;
    }

    public Boolean isReady() {
        try {
            this.validateInitialization();
            this.validateActivation();
            this.validateMiddleware();
            return true;
        }
        catch (InvalidStateException ex) {
            return false;
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public void waitForData() throws CouldNotPerformException, InterruptedException {
    }

    public void waitForData(long timeout, TimeUnit timeUnit) throws CouldNotPerformException, InterruptedException {
    }

    public void addDataObserver(Observer<DataProvider<M>, M> observer) {
        this.dataObserver.addObserver(observer);
    }

    public void removeDataObserver(Observer<DataProvider<M>, M> observer) {
        this.dataObserver.removeObserver(observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTransactionId() {
        SyncObject syncObject = this.transactionIdLock;
        synchronized (syncObject) {
            return this.transaction_id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long generateTransactionId() {
        SyncObject syncObject = this.transactionIdLock;
        synchronized (syncObject) {
            this.logger.trace("increment transaction id from {} to {}", (Object)this.transaction_id, (Object)(this.transaction_id + 1L));
            return ++this.transaction_id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTransactionId() throws CouldNotPerformException {
        try {
            this.dataBuilderWriteLock.lockInterruptibly();
            try {
                SyncObject syncObject = this.transactionIdLock;
                synchronized (syncObject) {
                    this.setDataField("transaction_id", (Object)this.generateTransactionId());
                }
            }
            finally {
                this.dataBuilderWriteLock.unlock();
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    public void validateData() throws InvalidStateException {
        if (this.isShutdownInProgress()) {
            throw new InvalidStateException(String.valueOf(this) + " not synchronized!", (Throwable)new ShutdownInProgressException((Object)this));
        }
        if (!this.isDataAvailable()) {
            throw new InvalidStateException(String.valueOf(this) + " not synchronized yet!", (Throwable)new NotAvailableException("data"));
        }
    }

    public boolean isShutdownInProgress() {
        return this.shutdownDaemon.isShutdownInProgress();
    }

    public String toString() {
        if (this.publisher == null) {
            return this.getClass().getSimpleName();
        }
        return this.getClass().getSimpleName() + "[" + ScopeProcessor.generateStringRep((ScopeType.Scope)this.publisher.getScope(), (String)"?") + "]";
    }
}

