/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.communication.controller;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import org.openbase.jps.core.JPService;
import org.openbase.jps.exception.JPNotAvailableException;
import org.openbase.jps.preset.JPTestMode;
import org.openbase.jul.communication.controller.AbstractIdentifiableRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.FatalImplementationErrorException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.InvalidStateException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.iface.Configurable;
import org.openbase.jul.pattern.ObservableImpl;
import org.openbase.jul.pattern.Observer;
import org.openbase.jul.pattern.controller.ConfigurableRemote;
import org.openbase.jul.schedule.SyncObject;
import org.openbase.type.communication.ScopeType;
import org.slf4j.Logger;

public abstract class AbstractConfigurableRemote<M extends Message, CONFIG extends Message>
extends AbstractIdentifiableRemote<M>
implements ConfigurableRemote<String, M, CONFIG>,
Configurable<String, CONFIG> {
    private final SyncObject CONFIG_LOCK = new SyncObject("ConfigLock");
    private final Class<CONFIG> configClass;
    private CONFIG config;
    private ScopeType.Scope currentScope;
    private final ObservableImpl<ConfigurableRemote<String, M, CONFIG>, CONFIG> configObservable;

    public AbstractConfigurableRemote(Class<M> dataClass, Class<CONFIG> configClass) {
        super(dataClass);
        this.configClass = configClass;
        this.configObservable = new ObservableImpl(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(CONFIG config) throws InitializationException, InterruptedException {
        SyncObject syncObject = this.CONFIG_LOCK;
        synchronized (syncObject) {
            try {
                if (config == null) {
                    throw new NotAvailableException("config");
                }
                this.currentScope = this.detectScope(config);
                try {
                    this.applyConfigUpdate(config);
                }
                catch (CouldNotPerformException ex) {
                    ExceptionPrinter.printHistory((String)("Could not apply config update for " + String.valueOf(this)), (Throwable)ex, (Logger)this.logger);
                    try {
                        if (((Boolean)((JPTestMode)JPService.getProperty(JPTestMode.class)).getValue()).booleanValue()) {
                            throw new FatalImplementationErrorException("Could not apply config update for " + String.valueOf(this), (Object)this, (Throwable)ex);
                        }
                    }
                    catch (JPNotAvailableException jPNotAvailableException) {
                        // empty catch block
                    }
                }
                super.init(this.currentScope);
            }
            catch (CouldNotPerformException ex) {
                throw new InitializationException((Object)this, (Throwable)ex);
            }
        }
    }

    public CONFIG applyConfigUpdate(CONFIG config) throws CouldNotPerformException, InterruptedException {
        SyncObject syncObject = this.CONFIG_LOCK;
        synchronized (syncObject) {
            try {
                this.config = config;
                this.configObservable.notifyObservers(config);
                try {
                    if (this.isActive() && !this.currentScope.equals((Object)this.detectScope(config))) {
                        this.currentScope = this.detectScope();
                        this.reinit(this.currentScope);
                    }
                }
                catch (CouldNotPerformException ex) {
                    throw new CouldNotPerformException("Could not verify scope changes!", (Throwable)ex);
                }
                try {
                    this.notifyConfigUpdate(config);
                }
                catch (CouldNotPerformException ex) {
                    ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not notify config update!", (Throwable)ex), (Logger)this.logger);
                }
                return this.config;
            }
            catch (CouldNotPerformException ex) {
                throw new CouldNotPerformException("Could not apply config update!", (Throwable)ex);
            }
        }
    }

    protected void notifyConfigUpdate(CONFIG config) throws CouldNotPerformException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScopeType.Scope detectScope() throws NotAvailableException {
        SyncObject syncObject = this.CONFIG_LOCK;
        synchronized (syncObject) {
            return this.detectScope(this.getConfig());
        }
    }

    private ScopeType.Scope detectScope(CONFIG config) throws NotAvailableException {
        try {
            return (ScopeType.Scope)this.getConfigField("scope", config);
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("scope");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Object getConfigField(String name) throws CouldNotPerformException {
        SyncObject syncObject = this.CONFIG_LOCK;
        synchronized (syncObject) {
            return this.getConfigField(name, this.getConfig());
        }
    }

    protected final Object getConfigField(String name, CONFIG config) throws CouldNotPerformException {
        try {
            Descriptors.FieldDescriptor findFieldByName = config.getDescriptorForType().findFieldByName(name);
            if (findFieldByName == null) {
                throw new NotAvailableException("Field[" + name + "] does not exist for type " + config.getClass().getName());
            }
            return config.getField(findFieldByName);
        }
        catch (Exception ex) {
            throw new CouldNotPerformException("Could not return value of config field [" + name + "] for " + String.valueOf(this), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean hasConfigField(String name) throws CouldNotPerformException {
        SyncObject syncObject = this.CONFIG_LOCK;
        synchronized (syncObject) {
            try {
                Descriptors.FieldDescriptor findFieldByName = this.config.getDescriptorForType().findFieldByName(name);
                if (findFieldByName == null) {
                    return false;
                }
                return this.config.hasField(findFieldByName);
            }
            catch (Exception ex) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean supportsConfigField(String name) throws CouldNotPerformException {
        SyncObject syncObject = this.CONFIG_LOCK;
        synchronized (syncObject) {
            try {
                Descriptors.FieldDescriptor findFieldByName = this.config.getDescriptorForType().findFieldByName(name);
                return findFieldByName != null;
            }
            catch (NullPointerException ex) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CONFIG getConfig() throws NotAvailableException {
        SyncObject syncObject = this.CONFIG_LOCK;
        synchronized (syncObject) {
            if (this.config == null) {
                throw new NotAvailableException("config");
            }
            return this.config;
        }
    }

    @Override
    public String getId() throws NotAvailableException {
        try {
            String tmpId = (String)this.getConfigField("id");
            if (tmpId.isEmpty()) {
                throw new InvalidStateException("config.id is empty!");
            }
            return tmpId;
        }
        catch (CouldNotPerformException ex) {
            this.logger.debug("Config does not contain the remote id!");
            return super.getId();
        }
    }

    public Class<CONFIG> getConfigClass() {
        return this.configClass;
    }

    public void addConfigObserver(Observer<ConfigurableRemote<String, M, CONFIG>, CONFIG> observer) {
        this.configObservable.addObserver(observer);
    }

    public void removeConfigObserver(Observer<ConfigurableRemote<String, M, CONFIG>, CONFIG> observer) {
        this.configObservable.removeObserver(observer);
    }

    @Override
    public void shutdown() {
        this.configObservable.shutdown();
        super.shutdown();
    }
}

