/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.communication.controller;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import org.openbase.jul.communication.controller.AbstractIdentifiableController;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.pattern.controller.ConfigurableController;
import org.openbase.jul.schedule.CloseableReadLockWrapper;
import org.openbase.jul.schedule.CloseableWriteLockWrapper;
import org.openbase.type.communication.ScopeType;

public abstract class AbstractConfigurableController<M extends AbstractMessage, MB extends AbstractMessage.Builder<MB>, CONFIG extends Message>
extends AbstractIdentifiableController<M, MB>
implements ConfigurableController<String, M, CONFIG> {
    public static final String FIELD_SCOPE = "scope";
    private CONFIG config;
    private ScopeType.Scope currentScope;

    public AbstractConfigurableController(MB builder) throws InstantiationException {
        super(builder);
    }

    public void init(CONFIG config) throws InitializationException, InterruptedException {
        try {
            try (CloseableWriteLockWrapper ignored = this.getManageWriteLockInterruptible(this);){
                if (config == null) {
                    throw new NotAvailableException("config");
                }
                this.currentScope = this.detectScope(config);
                this.applyConfigUpdate(config);
            }
            super.init(this.currentScope);
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CONFIG applyConfigUpdate(CONFIG config) throws CouldNotPerformException, InterruptedException {
        try (CloseableWriteLockWrapper ignored = this.getManageWriteLockInterruptible(this);){
            this.config = config;
            if (this.supportsDataField("id") && this.hasConfigField("id")) {
                this.setDataField("id", this.getConfigField("id"));
            }
            if (this.supportsDataField("label") && this.hasConfigField("label")) {
                this.setDataField("label", this.getConfigField("label"));
            }
            boolean scopeChanged = !this.currentScope.equals((Object)this.detectScope(config));
            this.currentScope = this.detectScope();
            try {
                if (this.isActive() && scopeChanged) {
                    super.init(this.currentScope);
                }
            }
            catch (CouldNotPerformException ex) {
                throw new CouldNotPerformException("Could not verify scope changes!", (Throwable)ex);
            }
            CONFIG CONFIG = this.config;
            return CONFIG;
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not apply config update!", (Throwable)ex);
        }
    }

    private ScopeType.Scope detectScope(CONFIG config) throws NotAvailableException {
        try {
            return (ScopeType.Scope)this.getConfigField(FIELD_SCOPE, config);
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException(FIELD_SCOPE);
        }
    }

    private ScopeType.Scope detectScope() throws NotAvailableException {
        try (CloseableReadLockWrapper ignored = this.getManageReadLock(this);){
            ScopeType.Scope scope = this.detectScope(this.getConfig());
            return scope;
        }
    }

    protected final Object getConfigField(String name) throws CouldNotPerformException {
        try (CloseableReadLockWrapper ignored = this.getManageReadLock(this);){
            Object object = this.getConfigField(name, this.getConfig());
            return object;
        }
    }

    protected final Object getConfigField(String name, CONFIG config) throws CouldNotPerformException {
        CloseableReadLockWrapper ignored = this.getManageReadLock(this);
        try {
            Descriptors.FieldDescriptor findFieldByName = config.getDescriptorForType().findFieldByName(name);
            if (findFieldByName == null) {
                throw new NotAvailableException("Field[" + name + "] does not exist for type " + config.getClass().getName());
            }
            Object object = config.getField(findFieldByName);
            return object;
        }
        catch (Exception ex) {
            throw new CouldNotPerformException("Could not return value of config field [" + name + "] for " + String.valueOf(this), (Throwable)ex);
        }
        finally {
            if (ignored != null) {
                try {
                    ignored.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    protected final boolean hasConfigField(String name) throws CouldNotPerformException {
        try (CloseableReadLockWrapper ignored = this.getManageReadLock(this);){
            Descriptors.FieldDescriptor findFieldByName = this.config.getDescriptorForType().findFieldByName(name);
            if (findFieldByName == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.config.hasField(findFieldByName);
            return bl;
        }
    }

    protected final boolean supportsConfigField(String name) throws CouldNotPerformException {
        try (CloseableReadLockWrapper ignored = this.getManageReadLock(this);){
            Descriptors.FieldDescriptor findFieldByName = this.config.getDescriptorForType().findFieldByName(name);
            boolean bl = findFieldByName != null;
            return bl;
        }
    }

    public CONFIG getConfig() throws NotAvailableException {
        try (CloseableReadLockWrapper ignored = this.getManageReadLock(this);){
            if (this.config == null) {
                throw new NotAvailableException("config");
            }
            CONFIG CONFIG = this.config;
            return CONFIG;
        }
    }
}

