[oolong](../index.md) / [oolong](./index.md)

## Package oolong

### Types

| Name | Summary |
|---|---|
| (common) [Dispatch](-dispatch.md) | A function to dispatch a Msg to the runtime in the runtime context.`typealias Dispatch<Msg> = (Msg) -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| (common) [Effect](-effect.md) | A function to run a side-effect in the effect context. Provides a Dispatch function to dispatch a Msg to the runtime in the runtime context.`typealias Effect<Msg> = suspend CoroutineScope.(`[`Dispatch`](-dispatch.md)`<Msg>) -> `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?` |

### Functions

| Name | Summary |
|---|---|
| (common) [effect](effect.md) | [Effect](-effect.md) builder function.`fun <Msg> effect(block: `[`Effect`](-effect.md)`<Msg>): `[`Effect`](-effect.md)`<Msg>` |
| (common) [init](init.md) | Init builder function.`fun <Model, Msg> init(block: () -> `[`Pair`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-pair/index.html)`<Model, `[`Effect`](-effect.md)`<Msg>>): () -> `[`Pair`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-pair/index.html)`<Model, `[`Effect`](-effect.md)`<Msg>>` |
| (common) [render](render.md) | Render builder function.`fun <Props, Msg> render(block: (Props, `[`Dispatch`](-dispatch.md)`<Msg>) -> `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?): (Props, `[`Dispatch`](-dispatch.md)`<Msg>) -> `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?` |
| (common) [runtime](runtime.md) | Create a runtime.`fun <Model, Msg> runtime(init: () -> `[`Pair`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-pair/index.html)`<Model, `[`Effect`](-effect.md)`<Msg>>, update: (Msg, Model) -> `[`Pair`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-pair/index.html)`<Model, `[`Effect`](-effect.md)`<Msg>>, view: (Model, `[`Dispatch`](-dispatch.md)`<Msg>) -> `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?, runtimeContext: `[`CoroutineContext`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.coroutines/-coroutine-context/index.html)` = Dispatchers.Default, renderContext: `[`CoroutineContext`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.coroutines/-coroutine-context/index.html)` = Dispatchers.Main, effectContext: `[`CoroutineContext`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.coroutines/-coroutine-context/index.html)` = Dispatchers.Default): Job`<br>`fun <Model, Msg, Props> runtime(init: () -> `[`Pair`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-pair/index.html)`<Model, `[`Effect`](-effect.md)`<Msg>>, update: (Msg, Model) -> `[`Pair`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-pair/index.html)`<Model, `[`Effect`](-effect.md)`<Msg>>, view: (Model) -> Props, render: (Props, `[`Dispatch`](-dispatch.md)`<Msg>) -> `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?, runtimeContext: `[`CoroutineContext`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.coroutines/-coroutine-context/index.html)` = Dispatchers.Default, renderContext: `[`CoroutineContext`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.coroutines/-coroutine-context/index.html)` = Dispatchers.Main, effectContext: `[`CoroutineContext`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.coroutines/-coroutine-context/index.html)` = Dispatchers.Default): Job` |
| (common) [update](update.md) | Update builder function.`fun <Model, Msg> update(block: (Msg, Model) -> `[`Pair`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-pair/index.html)`<Model, `[`Effect`](-effect.md)`<Msg>>): (Msg, Model) -> `[`Pair`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-pair/index.html)`<Model, `[`Effect`](-effect.md)`<Msg>>` |
| (common) [view](view.md) | View builder function.`fun <Model, Props> view(block: (Model) -> Props): (Model) -> Props` |
