/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.bundle.utilities;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeFileUtilities {
    private static Logger _log = LoggerFactory.getLogger(NativeFileUtilities.class);

    public int tarcvf(String baseDir, String[] paths, String filename) {
        Process process = null;
        try {
            StringBuffer cmd = new StringBuffer();
            cmd.append("tar -c -f " + filename + " -z -C " + baseDir + "  ");
            for (String path : paths) {
                cmd.append(path + " ");
            }
            _log.info("exec:" + cmd.toString());
            process = Runtime.getRuntime().exec(cmd.toString());
            return process.waitFor();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void copyFiles(File from, File to) {
        _log.debug("copying " + from + " to " + to);
        try {
            if (!from.exists()) {
                return;
            }
            if (from.equals(to) || to.getParent().equals(from)) {
                return;
            }
            if (to.exists() && to.isDirectory()) {
                if (from.exists() && from.isDirectory()) {
                    FileUtils.copyDirectory((File)from, (File)to, (boolean)true);
                    return;
                }
                String file = this.parseFileName(from.toString());
                to = new File(to.toString() + File.separator + file);
                _log.debug("constructed new destination=" + to.toString());
            }
            if (from.isDirectory()) {
                to.mkdirs();
                File[] files = from.listFiles();
                if (files == null) {
                    return;
                }
                for (File fromChild : files) {
                    File toChild = new File(to, fromChild.getName());
                    this.copyFiles(fromChild, toChild);
                }
            } else {
                FileUtils.copyFile((File)from, (File)to, (boolean)true);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public String parseFileName(String urlString) {
        return this.parseFileName(urlString, "/");
    }

    public String parseFileName(String urlString, String seperator) {
        if (urlString == null) {
            return null;
        }
        int i = urlString.lastIndexOf(seperator);
        if (i > 0 && i + 1 < urlString.length()) {
            return urlString.substring(i + 1, urlString.length());
        }
        if (i >= 0) {
            return this.parseFileName(urlString.substring(0, urlString.length() - 1));
        }
        return urlString;
    }
}

