/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.bundle.utilities;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.onebusaway.geospatial.services.SphericalGeometryLibrary;
import org.onebusaway.gtfs.model.Agency;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.serialization.GtfsReader;
import org.onebusaway.util.AgencyAndIdLibrary;
import org.onebusaway.utility.IOLibrary;
import org.onebusaway.utility.collections.TreeUnionFind;

public class GtfsStopsForMergingMain {
    private static final String ARG_CONSOLIDATED = "consolidated";
    private static final String ARG_DISTANCE = "distance";

    public static void main(String[] args) throws IOException, ParseException {
        Options options = new Options();
        options.addOption(ARG_DISTANCE, true, "");
        options.addOption(ARG_CONSOLIDATED, true, "");
        GnuParser parser = new GnuParser();
        CommandLine cli = parser.parse(options, args);
        args = cli.getArgs();
        if (args.length < 5) {
            GtfsStopsForMergingMain.usage();
            System.exit(-1);
        }
        double distanceThreshold = 20.0;
        if (cli.hasOption(ARG_DISTANCE)) {
            distanceThreshold = Double.parseDouble(cli.getOptionValue(ARG_DISTANCE));
        }
        TreeUnionFind<AgencyAndId> existingConsolidatedStops = new TreeUnionFind<AgencyAndId>();
        if (cli.hasOption(ARG_CONSOLIDATED)) {
            existingConsolidatedStops = GtfsStopsForMergingMain.loadExistingConsolidatedStops(cli.getOptionValue(ARG_CONSOLIDATED));
        }
        PrintWriter writer = GtfsStopsForMergingMain.getOutputAsWriter(args[args.length - 1]);
        TreeUnionFind union = new TreeUnionFind();
        ArrayList<Collection<Stop>> allStops = new ArrayList<Collection<Stop>>();
        for (int i = 0; i < args.length - 1; i += 2) {
            String path = args[i];
            String agencyId = args[i + 1];
            Collection<Stop> stops = GtfsStopsForMergingMain.readStopsFromGtfsPath(path, agencyId);
            for (Collection collection : allStops) {
                for (Stop stopA : collection) {
                    for (Stop stopB : stops) {
                        double d = SphericalGeometryLibrary.distance((double)stopA.getLat(), (double)stopA.getLon(), (double)stopB.getLat(), (double)stopB.getLon());
                        if (!(d < distanceThreshold) || existingConsolidatedStops.isSameSet((Object)stopA.getId(), (Object)stopB.getId())) continue;
                        union.union((Object)stopA.getId(), (Object)stopB.getId());
                    }
                }
            }
            allStops.add(stops);
        }
        for (Set set : union.getSetMembers()) {
            HashSet<TreeUnionFind.Sentry> existing = new HashSet<TreeUnionFind.Sentry>();
            boolean first = true;
            for (AgencyAndId agencyAndId : set) {
                if (first) {
                    first = false;
                } else {
                    writer.print(' ');
                }
                if (existingConsolidatedStops.contains((Object)agencyAndId)) {
                    existing.add(existingConsolidatedStops.find((Object)agencyAndId));
                }
                writer.print(AgencyAndIdLibrary.convertToString((AgencyAndId)agencyAndId));
            }
            writer.println();
            for (TreeUnionFind.Sentry sentry : existing) {
                writer.println("  => " + existingConsolidatedStops.members(sentry));
            }
            writer.flush();
        }
    }

    private static void usage() {
        System.err.println("usage: gtfs_feed agencyId gtfs_feed agencyId [...] output");
    }

    private static PrintWriter getOutputAsWriter(String value) throws IOException {
        if (value.equals("-")) {
            return new PrintWriter(new OutputStreamWriter(System.out));
        }
        return new PrintWriter(new FileWriter(value));
    }

    private static Collection<Stop> readStopsFromGtfsPath(String path, String defaultAgencyId) throws IOException {
        GtfsReader reader = new GtfsReader();
        reader.setInputLocation(new File(path));
        if (defaultAgencyId != null) {
            reader.setDefaultAgencyId(defaultAgencyId);
        }
        reader.readEntities(Agency.class);
        reader.readEntities(Stop.class);
        return reader.getEntityStore().getAllEntitiesForType(Stop.class);
    }

    private static TreeUnionFind<AgencyAndId> loadExistingConsolidatedStops(String path) throws IOException {
        InputStream in = IOLibrary.getPathAsInputStream((String)path);
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        TreeUnionFind consolidated = new TreeUnionFind();
        String line = null;
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("#") || line.startsWith("{{{") || line.startsWith("}}}") || line.length() == 0) continue;
            String[] tokens = line.split("\\s+");
            AgencyAndId stopId = AgencyAndIdLibrary.convertFromString((String)tokens[0]);
            for (int i = 1; i < tokens.length; ++i) {
                AgencyAndId otherStopId = AgencyAndIdLibrary.convertFromString((String)tokens[i]);
                consolidated.union((Object)stopId, (Object)otherStopId);
            }
        }
        reader.close();
        return consolidated;
    }
}

