/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.bundle.utilities;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.onebusaway.csv_entities.EntityHandler;
import org.onebusaway.gtfs.model.Agency;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.serialization.GtfsReader;
import org.onebusaway.transit_data_federation.bundle.model.GtfsBundle;
import org.onebusaway.transit_data_federation.bundle.utilities.UtilityLibrary;
import org.onebusaway.util.AgencyAndIdLibrary;
import org.onebusaway.utility.IOLibrary;

public class GtfsStopReplacementVerificationMain {
    public static void main(String[] args) throws IOException {
        Object reader;
        if (args.length == 0) {
            System.err.println("usage: stop-consolidation-file gtfs_path [gtfs_path:defaultAgencyId data-sources.xml ...]");
            System.exit(-1);
        }
        EntityHandlerImpl handler = new EntityHandlerImpl();
        ArrayList<String> paths = new ArrayList<String>();
        for (int i = 1; i < args.length; ++i) {
            paths.add(args[i]);
        }
        List<GtfsBundle> bundles = UtilityLibrary.getGtfsBundlesForArguments(paths);
        for (GtfsBundle bundle : bundles) {
            reader = new GtfsReader();
            reader.setDefaultAgencyId(bundle.getDefaultAgencyId());
            reader.setInputLocation(bundle.getPath());
            for (Map.Entry<String, String> entry : bundle.getAgencyIdMappings().entrySet()) {
                reader.addAgencyIdMapping(entry.getKey(), entry.getValue());
            }
            reader.getEntityClasses().retainAll(Arrays.asList(Agency.class, Stop.class));
            reader.addEntityHandler((EntityHandler)handler);
            reader.run();
        }
        Set<AgencyAndId> ids = handler.getIds();
        InputStream in = IOLibrary.getPathAsInputStream((String)args[0]);
        reader = new BufferedReader(new InputStreamReader(in));
        String line = null;
        while ((line = ((BufferedReader)reader).readLine()) != null) {
            String[] tokens;
            AgencyAndId id;
            if (line.startsWith("#") || line.startsWith("{{{") || line.startsWith("}}}") || line.length() == 0 || ids.contains(id = AgencyAndIdLibrary.convertFromString((String)(tokens = line.split("\\s+"))[0]))) continue;
            System.out.println(id + " <- " + line);
        }
    }

    private static class EntityHandlerImpl
    implements EntityHandler {
        private Set<AgencyAndId> _ids = new HashSet<AgencyAndId>();

        private EntityHandlerImpl() {
        }

        public Set<AgencyAndId> getIds() {
            return this._ids;
        }

        public void handleEntity(Object bean) {
            if (!(bean instanceof Stop)) {
                return;
            }
            Stop stop = (Stop)bean;
            this._ids.add(stop.getId());
        }
    }
}

