/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.bundle.utilities;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.onebusaway.container.ContainerLibrary;
import org.onebusaway.csv_entities.schema.DefaultEntitySchemaFactory;
import org.onebusaway.csv_entities.schema.EntitySchemaFactory;
import org.onebusaway.gtfs.impl.GtfsDaoImpl;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.serialization.GtfsEntitySchemaFactory;
import org.onebusaway.gtfs.serialization.GtfsWriter;
import org.onebusaway.gtfs.services.GenericMutableDao;
import org.onebusaway.gtfs.services.GtfsDao;
import org.onebusaway.transit_data_federation.bundle.tasks.GtfsReadingSupport;
import org.onebusaway.transit_data_federation.bundle.utilities.GenericAdditionalFieldMapping;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class GtfsCombinerMain {
    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            System.err.println("usage: bundle.xml output_path");
            System.exit(-1);
        }
        ArrayList<String> paths = new ArrayList<String>();
        paths.add(args[0]);
        ConfigurableApplicationContext context = ContainerLibrary.createContext(paths);
        GtfsDaoImpl store = new GtfsDaoImpl();
        DefaultEntitySchemaFactory schema = GtfsEntitySchemaFactory.createEntitySchemaFactory();
        GenericAdditionalFieldMapping.addGenericFieldMapping(schema, Stop.class, "stop_direction", "stopDirection");
        GenericAdditionalFieldMapping.addGenericFieldMapping(schema, Trip.class, "block_sequence_id", "blockSequenceId");
        GtfsReadingSupport.readGtfsIntoStore((ApplicationContext)context, (GenericMutableDao)store, schema);
        GtfsCombinerMain.writeGtfs(new File(args[1]), store, schema);
    }

    private static void writeGtfs(File outputDirectory, GtfsDaoImpl store, DefaultEntitySchemaFactory schema) throws IOException {
        GtfsWriter writer = new GtfsWriter();
        writer.setOutputLocation(outputDirectory);
        writer.setEntitySchemaFactory((EntitySchemaFactory)schema);
        writer.run((GtfsDao)store);
    }
}

