/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.bundle.tasks.transit_graph;

import java.io.File;
import org.onebusaway.container.refresh.RefreshService;
import org.onebusaway.transit_data_federation.bundle.tasks.transit_graph.AgencyEntriesFactory;
import org.onebusaway.transit_data_federation.bundle.tasks.transit_graph.BlockEntriesFactory;
import org.onebusaway.transit_data_federation.bundle.tasks.transit_graph.FrequencyEntriesFactory;
import org.onebusaway.transit_data_federation.bundle.tasks.transit_graph.RouteCollectionEntriesFactory;
import org.onebusaway.transit_data_federation.bundle.tasks.transit_graph.RouteEntriesFactory;
import org.onebusaway.transit_data_federation.bundle.tasks.transit_graph.StopEntriesFactory;
import org.onebusaway.transit_data_federation.bundle.tasks.transit_graph.TripEntriesFactory;
import org.onebusaway.transit_data_federation.impl.transit_graph.TransitGraphImpl;
import org.onebusaway.transit_data_federation.services.FederatedTransitDataBundle;
import org.onebusaway.utility.ObjectSerializationLibrary;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class TransitGraphTask
implements Runnable {
    private FederatedTransitDataBundle _bundle;
    private AgencyEntriesFactory _agencyEntriesFactory;
    private StopEntriesFactory _stopEntriesFactory;
    private RouteEntriesFactory _routeEntriesFactory;
    private RouteCollectionEntriesFactory _routeCollectionEntriesFactory;
    private TripEntriesFactory _tripEntriesFactory;
    private BlockEntriesFactory _blockEntriesFactory;
    private RefreshService _refreshService;
    private FrequencyEntriesFactory _frequencyEntriesFactory;

    @Autowired
    public void setBundle(FederatedTransitDataBundle bundle) {
        this._bundle = bundle;
    }

    @Autowired
    public void setAgencyEntriesFactory(AgencyEntriesFactory agencyEntiesFactory) {
        this._agencyEntriesFactory = agencyEntiesFactory;
    }

    @Autowired
    public void setStopEntriesFactory(StopEntriesFactory stopEntriesFactory) {
        this._stopEntriesFactory = stopEntriesFactory;
    }

    @Autowired
    public void setRouteEntriesFactory(RouteEntriesFactory routeEntriesFactory) {
        this._routeEntriesFactory = routeEntriesFactory;
    }

    @Autowired
    public void setRouteCollectionEntriesFactroy(RouteCollectionEntriesFactory routeCollectionEntriesFactory) {
        this._routeCollectionEntriesFactory = routeCollectionEntriesFactory;
    }

    @Autowired
    public void setTripEntriesFactory(TripEntriesFactory tripEntriesFactory) {
        this._tripEntriesFactory = tripEntriesFactory;
    }

    @Autowired
    public void setBlockEntriesFactory(BlockEntriesFactory blockEntriesFactory) {
        this._blockEntriesFactory = blockEntriesFactory;
    }

    @Autowired
    public void setFrequencyEntriesFactory(FrequencyEntriesFactory frequencyEntriesFactory) {
        this._frequencyEntriesFactory = frequencyEntriesFactory;
    }

    @Autowired
    public void setRefreshService(RefreshService refreshService) {
        this._refreshService = refreshService;
    }

    @Override
    @Transactional
    public void run() {
        TransitGraphImpl graph = new TransitGraphImpl();
        this._agencyEntriesFactory.processAgencies(graph);
        this._stopEntriesFactory.processStops(graph);
        this._routeEntriesFactory.processRoutes(graph);
        this._routeCollectionEntriesFactory.processRouteCollections(graph);
        this._tripEntriesFactory.processTrips(graph);
        this._blockEntriesFactory.processBlocks(graph);
        this._frequencyEntriesFactory.processFrequencies(graph);
        graph.initialize();
        try {
            ObjectSerializationLibrary.writeObject((File)this._bundle.getTransitGraphPath(), (Object)graph);
        }
        catch (Exception ex) {
            throw new IllegalStateException("error writing graph to file", ex);
        }
        this._refreshService.refresh("routeCollectionsData");
        this._refreshService.refresh("transitGraph");
    }
}

