/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.bundle.tasks.transit_graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.onebusaway.collections.FactoryMap;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.onebusaway.transit_data.model.EAccessibility;
import org.onebusaway.transit_data_federation.impl.transit_graph.AgencyEntryImpl;
import org.onebusaway.transit_data_federation.impl.transit_graph.StopEntryImpl;
import org.onebusaway.transit_data_federation.impl.transit_graph.TransitGraphImpl;
import org.onebusaway.transit_data_federation.services.transit_graph.StopEntry;
import org.onebusaway.transit_data_federation.util.LoggingIntervalUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StopEntriesFactory {
    private Logger _log = LoggerFactory.getLogger(StopEntriesFactory.class);
    private GtfsRelationalDao _gtfsDao;

    @Autowired
    public void setGtfsDao(GtfsRelationalDao gtfsDao) {
        this._gtfsDao = gtfsDao;
    }

    public void processStops(TransitGraphImpl graph) {
        int stopIndex = 0;
        Collection stops = this._gtfsDao.getAllStops();
        int logInterval = LoggingIntervalUtil.getAppropriateLoggingInterval((int)stops.size());
        FactoryMap stopEntriesByAgencyId = new FactoryMap(new ArrayList());
        for (Stop stop : stops) {
            if (stopIndex % logInterval == 0) {
                this._log.info("stops: " + stopIndex + "/" + stops.size());
            }
            ++stopIndex;
            StopEntryImpl stopEntry = stop.getParentStation() != null ? new StopEntryImpl(stop.getId(), stop.getLat(), stop.getLon(), new AgencyAndId(stop.getId().getAgencyId(), stop.getParentStation())) : new StopEntryImpl(stop.getId(), stop.getLat(), stop.getLon());
            stopEntry.setWheelchairBoarding(this.getWheelchairBoardingAccessibilityForStop(stop));
            graph.putStopEntry(stopEntry);
            ((ArrayList)stopEntriesByAgencyId.get(stop.getId().getAgencyId())).add(stopEntry);
        }
        for (Map.Entry entry : stopEntriesByAgencyId.entrySet()) {
            String agencyId = (String)entry.getKey();
            ArrayList stopEntries = (ArrayList)entry.getValue();
            stopEntries.trimToSize();
            AgencyEntryImpl agency = graph.getAgencyForId(agencyId);
            if (agency == null) {
                String msg = null;
                msg = stopEntries.size() > 0 ? "no agency found for agencyId=" + agencyId + " of stop entry " + ((StopEntry)stopEntries.get(0)).getId() : "no agency found for agencyId=" + agencyId + " of empty stop entry list.";
                this._log.error(msg);
                throw new IllegalStateException(msg);
            }
            agency.setStops((List)stopEntries);
        }
        graph.refreshStopMapping();
    }

    private EAccessibility getWheelchairBoardingAccessibilityForStop(Stop stop) {
        switch (stop.getWheelchairBoarding()) {
            case 1: {
                return EAccessibility.ACCESSIBLE;
            }
            case 2: {
                return EAccessibility.NOT_ACCESSIBLE;
            }
            case 3: {
                return EAccessibility.PARTIALLY_ACCESSIBLE;
            }
        }
        return EAccessibility.UNKNOWN;
    }
}

