/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.bundle.tasks.transit_graph;

import java.util.Collection;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.onebusaway.transit_data_federation.bundle.services.UniqueService;
import org.onebusaway.transit_data_federation.impl.transit_graph.RouteEntryImpl;
import org.onebusaway.transit_data_federation.impl.transit_graph.TransitGraphImpl;
import org.onebusaway.transit_data_federation.util.LoggingIntervalUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RouteEntriesFactory {
    private Logger _log = LoggerFactory.getLogger(RouteEntriesFactory.class);
    private UniqueService _uniqueService;
    private GtfsRelationalDao _gtfsDao;

    @Autowired
    public void setUniqueService(UniqueService uniqueService) {
        this._uniqueService = uniqueService;
    }

    @Autowired
    public void setGtfsDao(GtfsRelationalDao gtfsDao) {
        this._gtfsDao = gtfsDao;
    }

    public void processRoutes(TransitGraphImpl graph) {
        Collection routes = this._gtfsDao.getAllRoutes();
        int numRoutes = routes.size();
        int logInterval = LoggingIntervalUtil.getAppropriateLoggingInterval((int)numRoutes);
        int routeIndex = 0;
        for (Route route : routes) {
            if (routeIndex % logInterval == 0) {
                this._log.info("route processed: " + routeIndex + "/" + numRoutes);
            }
            ++routeIndex;
            this.processRoute(graph, route);
        }
        graph.refreshRouteMapping();
    }

    private RouteEntryImpl processRoute(TransitGraphImpl graph, Route route) {
        RouteEntryImpl routeEntry = new RouteEntryImpl();
        routeEntry.setId(this.unique(route.getId()));
        routeEntry.setType(route.getType());
        graph.putRouteEntry(routeEntry);
        return routeEntry;
    }

    private <T> T unique(T value) {
        return this._uniqueService.unique(value);
    }
}

