/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.bundle.tasks.transit_graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.onebusaway.collections.MappingLibrary;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.Frequency;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.onebusaway.transit_data_federation.impl.blocks.FrequencyComparator;
import org.onebusaway.transit_data_federation.impl.transit_graph.BlockConfigurationEntryImpl;
import org.onebusaway.transit_data_federation.impl.transit_graph.BlockEntryImpl;
import org.onebusaway.transit_data_federation.impl.transit_graph.FrequencyEntryImpl;
import org.onebusaway.transit_data_federation.impl.transit_graph.TransitGraphImpl;
import org.onebusaway.transit_data_federation.impl.transit_graph.TripEntryImpl;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockTripEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.FrequencyEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TripEntry;
import org.onebusaway.transit_data_federation.util.LoggingIntervalUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FrequencyEntriesFactory {
    private Logger _log = LoggerFactory.getLogger(FrequencyEntriesFactory.class);
    private GtfsRelationalDao _gtfsDao;

    @Autowired
    public void setGtfsDao(GtfsRelationalDao gtfsDao) {
        this._gtfsDao = gtfsDao;
    }

    public void processFrequencies(TransitGraphImpl graph) {
        HashMap<AgencyAndId, List<FrequencyEntry>> frequenciesByTripId = new HashMap<AgencyAndId, List<FrequencyEntry>>();
        Collection allFrequencies = this._gtfsDao.getAllFrequencies();
        int logInterval = LoggingIntervalUtil.getAppropriateLoggingInterval((int)(allFrequencies.size() * 10));
        int frequencyIndex = 0;
        HashMap<AgencyAndId, Integer> exactTimesValueByTrip = new HashMap<AgencyAndId, Integer>();
        for (Object frequency : allFrequencies) {
            if (frequencyIndex % logInterval == 0) {
                this._log.info("frequencies: " + frequencyIndex++ + "/" + allFrequencies.size());
            }
            ++frequencyIndex;
            this.processRawFrequency(graph, (Frequency)frequency, frequenciesByTripId, exactTimesValueByTrip);
        }
        FrequencyComparator comparator = new FrequencyComparator();
        for (List list : frequenciesByTripId.values()) {
            Collections.sort(list, comparator);
        }
        int blockIndex = 0;
        Map tripsByBlockId = MappingLibrary.mapToValueList((Iterable)graph.getTrips(), (String)"block.id");
        for (Map.Entry entry : tripsByBlockId.entrySet()) {
            if (blockIndex % 10 == 0) {
                this._log.info("block: " + blockIndex + "/" + tripsByBlockId.size());
            }
            ++blockIndex;
            AgencyAndId blockId = (AgencyAndId)entry.getKey();
            List tripsInBlock = (List)entry.getValue();
            HashMap<AgencyAndId, List<FrequencyEntry>> frequenciesAlongBlockByTripId = new HashMap<AgencyAndId, List<FrequencyEntry>>();
            for (TripEntryImpl trip : tripsInBlock) {
                List frequencies = (List)frequenciesByTripId.get(trip.getId());
                if (frequencies == null) continue;
                frequenciesAlongBlockByTripId.put(trip.getId(), frequencies);
            }
            this.checkForInvalidFrequencyConfigurations(blockId, tripsInBlock, frequenciesAlongBlockByTripId);
            this.applyFrequenciesToBlockTrips(tripsInBlock, frequenciesAlongBlockByTripId);
        }
    }

    private void processRawFrequency(TransitGraphImpl graph, Frequency frequency, Map<AgencyAndId, List<FrequencyEntry>> frequenciesByTripId, Map<AgencyAndId, Integer> exactTimesValueByTrip) {
        AgencyAndId tripId = frequency.getTrip().getId();
        Integer exactTimesValue = exactTimesValueByTrip.get(tripId);
        if (exactTimesValue == null) {
            exactTimesValue = frequency.getExactTimes();
            exactTimesValueByTrip.put(tripId, exactTimesValue);
        } else if (exactTimesValue.intValue() != frequency.getExactTimes()) {
            throw new IllegalStateException("The value of frequencies.txt exact_times differed for frequency entries with tripId=" + tripId);
        }
        FrequencyEntryImpl entry = new FrequencyEntryImpl(frequency.getStartTime(), frequency.getEndTime(), frequency.getHeadwaySecs(), frequency.getExactTimes());
        List<FrequencyEntry> frequencies = frequenciesByTripId.get(tripId);
        if (frequencies == null) {
            frequencies = new ArrayList<FrequencyEntry>();
            frequenciesByTripId.put(tripId, frequencies);
        }
        frequencies.add((FrequencyEntry)entry);
    }

    private void checkForInvalidFrequencyConfigurations(AgencyAndId blockId, List<TripEntryImpl> tripsInBlock, Map<AgencyAndId, List<FrequencyEntry>> frequenciesAlongBlockByTripId) {
        if (!frequenciesAlongBlockByTripId.isEmpty() && frequenciesAlongBlockByTripId.size() < tripsInBlock.size()) {
            throw new IllegalStateException("can't have mixture of trips with and without frequencies: blockId=" + blockId);
        }
    }

    private void applyFrequenciesToBlockTrips(List<TripEntryImpl> tripsInBlock, Map<AgencyAndId, List<FrequencyEntry>> frequenciesAlongBlockByTripId) {
        BlockEntryImpl blockEntry = tripsInBlock.get(0).getBlock();
        List configurations = blockEntry.getConfigurations();
        for (int i = 0; i < configurations.size(); ++i) {
            BlockConfigurationEntryImpl blockConfig = (BlockConfigurationEntryImpl)configurations.get(i);
            List<FrequencyEntry> frequencies = this.computeBlockFrequencies(blockEntry, blockConfig.getTrips(), frequenciesAlongBlockByTripId);
            blockConfig.setFrequencies(frequencies);
        }
    }

    private List<FrequencyEntry> computeBlockFrequencies(BlockEntryImpl block, List<BlockTripEntry> trips, Map<AgencyAndId, List<FrequencyEntry>> frequenciesAlongBlock) {
        List<FrequencyEntry> frequencies = null;
        for (BlockTripEntry blockTrip : trips) {
            TripEntry trip = blockTrip.getTrip();
            List<FrequencyEntry> potentialFrequencies = frequenciesAlongBlock.get(trip.getId());
            if (frequencies == null) {
                frequencies = potentialFrequencies;
                continue;
            }
            if (frequencies.equals(potentialFrequencies)) continue;
            throw new IllegalStateException("frequency-based trips in same block don't have same frequencies: blockId=" + block.getId());
        }
        return frequencies;
    }
}

