/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.bundle.tasks.transit_graph;

import java.util.Collection;
import org.onebusaway.gtfs.model.Agency;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.onebusaway.transit_data_federation.bundle.services.UniqueService;
import org.onebusaway.transit_data_federation.impl.transit_graph.AgencyEntryImpl;
import org.onebusaway.transit_data_federation.impl.transit_graph.TransitGraphImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AgencyEntriesFactory {
    private UniqueService _uniqueService;
    private GtfsRelationalDao _gtfsDao;

    @Autowired
    public void setUniqueService(UniqueService uniqueService) {
        this._uniqueService = uniqueService;
    }

    @Autowired
    public void setGtfsDao(GtfsRelationalDao gtfsDao) {
        this._gtfsDao = gtfsDao;
    }

    public void processAgencies(TransitGraphImpl graph) {
        Collection agencies = this._gtfsDao.getAllAgencies();
        for (Agency agency : agencies) {
            AgencyEntryImpl agencyEntry = new AgencyEntryImpl();
            agencyEntry.setId(this._uniqueService.unique(agency.getId()));
            graph.putAgencyEntry(agencyEntry);
        }
        graph.refreshAgencyMapping();
    }
}

