/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.bundle.tasks.stif.model;

import java.util.HashMap;

public enum ServiceCode {
    WEEKDAY_SCHOOL_OPEN,
    WEEKDAY_SCHOOL_CLOSED,
    SATURDAY,
    SUNDAY,
    MLK,
    PRESIDENTS_DAY,
    MEMORIAL_DAY,
    GOOD_FRIDAY,
    LABOR_DAY,
    JULY_FOURTH,
    COLUMBUS_DAY,
    THANKSGIVING,
    DAY_AFTER_THANKSGIVING,
    CHRISTMAS_EVE,
    CHRISTMAS_DAY,
    CHRISTMAS_DAY_OBSERVED,
    CHRISTMAS_WEEK,
    NEW_YEARS_EVE,
    NEW_YEARS_DAY,
    NEW_YEARS_DAY_OBSERVED;

    static HashMap<String, ServiceCode> serviceCodeForGtfsId;
    static HashMap<ServiceCode, String> letterCodeForServiceCode;

    public static ServiceCode getServiceCodeForId(String id) {
        return serviceCodeForGtfsId.get(id);
    }

    private static void mapServiceCode(String string, ServiceCode serviceCode) {
        serviceCodeForGtfsId.put(string, serviceCode);
        if (Character.isLetter(string.charAt(0))) {
            letterCodeForServiceCode.put(serviceCode, string);
        }
    }

    public static ServiceCode getServiceCodeForMTAHastusGTFS(String id) {
        String[] serviceIdParts = id.split("_");
        if (serviceIdParts.length != 2) {
            return null;
        }
        String[] serviceIdSubparts = serviceIdParts[1].split("-");
        if (serviceIdParts.length < 2) {
            return null;
        }
        String pickCode = serviceIdSubparts[0].toUpperCase();
        char pickCodeWithoutYear = pickCode.toCharArray()[0];
        if (pickCodeWithoutYear <= 'G') {
            if (id.contains("Weekday")) {
                if (id.contains("SDon")) {
                    return WEEKDAY_SCHOOL_OPEN;
                }
                return WEEKDAY_SCHOOL_CLOSED;
            }
            if (id.contains("Saturday")) {
                return SATURDAY;
            }
            if (id.contains("Sunday")) {
                return SUNDAY;
            }
            return null;
        }
        return serviceCodeForGtfsId.get(Character.toString(pickCodeWithoutYear));
    }

    public String getLetterCode() {
        return letterCodeForServiceCode.get((Object)this);
    }

    public boolean isHoliday() {
        return this != WEEKDAY_SCHOOL_OPEN && this != WEEKDAY_SCHOOL_CLOSED && this != SATURDAY && this != SUNDAY;
    }

    static {
        serviceCodeForGtfsId = new HashMap();
        letterCodeForServiceCode = new HashMap();
        ServiceCode.mapServiceCode("1", WEEKDAY_SCHOOL_OPEN);
        ServiceCode.mapServiceCode("11", WEEKDAY_SCHOOL_CLOSED);
        ServiceCode.mapServiceCode("2", SATURDAY);
        ServiceCode.mapServiceCode("3", SUNDAY);
        ServiceCode.mapServiceCode("E", WEEKDAY_SCHOOL_OPEN);
        ServiceCode.mapServiceCode("C", WEEKDAY_SCHOOL_CLOSED);
        ServiceCode.mapServiceCode("A", SATURDAY);
        ServiceCode.mapServiceCode("D", SUNDAY);
        ServiceCode.mapServiceCode("H", MLK);
        ServiceCode.mapServiceCode("I", PRESIDENTS_DAY);
        ServiceCode.mapServiceCode("J", GOOD_FRIDAY);
        ServiceCode.mapServiceCode("K", MEMORIAL_DAY);
        ServiceCode.mapServiceCode("M", JULY_FOURTH);
        ServiceCode.mapServiceCode("N", LABOR_DAY);
        ServiceCode.mapServiceCode("O", COLUMBUS_DAY);
        ServiceCode.mapServiceCode("R", THANKSGIVING);
        ServiceCode.mapServiceCode("S", DAY_AFTER_THANKSGIVING);
        ServiceCode.mapServiceCode("T", CHRISTMAS_EVE);
        ServiceCode.mapServiceCode("U", CHRISTMAS_DAY);
        ServiceCode.mapServiceCode("V", CHRISTMAS_DAY_OBSERVED);
        ServiceCode.mapServiceCode("W", CHRISTMAS_WEEK);
        ServiceCode.mapServiceCode("X", NEW_YEARS_EVE);
        ServiceCode.mapServiceCode("Y", NEW_YEARS_DAY);
        ServiceCode.mapServiceCode("Z", NEW_YEARS_DAY_OBSERVED);
    }
}

