/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.bundle.tasks.stif.model;

import org.onebusaway.transit_data_federation.bundle.tasks.stif.model.EventFieldSetter;
import org.onebusaway.transit_data_federation.bundle.tasks.stif.model.EventRecord;
import org.onebusaway.transit_data_federation.bundle.tasks.stif.model.StifFieldDefinition;
import org.onebusaway.transit_data_federation.bundle.tasks.stif.model.StifFieldSetter;
import org.onebusaway.transit_data_federation.bundle.tasks.stif.model.StifRecordFactory;

public class EventRecordFactory
extends StifRecordFactory<EventRecord> {
    private static StifFieldDefinition[] fields = new StifFieldDefinition[]{new FieldDef(2, "record type", null), new FieldDef(4, "location", new EventFieldSetter(){

        @Override
        public void setField(EventRecord record) {
            record.setLocation(this.getStringData());
        }
    }), new FieldDef(8, "event time", new EventFieldSetter(){

        @Override
        public void setField(EventRecord record) {
            record.setTime(this.getTimeFromCentiminutesSafe());
        }
    }), new FieldDef(2, "event type", null), new FieldDef(1, "stop flag", new EventFieldSetter(){

        @Override
        public void setField(EventRecord record) {
            record.setRevenue("S".equals(this.getStringData()));
        }
    }), new FieldDef(1, "timepoint flag", new EventFieldSetter(){

        @Override
        public void setField(EventRecord record) {
            record.setTimepoint("T".equals(this.getStringData()));
        }
    }), new FieldDef(2, "location type code", new EventFieldSetter(){

        @Override
        public void setField(EventRecord record) {
            record.setLocationTypeCode(this.getStringData());
        }
    }), new FieldDef(1, "boarding / alighting flag", new EventFieldSetter(){

        @Override
        public void setField(EventRecord record) {
            String data = this.getStringData();
            int flag = 4;
            if ("A".equals(data)) {
                flag = 2;
            } else if ("B".equals(data)) {
                flag = 1;
            } else if ("E".equals(data)) {
                flag = 3;
            } else if ("N".equals(data)) {
                flag = 0;
            }
            record.setBoardAlightFlag(flag);
        }
    }), new FieldDef(2, "empty", null), new FieldDef(5, "distance from Start of Trip", new EventFieldSetter(){

        @Override
        public void setField(EventRecord record) {
            record.setDistanceFromStartOfTrip(this.getIntegerSafe());
        }
    })};

    @Override
    public EventRecord createEmptyRecord() {
        return new EventRecord();
    }

    @Override
    public StifFieldDefinition<EventRecord>[] getFields() {
        return fields;
    }

    static class FieldDef
    extends StifFieldDefinition<EventRecord> {
        public FieldDef(int length, String name, StifFieldSetter<EventRecord> setter) {
            super(length, name, setter);
        }
    }
}

