/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.bundle.tasks.stif;

import java.io.Serializable;
import java.util.Formatter;

public class TripIdentifier
implements Serializable {
    private static final long serialVersionUID = 1L;
    public int startTime;
    public String routeName;
    public String startStop;
    public String run;
    public String block;
    public int endTime;

    public TripIdentifier(String routeName, int startTime, int endTime, String startStop, String run, String block) {
        this.routeName = routeName;
        this.startTime = startTime;
        this.startStop = startStop;
        this.endTime = endTime;
        this.run = run;
        this.block = block;
    }

    private String gtfsAndStifTimeFormat(int time) {
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb);
        int hours = time / 3600;
        int minutes = (time - hours * 3600) / 60;
        int seconds = time % 60;
        int centiminutes = time * 100 / 60;
        formatter.format("%02d:%02d:%02d or %d", hours, minutes, seconds, centiminutes);
        return sb.toString();
    }

    public String toString() {
        return "TripIdentifier(" + this.routeName + "," + this.gtfsAndStifTimeFormat(this.startTime) + "," + this.gtfsAndStifTimeFormat(this.endTime) + "," + this.startStop + "," + this.run + " from " + this.startStop + " block " + this.block + ")";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.routeName == null ? 0 : this.routeName.hashCode());
        result = 31 * result + (this.startStop == null ? 0 : this.startStop.hashCode());
        result = 31 * result + this.startTime;
        result = 31 * result + this.endTime;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TripIdentifier other = (TripIdentifier)obj;
        if (this.routeName == null) {
            if (other.routeName != null) {
                return false;
            }
        } else {
            if (!this.routeName.equals(other.routeName)) {
                return false;
            }
            if (this.run != null && other.run != null && !this.run.equals(other.run)) {
                return false;
            }
            if (this.block != null && other.block != null && !this.block.equals(other.block)) {
                return false;
            }
        }
        if (this.startStop == null ? other.startStop != null : !this.startStop.equals(other.startStop)) {
            return false;
        }
        return this.startTime == other.startTime && this.endTime == other.endTime;
    }
}

