/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.bundle.tasks.stif;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.onebusaway.gtfs.impl.SpringHibernateGtfsRelationalDaoImpl;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs.services.HibernateOperation;
import org.onebusaway.transit_data_federation.bundle.tasks.stif.StifTrip;
import org.onebusaway.transit_data_federation.bundle.tasks.stif.TripIdentifier;
import org.onebusaway.transit_data_federation.bundle.tasks.stif.model.ServiceCode;
import org.onebusaway.transit_data_federation.bundle.tasks.stif.model.TripRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StifTripLoaderSupport {
    private static final Logger _log = LoggerFactory.getLogger(StifTripLoaderSupport.class);
    private GtfsMutableRelationalDao gtfsDao;
    private Map<TripIdentifier, List<Trip>> tripsByIdentifier;
    private Map<String, String> stopIdsByLocation = new HashMap<String, String>();
    private int _totalTripCount;

    public void setGtfsDao(GtfsMutableRelationalDao dao) {
        this.gtfsDao = dao;
    }

    public static ServiceCode scheduleIdForGtfsDayCode(String dayCode) {
        return ServiceCode.getServiceCodeForId(dayCode);
    }

    public int getTotalTripCount() {
        return this._totalTripCount;
    }

    public void putStopIdForLocation(String location, String stopId) {
        this.stopIdsByLocation.put(location, stopId);
    }

    public TripIdentifier getIdentifierForStifTrip(TripRecord tripRecord, StifTrip rawTrip) {
        String routeName = tripRecord.getSignCodeRoute();
        if (routeName == null || routeName.trim().length() == 0) {
            routeName = tripRecord.getRunRoute();
            routeName = routeName.replaceFirst("^([a-zA-Z]+)0+", "$1").toUpperCase();
        }
        String startStop = rawTrip.firstStop;
        int startTime = rawTrip.firstStopTime;
        int endTime = rawTrip.lastStopTime;
        if (startTime < 0) {
            startTime += 86400;
            endTime += 86400;
        }
        String run = tripRecord.getRunId();
        return new TripIdentifier(routeName, startTime, endTime, startStop, run, rawTrip.blockId);
    }

    public List<Trip> getTripsForIdentifier(TripIdentifier id) {
        if (this.tripsByIdentifier == null) {
            this.tripsByIdentifier = new HashMap<TripIdentifier, List<Trip>>();
            Collection allTrips = this.gtfsDao.getAllTrips();
            this._totalTripCount = allTrips.size();
            int index = 0;
            for (Trip trip : allTrips) {
                if (index % 20000 == 0) {
                    _log.info("trip=" + index + " / " + allTrips.size());
                }
                ++index;
                TripIdentifier tripIdentifier = this.getTripAsIdentifier(trip);
                List<Trip> trips = this.tripsByIdentifier.get(tripIdentifier);
                if (trips == null) {
                    trips = new ArrayList<Trip>();
                    this.tripsByIdentifier.put(tripIdentifier, trips);
                }
                trips.add(trip);
            }
        }
        return this.tripsByIdentifier.get(id);
    }

    public String getStopIdForLocation(String originLocation) {
        return this.stopIdsByLocation.get(originLocation);
    }

    TripIdentifier getTripAsIdentifier(final Trip trip) {
        String startStop;
        String routeName = trip.getRoute().getId().getId();
        int startTime = -1;
        int endTime = -1;
        if (this.gtfsDao instanceof SpringHibernateGtfsRelationalDaoImpl) {
            SpringHibernateGtfsRelationalDaoImpl dao = (SpringHibernateGtfsRelationalDaoImpl)this.gtfsDao;
            List rows = (List)dao.execute(new HibernateOperation(){

                public Object doInHibernate(Session session) throws HibernateException, SQLException {
                    Query query = session.createQuery("SELECT st.departureTime, st.stop.id.id FROM StopTime st WHERE st.trip = :trip AND st.departureTime >= 0 ORDER BY st.stopSequence ASC LIMIT 1");
                    query.setParameter("trip", (Object)trip);
                    return query.list();
                }
            });
            Object[] values = (Object[])rows.get(0);
            startTime = (Integer)values[0];
            startStop = (String)values[1];
            rows = (List)dao.execute(new HibernateOperation(){

                public Object doInHibernate(Session session) throws HibernateException, SQLException {
                    Query query = session.createQuery("SELECT st.arrivalTime FROM StopTime st WHERE st.trip = :trip AND st.arrivalTime >= 0 ORDER BY st.stopSequence DESC LIMIT 1");
                    query.setParameter("trip", (Object)trip);
                    return query.list();
                }
            });
            values = (Object[])rows.get(0);
            endTime = (Integer)values[0];
        } else {
            List stopTimes = this.gtfsDao.getStopTimesForTrip(trip);
            StopTime startStopTime = (StopTime)stopTimes.get(0);
            startTime = startStopTime.getDepartureTime();
            startStop = startStopTime.getStop().getId().getId();
            StopTime endStopTime = (StopTime)stopTimes.get(stopTimes.size() - 1);
            endTime = endStopTime.getArrivalTime();
        }
        String run = null;
        String[] parts = trip.getId().getId().toUpperCase().split("_");
        if (parts.length > 2) {
            String runRoute = parts[parts.length - 2];
            String runNumber = parts[parts.length - 1];
            run = runRoute + "-" + runNumber;
        }
        routeName = routeName.replaceFirst("^([a-zA-Z]+)0+", "$1").toUpperCase();
        return new TripIdentifier(routeName, startTime, endTime, startStop, run, trip.getBlockId());
    }

    public GtfsMutableRelationalDao getGtfsDao() {
        return this.gtfsDao;
    }
}

