/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.bundle.tasks.stif;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.onebusaway.collections.tuple.Pair;
import org.onebusaway.collections.tuple.Tuples;
import org.onebusaway.csv_entities.CSVLibrary;
import org.onebusaway.csv_entities.CSVListener;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.transit_data.model.oba.RunData;
import org.onebusaway.transit_data_federation.bundle.tasks.MultiCSVLogger;
import org.onebusaway.transit_data_federation.bundle.tasks.stif.NonRevenueStopData;
import org.onebusaway.transit_data_federation.bundle.tasks.stif.RawRunData;
import org.onebusaway.transit_data_federation.bundle.tasks.stif.StifTrip;
import org.onebusaway.transit_data_federation.bundle.tasks.stif.StifTripLoader;
import org.onebusaway.transit_data_federation.bundle.tasks.stif.StifTripType;
import org.onebusaway.transit_data_federation.bundle.tasks.stif.model.GeographyRecord;
import org.onebusaway.transit_data_federation.bundle.tasks.stif.model.ServiceCode;
import org.onebusaway.transit_data_federation.services.FederatedTransitDataBundle;
import org.onebusaway.util.AgencyAndIdLibrary;
import org.onebusaway.utility.ObjectSerializationLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class StifTask
implements Runnable {
    private static final int MAX_BLOCK_ID_LENGTH = 64;
    private Logger _log = LoggerFactory.getLogger(StifTask.class);
    private GtfsMutableRelationalDao _gtfsMutableRelationalDao;
    private StifTripLoader _loader = null;
    private List<File> _stifPaths = new ArrayList<File>();
    private String _tripToDSCOverridePath;
    private Set<String> _notInServiceDscs = new HashSet<String>();
    private File _notInServiceDscPath;
    @Autowired
    private FederatedTransitDataBundle _bundle;
    private boolean fallBackToStifBlocks = false;
    private MultiCSVLogger csvLogger = null;
    private HashMap<String, Set<AgencyAndId>> routeIdsByDsc = new HashMap();

    @Autowired
    public void setLogger(MultiCSVLogger logger) {
        this.csvLogger = logger;
    }

    @Autowired
    public void setGtfsMutableRelationalDao(GtfsMutableRelationalDao gtfsMutableRelationalDao) {
        this._gtfsMutableRelationalDao = gtfsMutableRelationalDao;
    }

    public void setStifPath(File path) {
        this._stifPaths.add(path);
    }

    public void setStifPaths(List<File> paths) {
        this._stifPaths.addAll(paths);
    }

    public void setNotInServiceDsc(String notInServiceDsc) {
        this._notInServiceDscs.add(notInServiceDsc);
    }

    public void setTripToDSCOverridePath(String path) {
        this._tripToDSCOverridePath = path;
    }

    public void setNotInServiceDscs(List<String> notInServiceDscs) {
        this._notInServiceDscs.addAll(notInServiceDscs);
    }

    public void setNotInServiceDscPath(File notInServiceDscPath) {
        this._notInServiceDscPath = notInServiceDscPath;
    }

    @Override
    public void run() {
        if (this._loader == null) {
            this._log.warn("creating loader with gtfs= " + this._gtfsMutableRelationalDao + " and logger=" + this.csvLogger);
            this._loader = new StifTripLoader();
            this._loader.setGtfsDao(this._gtfsMutableRelationalDao);
            this._loader.setLogger(this.csvLogger);
            for (File path : this._stifPaths) {
                this.loadStif(path, this._loader);
            }
        }
        this.computeBlocksFromRuns(this._loader);
        this.warnOnMissingTrips();
        if (this.fallBackToStifBlocks) {
            this.loadStifBlocks(this._loader);
        }
        Map<AgencyAndId, RunData> runsForTrip = this._loader.getRunsForTrip();
        try {
            if (this._bundle != null) {
                ObjectSerializationLibrary.writeObject((File)this._bundle.getTripRunDataPath(), runsForTrip);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.serializeNonRevenueMoveData(this._loader.getRawStifData(), this._loader.getGeographyRecordsByBoxId());
        this.serializeNonRevenueStopData(this._loader.getNonRevenueStopDataByTripId());
        Map<String, List<AgencyAndId>> dscToTripMap = this._loader.getTripMapping();
        if (this._tripToDSCOverridePath != null) {
            Map<AgencyAndId, String> tripToDSCOverrides;
            try {
                tripToDSCOverrides = this.loadTripToDSCOverrides(this._tripToDSCOverridePath);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            for (Map.Entry<String, Object> entry : tripToDSCOverrides.entrySet()) {
                if (this._gtfsMutableRelationalDao.getTripForId((AgencyAndId)entry.getKey()) == null) {
                    throw new IllegalStateException("Trip id " + entry.getKey() + " from trip ID to DSC overrides does not exist in bundle GTFS.");
                }
                List<AgencyAndId> agencyAndIds = dscToTripMap.get(entry.getValue());
                if (agencyAndIds == null) {
                    agencyAndIds = new ArrayList<AgencyAndId>();
                    dscToTripMap.put((String)entry.getValue(), agencyAndIds);
                }
                agencyAndIds.add((AgencyAndId)entry.getKey());
            }
        }
        HashMap<AgencyAndId, String> tripToDscMap = new HashMap<AgencyAndId, String>();
        for (Map.Entry<String, Object> entry : dscToTripMap.entrySet()) {
            String destinationSignCode = entry.getKey();
            List tripIds = (List)entry.getValue();
            for (AgencyAndId tripId : tripIds) {
                tripToDscMap.put(tripId, destinationSignCode);
            }
        }
        HashSet<String> inServiceDscs = new HashSet<String>();
        this.logDSCStatistics(dscToTripMap, tripToDscMap);
        int n = this._loader.getTripsWithoutMatchCount();
        int total = this._loader.getTripsCount();
        this._log.info("stif trips without match: " + n + " / " + total);
        this.readNotInServiceDscs();
        this.serializeDSCData(dscToTripMap, tripToDscMap, inServiceDscs);
    }

    void logDSCStatistics(Map<String, List<AgencyAndId>> dscToTripMap, Map<AgencyAndId, String> tripToDscMap) {
        this.csvLogger.header("dsc_statistics.csv", "dsc,agency_id,number_of_trips_in_stif,number_of_distinct_route_ids_in_gtfs");
        for (Map.Entry<String, List<AgencyAndId>> entry : dscToTripMap.entrySet()) {
            String destinationSignCode = entry.getKey();
            List<AgencyAndId> tripIds = entry.getValue();
            Set<AgencyAndId> routeIds = this.routeIdsByDsc.get(destinationSignCode);
            HashSet<String> set = new HashSet<String>();
            for (AgencyAndId aaid : tripIds) {
                if (aaid == null) continue;
                set.add(aaid.getAgencyId());
            }
            for (String agencyId : set) {
                this.csvLogger.log("dsc_statistics.csv", destinationSignCode, agencyId, tripIds.size(), routeIds != null ? routeIds.size() : 0);
            }
        }
    }

    private void serializeNonRevenueMoveData(Map<ServiceCode, List<StifTrip>> nonRevenueMovesByServiceCode, Map<AgencyAndId, GeographyRecord> nonRevenueMoveLocationsByBoxId) {
        try {
            if (this._bundle != null) {
                ObjectSerializationLibrary.writeObject((File)this._bundle.getNonRevenueMovePath(), nonRevenueMovesByServiceCode);
                ObjectSerializationLibrary.writeObject((File)this._bundle.getNonRevenueMoveLocationsPath(), nonRevenueMoveLocationsByBoxId);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("error serializing non-revenue move/STIF data", e);
        }
    }

    private void serializeNonRevenueStopData(Map<AgencyAndId, List<NonRevenueStopData>> nonRevenueStopDataByTripId) {
        try {
            if (this._bundle != null) {
                ObjectSerializationLibrary.writeObject((File)this._bundle.getNonRevenueStopsPath(), nonRevenueStopDataByTripId);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("error serializing non-revenue move/STIF data", e);
        }
    }

    private void serializeDSCData(Map<String, List<AgencyAndId>> dscToTripMap, Map<AgencyAndId, String> tripToDscMap, Set<String> inServiceDscs) {
        for (String notInServiceDsc : this._notInServiceDscs) {
            if (inServiceDscs.contains(notInServiceDsc)) {
                this._log.warn("overlap between in-service and not-in-service dscs: " + notInServiceDsc);
            }
            dscToTripMap.put(notInServiceDsc, new ArrayList());
        }
        try {
            if (this._bundle != null) {
                ObjectSerializationLibrary.writeObject((File)this._bundle.getNotInServiceDSCs(), this._notInServiceDscs);
                ObjectSerializationLibrary.writeObject((File)this._bundle.getTripsForDSCIndex(), tripToDscMap);
                ObjectSerializationLibrary.writeObject((File)this._bundle.getDSCForTripIndex(), dscToTripMap);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("error serializing DSC/STIF data", e);
        }
    }

    private void loadStifBlocks(StifTripLoader loader) {
        Map<Trip, RawRunData> rawData = loader.getRawRunDataByTrip();
        for (Map.Entry<Trip, RawRunData> entry : rawData.entrySet()) {
            Trip trip = entry.getKey();
            if (trip.getBlockId() != null && trip.getBlockId().length() != 0) continue;
            RawRunData data = entry.getValue();
            trip.setBlockId(trip.getServiceId().getId() + "_STIF_" + data.getDepotCode() + "_" + data.getBlock());
            this._gtfsMutableRelationalDao.updateEntity((Object)trip);
        }
    }

    private void computeBlocksFromRuns(StifTripLoader loader) {
        int blockNo = 0;
        HashSet<Trip> usedGtfsTrips = new HashSet<Trip>();
        this.csvLogger.header("non_pullin_without_next_movement.csv", "stif_trip,stif_filename,stif_trip_record_line_num");
        this.csvLogger.header("stif_trips_without_pullout.csv", "stif_trip,stif_filename,stif_trip_record_line_num,gtfs_trip_id,synthesized_block_id");
        this.csvLogger.header("matched_trips_gtfs_stif.csv", "agency_id,gtfs_service_id,service_id,blockId,tripId,dsc,firstStop,firstStopTime,lastStop,lastStopTime,runId,reliefRunId,recoveryTime,firstInSeq,lastInSeq,signCodeRoute,routeId");
        Map<ServiceCode, List<StifTrip>> rawData = loader.getRawStifData();
        for (Map.Entry<ServiceCode, List<StifTrip>> entry : rawData.entrySet()) {
            List<StifTrip> rawTrips = entry.getValue();
            HashMap tripsByRun = new HashMap();
            HashSet<StifTrip> unmatchedTrips = new HashSet<StifTrip>();
            ArrayList<StifTrip> pullouts = new ArrayList<StifTrip>();
            for (StifTrip trip : rawTrips) {
                String runId = trip.getRunIdWithDepot();
                ArrayList<StifTrip> byRun = (ArrayList<StifTrip>)tripsByRun.get(runId);
                if (byRun == null) {
                    byRun = new ArrayList<StifTrip>();
                    tripsByRun.put(runId, byRun);
                }
                unmatchedTrips.add(trip);
                byRun.add(trip);
                if (trip.type == StifTripType.PULLOUT) {
                    pullouts.add(trip);
                }
                if (trip.type != StifTripType.DEADHEAD || trip.listedFirstStopTime != trip.listedLastStopTime + trip.recoveryTime) continue;
                this._log.warn("Zero-length deadhead.  If this immediately follows a pullout, tracing might fail.  If it does, we will mark some trips as trips without pullout.");
            }
            for (List byRun : tripsByRun.values()) {
                Collections.sort(byRun);
            }
            for (StifTrip pullout : pullouts) {
                ++blockNo;
                StifTrip lastTrip = pullout;
                int i = 0;
                HashSet<Pair> blockIds = new HashSet<Pair>();
                while (lastTrip.type != StifTripType.PULLIN) {
                    unmatchedTrips.remove(lastTrip);
                    if (++i > 200) {
                        this._log.warn("We seem to be caught in an infinite loop; this is usually caused\nby two trips on the same run having the same start time.  Since nobody\ncan be in two places at once, this is an error in the STIF.  Some trips\nwill end up with missing blocks and the log will be screwed up.  A \nrepresentative trip starts at " + lastTrip.firstStop + " at " + lastTrip.firstStopTime + " on " + lastTrip.getRunIdWithDepot() + " on " + lastTrip.serviceCode);
                        break;
                    }
                    String nextRunId = lastTrip.getNextRunIdWithDepot();
                    if (nextRunId == null) {
                        this.csvLogger.log("non_pullin_without_next_movement.csv", lastTrip.id, lastTrip.path, lastTrip.lineNumber);
                        this._log.warn("A non-pullin has no next run; some trips will end up with missing blocks and the log will be messed up. The bad trip starts at " + lastTrip.firstStop + " at " + lastTrip.firstStopTime + " on " + lastTrip.getRunIdWithDepot() + " on " + lastTrip.serviceCode);
                        break;
                    }
                    List trips = (List)tripsByRun.get(nextRunId);
                    if (trips == null) {
                        this._log.warn("No trips for run " + nextRunId);
                        break;
                    }
                    int nextTripStartTime = lastTrip.listedLastStopTime + lastTrip.recoveryTime * 60;
                    int index = Collections.binarySearch(trips, nextTripStartTime, new RawTripComparator());
                    if (index < 0) {
                        index = -(index + 1);
                    }
                    if (index >= trips.size()) {
                        this._log.warn("The preceding trip says that the run " + nextRunId + " is next, but there are no trips after " + lastTrip.firstStopTime + ", so some trips will end up with missing blocks. The last trip starts at " + lastTrip.firstStop + " at " + lastTrip.firstStopTime + " on " + lastTrip.getRunIdWithDepot() + " on " + lastTrip.serviceCode);
                        break;
                    }
                    StifTrip trip = (StifTrip)trips.get(index);
                    if (trip == lastTrip) {
                        if (index > 0 && ((StifTrip)trips.get((int)(index - 1))).listedFirstStopTime == nextTripStartTime) {
                            trip = (StifTrip)trips.get(--index);
                        } else if (index < trips.size() - 1 && ((StifTrip)trips.get((int)(index + 1))).listedFirstStopTime == nextTripStartTime) {
                            ++index;
                        } else {
                            this._log.warn("The preceding trip says that the run " + nextRunId + " is next, and that the next trip should start at " + nextTripStartTime + ". As it happens, *this* trip starts at that time, but no other trips on this run do, so some trips will end up with missing blocks. The last trip starts at " + lastTrip.firstStop + " at " + lastTrip.firstStopTime + " on " + lastTrip.getRunIdWithDepot() + " on " + lastTrip.serviceCode);
                            break;
                        }
                    }
                    lastTrip = trip;
                    for (Trip gtfsTrip : lastTrip.getGtfsTrips()) {
                        RawRunData rawRunData = loader.getRawRunDataByTrip().get(gtfsTrip);
                        Object blockId = trip.agencyId.equals("MTA NYCT") ? gtfsTrip.getServiceId().getId() + "_" + trip.serviceCode.getLetterCode() + "_" + rawRunData.getDepotCode() + "_" + pullout.firstStopTime + "_" + pullout.runId : gtfsTrip.getServiceId().getId() + "_" + trip.blockId;
                        blockId = ((String)blockId).intern();
                        blockIds.add(Tuples.pair((Object)blockId, (Object)gtfsTrip.getServiceId().getId()));
                        gtfsTrip.setBlockId((String)blockId);
                        this._gtfsMutableRelationalDao.updateEntity((Object)gtfsTrip);
                        AgencyAndId routeId = gtfsTrip.getRoute().getId();
                        StifTask.addToMapSet(this.routeIdsByDsc, trip.getDsc(), routeId);
                        this.dumpBlockDataForTrip(trip, gtfsTrip.getServiceId().getId(), gtfsTrip.getId().getId(), (String)blockId, routeId.getId());
                        usedGtfsTrips.add(gtfsTrip);
                    }
                    if (lastTrip.type != StifTripType.DEADHEAD) continue;
                    for (Pair blockId : blockIds) {
                        String tripId = String.format("deadhead_%s_%s_%s_%s_%s", blockId.getSecond(), lastTrip.firstStop, lastTrip.firstStopTime, lastTrip.lastStop, lastTrip.runId);
                        this.dumpBlockDataForTrip(lastTrip, (String)blockId.getSecond(), tripId, (String)blockId.getFirst(), "no gtfs trip");
                    }
                }
                unmatchedTrips.remove(lastTrip);
                for (Pair blockId : blockIds) {
                    String pulloutTripId = String.format("pullout_%s_%s_%s_%s", blockId.getSecond(), lastTrip.firstStop, lastTrip.firstStopTime, lastTrip.runId);
                    this.dumpBlockDataForTrip(pullout, (String)blockId.getSecond(), pulloutTripId, (String)blockId.getFirst(), "no gtfs trip");
                    String pullinTripId = String.format("pullin_%s_%s_%s_%s", blockId.getSecond(), lastTrip.lastStop, lastTrip.lastStopTime, lastTrip.runId);
                    this.dumpBlockDataForTrip(lastTrip, (String)blockId.getSecond(), pullinTripId, (String)blockId.getFirst(), "no gtfs trip");
                }
            }
            for (StifTrip trip : unmatchedTrips) {
                this._log.warn("STIF trip: " + trip + " on schedule " + (Object)((Object)entry.getKey()) + " trip type " + trip.type + " must not have an associated pullout");
                for (Trip gtfsTrip : trip.getGtfsTrips()) {
                    Object blockId = gtfsTrip.getServiceId().getId() + "_" + trip.serviceCode.getLetterCode() + "_" + trip.firstStop + "_" + trip.firstStopTime + "_" + trip.runId.replace("-", "_") + ++blockNo + "_orphn";
                    if (((String)blockId).length() > 64) {
                        blockId = this.truncateId((String)blockId);
                    }
                    this._log.warn("Generating single-trip block id for GTFS trip: " + gtfsTrip.getId() + " : " + (String)blockId);
                    gtfsTrip.setBlockId((String)blockId);
                    this.dumpBlockDataForTrip(trip, gtfsTrip.getServiceId().getId(), gtfsTrip.getId().getId(), (String)blockId, gtfsTrip.getRoute().getId().getId());
                    this.csvLogger.log("stif_trips_without_pullout.csv", trip.id, trip.path, trip.lineNumber, gtfsTrip.getId(), blockId);
                    usedGtfsTrips.add(gtfsTrip);
                }
            }
        }
        HashSet<Route> routesWithTrips = new HashSet<Route>();
        this.csvLogger.header("gtfs_trips_with_no_stif_match.csv", "gtfs_trip_id,stif_trip");
        Collection allTrips = this._gtfsMutableRelationalDao.getAllTrips();
        for (Trip trip : allTrips) {
            if (usedGtfsTrips.contains(trip)) {
                routesWithTrips.add(trip.getRoute());
                continue;
            }
            this.csvLogger.log("gtfs_trips_with_no_stif_match.csv", trip.getId(), loader.getSupport().getTripAsIdentifier(trip));
        }
        this.csvLogger.header("route_ids_with_no_trips.csv", "agency_id,route_id");
        for (Route route : this._gtfsMutableRelationalDao.getAllRoutes()) {
            if (routesWithTrips.contains(route)) continue;
            this.csvLogger.log("route_ids_with_no_trips.csv", route.getId().getAgencyId(), route.getId().getId());
        }
    }

    public static final <T, U> void addToMapSet(Map<T, Set<U>> mapList, T key, U value) {
        Set<U> list = mapList.get(key);
        if (list == null) {
            list = new HashSet<U>();
            mapList.put(key, list);
        }
        list.add(value);
    }

    private void dumpBlockDataForTrip(StifTrip trip, String gtfsServiceId, String tripId, String blockId, String routeId) {
        this.csvLogger.log("matched_trips_gtfs_stif.csv", new Object[]{trip.agencyId, gtfsServiceId, trip.serviceCode, blockId, tripId, trip.getDsc(), trip.firstStop, trip.firstStopTime, trip.lastStop, trip.lastStopTime, trip.runId, trip.reliefRunId, trip.recoveryTime, trip.firstTripInSequence, trip.lastTripInSequence, trip.getSignCodeRoute(), routeId});
    }

    private void warnOnMissingTrips() {
        for (Trip t : this._gtfsMutableRelationalDao.getAllTrips()) {
            String blockId = t.getBlockId();
            if (blockId != null && !blockId.equals("")) continue;
            this._log.warn("When matching GTFS to STIF, failed to find block in STIF for " + t.getId());
        }
    }

    public void loadStif(File path, StifTripLoader loader) {
        if (path.getName().startsWith(".")) {
            return;
        }
        if (path.isDirectory()) {
            for (String filename : path.list()) {
                File contained = new File(path, filename);
                this.loadStif(contained, loader);
            }
        } else {
            loader.run(path);
        }
    }

    private Map<AgencyAndId, String> loadTripToDSCOverrides(String path) throws Exception {
        final HashMap<AgencyAndId, String> results = new HashMap<AgencyAndId, String>();
        CSVListener listener = new CSVListener(){
            int count = 0;
            int tripIdIndex;
            int dscIndex;

            public void handleLine(List<String> line) throws Exception {
                if (line.size() != 2) {
                    throw new Exception("Each Trip ID to DSC CSV line must contain two columns.");
                }
                if (this.count == 0) {
                    ++this.count;
                    this.tripIdIndex = line.indexOf("trip_id");
                    this.dscIndex = line.indexOf("dsc");
                    if (this.tripIdIndex == -1 || this.dscIndex == -1) {
                        throw new Exception("Trip ID to DSC CSV must contain a header with column names 'trip_id' and 'dsc'.");
                    }
                    return;
                }
                results.put(AgencyAndIdLibrary.convertFromString((String)line.get(this.tripIdIndex)), line.get(this.dscIndex));
            }
        };
        File source = new File(path);
        new CSVLibrary().parse(source, listener);
        return results;
    }

    private void readNotInServiceDscs() {
        if (this._notInServiceDscPath != null) {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(this._notInServiceDscPath));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    this._notInServiceDscs.add(line);
                }
            }
            catch (IOException ex) {
                throw new IllegalStateException("unable to read nonInServiceDscPath: " + this._notInServiceDscPath);
            }
        }
    }

    public boolean usesFallBackToStifBlocks() {
        return this.fallBackToStifBlocks;
    }

    public void setFallBackToStifBlocks(boolean fallBackToStifBlocks) {
        this.fallBackToStifBlocks = fallBackToStifBlocks;
    }

    public void setStifTripLoader(StifTripLoader loader) {
        this._loader = loader;
    }

    public void setCSVLogger(MultiCSVLogger logger) {
        this.csvLogger = logger;
    }

    String truncateId(String id) {
        if (id == null) {
            return null;
        }
        return id.replaceAll("[aeiouy\\s]", "");
    }

    class RawTripComparator
    implements Comparator {
        RawTripComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof Integer) {
                if (o2 instanceof Integer) {
                    return (Integer)o1 - (Integer)o2;
                }
                StifTrip trip = (StifTrip)o2;
                return (Integer)o1 - trip.listedFirstStopTime;
            }
            if (o2 instanceof Integer) {
                return ((StifTrip)o1).listedFirstStopTime - (Integer)o2;
            }
            StifTrip trip = (StifTrip)o2;
            return ((StifTrip)o1).listedFirstStopTime - trip.listedFirstStopTime;
        }
    }

    class TripWithStartTime
    implements Comparable<TripWithStartTime> {
        private int startTime;
        private Trip trip;

        public TripWithStartTime(Trip trip) {
            this.trip = trip;
            List stopTimes = StifTask.this._gtfsMutableRelationalDao.getStopTimesForTrip(trip);
            this.startTime = ((StopTime)stopTimes.get(0)).getDepartureTime();
        }

        public TripWithStartTime(int startTime) {
            this.startTime = startTime;
        }

        @Override
        public int compareTo(TripWithStartTime o) {
            return this.startTime - o.startTime;
        }

        public String toString() {
            return "TripWithStartTime(" + this.startTime + ", " + this.trip + ")";
        }
    }
}

