/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.bundle.tasks.stif;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.onebusaway.transit_data_federation.bundle.tasks.stif.model.EventRecordFactory;
import org.onebusaway.transit_data_federation.bundle.tasks.stif.model.GeographyRecordFactory;
import org.onebusaway.transit_data_federation.bundle.tasks.stif.model.SignCodeRecordFactory;
import org.onebusaway.transit_data_federation.bundle.tasks.stif.model.StifRecord;
import org.onebusaway.transit_data_federation.bundle.tasks.stif.model.StifRecordFactory;
import org.onebusaway.transit_data_federation.bundle.tasks.stif.model.TimetableRecordFactory;
import org.onebusaway.transit_data_federation.bundle.tasks.stif.model.TripRecordFactory;

public class StifRecordReader {
    private static final int BUFFER_SIZE = 4096;
    private InputStream inputStream;
    private byte[] buffer = new byte[4096];
    private int start = 0;
    private int bufferEnd = 0;
    static Map<Integer, StifRecordFactory<?>> recordFactories = new HashMap();

    public StifRecordReader(InputStream stream) {
        this.inputStream = stream;
    }

    public StifRecord read() throws IOException {
        int recordStart;
        int recordType;
        StifRecordFactory<?> factory;
        int end = -1;
        do {
            end = -1;
            while (end == -1) {
                for (int i = this.start; i < this.bufferEnd; ++i) {
                    if (this.buffer[i] != 13) continue;
                    end = i;
                    break;
                }
                if (end != -1) break;
                ByteBuffer bbuffer = ByteBuffer.wrap(this.buffer);
                if (this.start < 4096) {
                    bbuffer.put(this.buffer, this.start, 4096 - this.start);
                    this.bufferEnd -= this.start;
                } else {
                    this.bufferEnd = 0;
                    this.inputStream.read(this.buffer, this.bufferEnd, this.start - 4096);
                }
                if (4096 == this.bufferEnd) {
                    throw new IOException("Too-long line trying to read STIF");
                }
                int bytesRead = this.inputStream.read(this.buffer, this.bufferEnd, 4096 - this.bufferEnd);
                if (bytesRead == -1) {
                    if (this.start >= this.bufferEnd) {
                        return null;
                    }
                    throw new RuntimeException("Parse error: stif requires trailing newline");
                }
                this.bufferEnd += bytesRead;
                this.start = 0;
            }
            recordStart = this.start;
            this.start = end + 2;
        } while ((factory = recordFactories.get(recordType = Integer.parseInt(new String(this.buffer, recordStart, 2)))) == null);
        return factory.createRecord(this.buffer, recordStart, end);
    }

    static {
        recordFactories.put(11, new TimetableRecordFactory());
        recordFactories.put(15, new GeographyRecordFactory());
        recordFactories.put(21, new TripRecordFactory());
        recordFactories.put(31, new EventRecordFactory());
        recordFactories.put(35, new SignCodeRecordFactory());
    }
}

