/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.bundle.tasks.block_indices;

import java.io.File;
import java.util.List;
import org.onebusaway.container.refresh.RefreshService;
import org.onebusaway.transit_data_federation.impl.blocks.BlockStopTimeIndicesFactory;
import org.onebusaway.transit_data_federation.services.FederatedTransitDataBundle;
import org.onebusaway.transit_data_federation.services.blocks.BlockIndexFactoryService;
import org.onebusaway.transit_data_federation.services.transit_graph.TransitGraphDao;
import org.onebusaway.utility.ObjectSerializationLibrary;
import org.springframework.beans.factory.annotation.Autowired;

public class BlockIndicesTask
implements Runnable {
    private FederatedTransitDataBundle _bundle;
    private TransitGraphDao _transitGraphDao;
    private BlockIndexFactoryService _blockIndexFactoryService;
    private RefreshService _refreshService;

    @Autowired
    public void setBundle(FederatedTransitDataBundle bundle) {
        this._bundle = bundle;
    }

    @Autowired
    public void setTransitGraphDao(TransitGraphDao transitGraphDao) {
        this._transitGraphDao = transitGraphDao;
    }

    @Autowired
    public void setBlockIndexFactoryService(BlockIndexFactoryService blockIndexFactoryService) {
        this._blockIndexFactoryService = blockIndexFactoryService;
    }

    @Autowired
    public void setRefreshService(RefreshService refreshService) {
        this._refreshService = refreshService;
    }

    @Override
    public void run() {
        try {
            List blocks = this._transitGraphDao.getAllBlocks();
            List tripData = this._blockIndexFactoryService.createTripData((Iterable)blocks);
            List layoverData = this._blockIndexFactoryService.createLayoverData((Iterable)blocks);
            List frequencyTripData = this._blockIndexFactoryService.createFrequencyTripData((Iterable)blocks);
            ObjectSerializationLibrary.writeObject((File)this._bundle.getBlockTripIndicesPath(), (Object)tripData);
            ObjectSerializationLibrary.writeObject((File)this._bundle.getBlockLayoverIndicesPath(), (Object)layoverData);
            ObjectSerializationLibrary.writeObject((File)this._bundle.getFrequencyBlockTripIndicesPath(), (Object)frequencyTripData);
            BlockStopTimeIndicesFactory stopFactory = new BlockStopTimeIndicesFactory();
            stopFactory.createIndices((Iterable)blocks);
            this._refreshService.refresh("blockIndexData");
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }
}

