/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.bundle.tasks;

import java.util.List;
import org.onebusaway.geospatial.services.SphericalGeometryLibrary;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.transit_data_federation.bundle.tasks.AbstractStopTask;
import org.onebusaway.util.AgencyAndIdLibrary;

public class StopVerificationDistanceTask
extends AbstractStopTask
implements Runnable {
    private static final double STOP_DISTANCE_THRESHOLD = 100.0;

    @Override
    protected void insertHeader() {
        this._logger.header("stop_verification_distance.csv", "root_stop_id,consolidated_stop_id,stop_distance,root_lat_lon,consolidated_lat_lon");
    }

    @Override
    protected void verifyStops(String rootStopId, List<String> consolidatedStops) {
        AgencyAndId agencyAndId = AgencyAndIdLibrary.convertFromString((String)rootStopId);
        Stop expectedStop = this._dao.getStopForId(agencyAndId);
        for (String consolidatedStop : consolidatedStops) {
            double distance;
            Stop unexpectedStop = this._dao.getStopForId(AgencyAndIdLibrary.convertFromString((String)consolidatedStop));
            if (unexpectedStop == null || expectedStop == null || !((distance = SphericalGeometryLibrary.distanceFaster((double)expectedStop.getLat(), (double)expectedStop.getLon(), (double)unexpectedStop.getLat(), (double)unexpectedStop.getLon())) > 100.0)) continue;
            this._logger.log("stop_verification_distance.csv", rootStopId, consolidatedStop, distance, this.toOrd(expectedStop.getLat(), expectedStop.getLon()), this.toOrd(unexpectedStop.getLat(), unexpectedStop.getLon()));
        }
    }

    private String toOrd(double lat, double lon) {
        return lat + "," + lon;
    }
}

