/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.bundle.tasks;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.WrongWayConcurrency;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.onebusaway.transit_data.model.StopDirectionSwap;
import org.onebusaway.transit_data_federation.impl.StopDirectionSwapKey;
import org.onebusaway.transit_data_federation.services.FederatedTransitDataBundle;
import org.onebusaway.utility.ObjectSerializationLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class StopDirectionSwapTask
implements Runnable {
    private static Logger _log = LoggerFactory.getLogger(StopDirectionSwapTask.class);
    @Autowired
    private GtfsRelationalDao _gtfsDao;
    @Autowired
    private FederatedTransitDataBundle _bundle;

    @Override
    public void run() {
        if (this._gtfsDao.getAllWrongWayConcurrencies() == null) {
            _log.debug("no wrong way concurrencies to load");
            return;
        }
        HashMap<StopDirectionSwapKey, StopDirectionSwap> cache = new HashMap<StopDirectionSwapKey, StopDirectionSwap>();
        for (WrongWayConcurrency wrongWay : this._gtfsDao.getAllWrongWayConcurrencies()) {
            StopDirectionSwapKey key = new StopDirectionSwapKey(AgencyAndId.convertFromString((String)wrongWay.getRouteId()), wrongWay.getDirectionId(), wrongWay.getFromStopId());
            StopDirectionSwap swap = new StopDirectionSwap();
            swap.setRouteId(AgencyAndId.convertFromString((String)wrongWay.getRouteId()));
            swap.setDirectionId(wrongWay.getDirectionId());
            swap.setFromStop(wrongWay.getFromStopId());
            swap.setToStop(wrongWay.getToStopId());
            cache.put(key, swap);
        }
        this.writeObject(cache);
    }

    private void writeObject(Map<StopDirectionSwapKey, StopDirectionSwap> cache) {
        try {
            ObjectSerializationLibrary.writeObject((File)this._bundle.getStopSwapPath(), cache);
        }
        catch (IOException ioe) {
            _log.error("fatal exception building StopDirectionSwaps:", (Object)ioe, (Object)ioe);
        }
    }
}

