/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.bundle.tasks;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.onebusaway.geospatial.services.SphericalGeometryLibrary;
import org.onebusaway.gtfs.model.Agency;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.services.GtfsDao;
import org.onebusaway.transit_data_federation.bundle.tasks.MultiCSVLogger;
import org.onebusaway.util.AgencyAndIdLibrary;
import org.onebusaway.utility.IOLibrary;
import org.onebusaway.utility.collections.TreeUnionFind;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class StopConsolidationSuggestionsTask
implements Runnable {
    private static final String CONSOLIDATED_URL = "https://raw.githubusercontent.com/wiki/camsys/onebusaway-application-modules/PugetSoundStopConsolidation.md";
    protected static Logger _log = LoggerFactory.getLogger(StopConsolidationSuggestionsTask.class);
    protected MultiCSVLogger _logger;
    protected GtfsDao _dao;

    @Autowired
    public void setGtfsDao(GtfsDao dao) {
        this._dao = dao;
    }

    @Autowired
    public void setLogger(MultiCSVLogger logger) {
        this._logger = logger;
    }

    @Override
    public void run() {
        try {
            double distanceThreshold = 20.0;
            _log.info("begin stop consolidation suggestions with distanceThreshold=" + distanceThreshold);
            TreeUnionFind<AgencyAndId> existingConsolidatedStops = new TreeUnionFind<AgencyAndId>();
            existingConsolidatedStops = this.loadExistingConsolidatedStops(CONSOLIDATED_URL);
            TreeUnionFind union = new TreeUnionFind();
            ArrayList<Collection<Stop>> allStops = new ArrayList<Collection<Stop>>();
            for (Agency agency : this._dao.getAllAgencies()) {
                Collection<Stop> stops = this.getStopsForAgency(this._dao, agency);
                for (Collection collection : allStops) {
                    for (Stop stopA : collection) {
                        for (Stop stopB : stops) {
                            double d = SphericalGeometryLibrary.distance((double)stopA.getLat(), (double)stopA.getLon(), (double)stopB.getLat(), (double)stopB.getLon());
                            if (!(d < distanceThreshold) || existingConsolidatedStops.isSameSet((Object)stopA.getId(), (Object)stopB.getId())) continue;
                            union.union((Object)stopA.getId(), (Object)stopB.getId());
                        }
                    }
                }
                allStops.add(stops);
            }
            PrintWriter writer = new PrintWriter(new OutputStreamWriter(System.out));
            this._logger.header("stop_consolidation_suggestions.csv", "new_stops,existing_stops");
            for (Set set : union.getSetMembers()) {
                StringBuffer newStopBuffer = new StringBuffer();
                StringBuffer stringBuffer = new StringBuffer();
                HashSet<TreeUnionFind.Sentry> existing = new HashSet<TreeUnionFind.Sentry>();
                boolean first = true;
                for (AgencyAndId stopId : set) {
                    if (first) {
                        first = false;
                    } else {
                        writer.print(' ');
                        newStopBuffer.append(" ");
                    }
                    if (existingConsolidatedStops.contains((Object)stopId)) {
                        existing.add(existingConsolidatedStops.find((Object)stopId));
                    }
                    writer.print(AgencyAndIdLibrary.convertToString((AgencyAndId)stopId));
                    newStopBuffer.append(AgencyAndIdLibrary.convertToString((AgencyAndId)stopId));
                }
                writer.println();
                for (TreeUnionFind.Sentry sentry : existing) {
                    writer.println("  => " + existingConsolidatedStops.members(sentry));
                    stringBuffer.append(existingConsolidatedStops.members(sentry));
                }
                this._logger.log("stop_consolidation_suggestions.csv", newStopBuffer.toString(), stringBuffer.toString());
                writer.flush();
            }
            _log.info("end stop consolidation suggestions");
        }
        catch (Exception any) {
            _log.error("exception:", (Throwable)any);
        }
    }

    private Collection<Stop> getStopsForAgency(GtfsDao dao, Agency agency) {
        ArrayList<Stop> stops = new ArrayList<Stop>();
        for (Stop stop : dao.getAllStops()) {
            if (!agency.getId().equals(stop.getId().getAgencyId())) continue;
            stops.add(stop);
        }
        return stops;
    }

    private TreeUnionFind<AgencyAndId> loadExistingConsolidatedStops(String path) throws IOException {
        InputStream in = IOLibrary.getPathAsInputStream((String)path);
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        TreeUnionFind consolidated = new TreeUnionFind();
        String line = null;
        while ((line = reader.readLine()) != null) {
            String[] tokens;
            if (line.startsWith("#") || line.startsWith("{{{") || line.startsWith("}}}") || line.length() == 0 || (tokens = line.split("\\s+")) == null || tokens.length == 0) continue;
            AgencyAndId stopId = AgencyAndIdLibrary.convertFromString((String)tokens[0]);
            for (int i = 1; i < tokens.length; ++i) {
                AgencyAndId otherStopId = AgencyAndIdLibrary.convertFromString((String)tokens[i]);
                consolidated.union((Object)stopId, (Object)otherStopId);
            }
        }
        reader.close();
        return consolidated;
    }
}

