/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.bundle.tasks;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.onebusaway.transit_data_federation.bundle.tasks.MultiCSVLoggerSummarizeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiCSVLogger {
    private static final String CHANGE_LOG = "change_log.csv";
    private String diff_log_filename = "diff_log.csv";
    private Logger _log = LoggerFactory.getLogger(MultiCSVLogger.class);
    private static DateFormat SIMPLE_DATE = new SimpleDateFormat();
    private ArrayList<MultiCSVLoggerSummarizeListener> listeners = new ArrayList();
    private HashMap<String, Log> logs = new HashMap();
    private File basePath;

    public void setBasePath(File path) {
        this.basePath = path;
    }

    public void addListener(MultiCSVLoggerSummarizeListener listener) {
        this.listeners.add(listener);
    }

    @PostConstruct
    public void postConstruct() {
        if (this.basePath == null) {
            this.basePath = new File(System.getProperty("java.io.tmpdir"));
            this._log.warn("MultiCSVLogger initialized without path:  using " + this.basePath);
        }
        if (!this.basePath.exists()) {
            this.basePath.mkdirs();
        }
    }

    public void logCSV(String file, String csv) {
        Log log = this.logs.get(file);
        if (log == null) {
            throw new RuntimeException("log called before header for file " + file);
        }
        ++log.lines;
        log.stream.print(csv);
        log.stream.print("\n");
    }

    public void log(String file, Object ... args) {
        Log log = this.logs.get(file);
        if (log == null) {
            this._log.warn("log called before header for file " + file);
            this.header(file, "MISSING");
            log = this.logs.get(file);
        }
        ++log.lines;
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            String argStr = "" + arg;
            if (argStr.contains(",") || argStr.contains("\"")) {
                argStr = "\"" + argStr.replace("\"", "\"\"") + "\"";
            }
            log.stream.print(argStr);
            if (i == args.length - 1) continue;
            log.stream.print(",");
        }
        log.stream.print("\n");
    }

    public void header(String file, String header) {
        this.header(file, header, null);
    }

    public void header(String file, String header, String comment) {
        Log log = this.logs.get(file);
        if (log != null) {
            throw new RuntimeException("header called more than once for file " + file);
        }
        log = new Log(file);
        this.logs.put(file, log);
        log.stream.println(header);
        if (comment != null && !comment.equals("")) {
            for (String s : comment.split("\n")) {
                log.stream.println(SIMPLE_DATE.format(new Date()) + "," + s);
            }
        }
    }

    public boolean hasHeader(String file) {
        return this.logs.get(file) != null;
    }

    public void changelogHeader() {
        this.changelogHeader(null);
    }

    public void changelogHeader(String comment) {
        String file = CHANGE_LOG;
        Log log = this.logs.get(file);
        if (log == null) {
            this.header(file, "date,message", comment);
        } else if (comment != null) {
            this.changelog(comment);
        }
    }

    public void changelog(String s) {
        this.log(CHANGE_LOG, SIMPLE_DATE.format(new Date()), s);
    }

    public void difflogHeader(String filename) {
        this.diff_log_filename = filename;
        Log log = this.logs.get(this.diff_log_filename);
        if (log == null) {
            this.header(this.diff_log_filename, "line,diff");
        }
    }

    public void difflog(int linenum, String content) {
        this.log(this.diff_log_filename, linenum, content);
    }

    public void summarize() {
        FileOutputStream outputStream;
        for (MultiCSVLoggerSummarizeListener l : this.listeners) {
            l.summarize();
        }
        try {
            outputStream = new FileOutputStream(new File(this.basePath, "summary.csv"), true);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        PrintStream stream = new PrintStream(outputStream);
        stream.println("filename,description,lines");
        for (Map.Entry<String, Log> entry : this.logs.entrySet()) {
            Log log = entry.getValue();
            String name = entry.getKey().replace("_", " ").replace(".csv", "");
            String filename = entry.getKey().replace(",", "_");
            stream.println(filename + "," + name + "," + log.lines);
        }
    }

    public void clear() {
        for (File file : this.basePath.listFiles()) {
            if (!file.getName().endsWith(".csv") || CHANGE_LOG.equals(file.getName())) continue;
            file.delete();
        }
    }

    class Log {
        int lines;
        PrintStream stream;

        Log(String file) {
            FileOutputStream outputStream;
            try {
                outputStream = new FileOutputStream(new File(MultiCSVLogger.this.basePath, file), true);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
            this.stream = new PrintStream(outputStream);
        }
    }
}

