/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.bundle.tasks;

import java.io.IOException;
import java.util.Map;
import org.onebusaway.csv_entities.schema.DefaultEntitySchemaFactory;
import org.onebusaway.csv_entities.schema.EntitySchemaFactory;
import org.onebusaway.gtfs.serialization.GtfsEntitySchemaFactory;
import org.onebusaway.gtfs.serialization.GtfsReader;
import org.onebusaway.gtfs.services.GenericMutableDao;
import org.onebusaway.transit_data_federation.bundle.model.GtfsBundle;
import org.onebusaway.transit_data_federation.bundle.model.GtfsBundles;
import org.onebusaway.transit_data_federation.bundle.services.EntityReplacementLogger;
import org.onebusaway.transit_data_federation.bundle.services.EntityReplacementStrategy;
import org.onebusaway.transit_data_federation.bundle.tasks.GtfsMultiReaderImpl;
import org.onebusaway.transit_data_federation.bundle.tasks.MultiCSVLogger;
import org.springframework.context.ApplicationContext;

public class GtfsReadingSupport {
    public static void readGtfsIntoStore(ApplicationContext context, GenericMutableDao store) throws IOException {
        GtfsReadingSupport.readGtfsIntoStore(context, store, false);
    }

    public static void readGtfsIntoStore(ApplicationContext context, GenericMutableDao store, boolean disableStopConsolidation) throws IOException {
        GtfsReadingSupport.readGtfsIntoStore(context, store, GtfsEntitySchemaFactory.createEntitySchemaFactory(), disableStopConsolidation);
    }

    public static void readGtfsIntoStore(ApplicationContext context, GenericMutableDao store, DefaultEntitySchemaFactory factory) throws IOException {
        GtfsReadingSupport.readGtfsIntoStore(context, store, factory, false);
    }

    public static void readGtfsIntoStore(ApplicationContext context, GenericMutableDao store, DefaultEntitySchemaFactory factory, boolean disableStopConsolidation) throws IOException {
        GtfsMultiReaderImpl multiReader = new GtfsMultiReaderImpl();
        multiReader.setStore(store);
        if (!disableStopConsolidation && context.containsBean("entityReplacementStrategy")) {
            EntityReplacementStrategy strategy = (EntityReplacementStrategy)context.getBean("entityReplacementStrategy");
            multiReader.setEntityReplacementStrategy(strategy);
            if (context.containsBean("multiCSVLogger")) {
                MultiCSVLogger csvLogger = (MultiCSVLogger)context.getBean("multiCSVLogger");
                if (context.containsBean("entityReplacementLogger")) {
                    EntityReplacementLogger entityLogger = (EntityReplacementLogger)context.getBean("entityReplacementLogger");
                    entityLogger.setMultiCSVLogger(csvLogger);
                    csvLogger.addListener(entityLogger.getListener());
                    multiReader.setEntityReplacementLogger(entityLogger);
                }
            }
        }
        GtfsBundles gtfsBundles = GtfsReadingSupport.getGtfsBundles(context);
        for (GtfsBundle gtfsBundle : gtfsBundles.getBundles()) {
            System.out.println("gtfs=" + gtfsBundle.getPath());
            GtfsReader reader = new GtfsReader();
            reader.setOverwriteDuplicates(true);
            reader.setEntitySchemaFactory((EntitySchemaFactory)factory);
            reader.setInputLocation(gtfsBundle.getPath());
            if (gtfsBundle.getDefaultAgencyId() != null) {
                reader.setDefaultAgencyId(gtfsBundle.getDefaultAgencyId());
            }
            for (Map.Entry<String, String> entry : gtfsBundle.getAgencyIdMappings().entrySet()) {
                reader.addAgencyIdMapping(entry.getKey(), entry.getValue());
            }
            multiReader.addGtfsReader(reader);
        }
        multiReader.run();
    }

    public static GtfsBundles getGtfsBundles(ApplicationContext context) {
        GtfsBundles bundles = (GtfsBundles)context.getBean("gtfs-bundles");
        if (bundles != null) {
            return bundles;
        }
        GtfsBundle bundle = (GtfsBundle)context.getBean("gtfs-bundle");
        if (bundle != null) {
            bundles = new GtfsBundles();
            bundles.getBundles().add(bundle);
            return bundles;
        }
        throw new IllegalStateException("must define either \"gtfs-bundles\" or \"gtfs-bundle\" in config");
    }
}

