/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.bundle.tasks;

import com.conveyal.gtfs.model.Statistic;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GtfsCsvLogger {
    private Logger _log = LoggerFactory.getLogger(GtfsCsvLogger.class);
    private String _fileName = "gtfs_stats.csv";
    private File basePath;
    private Buffer buff;

    public void setBasePath(File path) {
        this.basePath = path;
    }

    public void open() {
        if (this.basePath == null) {
            this.basePath = new File(System.getProperty("java.io.tmpdir"));
            this._log.warn("GtfsCsvLogger initialized without path:  using " + this.basePath);
        }
        if (!this.basePath.exists()) {
            this.basePath.mkdirs();
        }
    }

    public void close() {
        if (this.buff != null) {
            this.buff.stream.close();
            this.buff = null;
        }
    }

    public void header() {
        this._log.info("creating file=" + this._fileName);
        this.buff = new Buffer(this._fileName);
        this.buff.stream.print("agency,route_count,trip_count,stop_count,stop_times_count,calendar_service_start,calendar_service_end,calendar_start_date,calendar_end_date\n");
    }

    public void addHeader(String headerText) {
        this._log.info("creating file=" + this._fileName);
        this.buff = new Buffer(this._fileName);
        this.buff.stream.print(headerText);
    }

    private String sanitize(String s) {
        if (s == null) {
            return null;
        }
        if (((String)s).contains(",") || ((String)s).contains("\"")) {
            s = "\"" + ((String)s).replace("\"", "\"\"") + "\"";
        }
        return s;
    }

    public void logStat(String id, Statistic s) {
        this.buff.stream.print(s.getAgencyId());
        this.buff.stream.print(",");
        this.buff.stream.print(s.getRouteCount());
        this.buff.stream.print(",");
        this.buff.stream.print(s.getTripCount());
        this.buff.stream.print(",");
        this.buff.stream.print(s.getStopCount());
        this.buff.stream.print(",");
        this.buff.stream.print(s.getStopTimeCount());
        this.buff.stream.print(",");
        this.buff.stream.print(s.getCalendarServiceStart());
        this.buff.stream.print(",");
        this.buff.stream.print(s.getCalendarServiceEnd());
        this.buff.stream.print(",");
        this.buff.stream.print(s.getCalendarStartDate());
        this.buff.stream.print(",");
        this.buff.stream.print(s.getCalendarEndDate());
        this.buff.stream.print("\n");
    }

    public void setFilename(String fileName) {
        this._fileName = fileName;
    }

    public void log(String[] stringArray) {
        int i = 0;
        for (String s : stringArray) {
            if (i != 0) {
                this.buff.stream.print(",");
            }
            this.buff.stream.print(s);
            ++i;
        }
    }

    private class Buffer {
        PrintStream stream;

        Buffer(String file) {
            FileOutputStream outputStream;
            try {
                outputStream = new FileOutputStream(new File(GtfsCsvLogger.this.basePath, file), true);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
            this.stream = new PrintStream(outputStream);
        }
    }
}

