/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.bundle.tasks;

import cern.colt.list.DoubleArrayList;
import cern.jet.stat.Descriptive;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.onebusaway.collections.Counter;
import org.onebusaway.collections.MappingLibrary;
import org.onebusaway.container.refresh.RefreshService;
import org.onebusaway.gtfs.model.Agency;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.DirectionEntry;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.onebusaway.transit_data_federation.bundle.services.UniqueService;
import org.onebusaway.transit_data_federation.bundle.tasks.ShapePointHelper;
import org.onebusaway.transit_data_federation.impl.narrative.NarrativeProviderImpl;
import org.onebusaway.transit_data_federation.impl.shapes.DistanceTraveledShapePointIndex;
import org.onebusaway.transit_data_federation.impl.shapes.PointAndOrientation;
import org.onebusaway.transit_data_federation.model.ProjectedPoint;
import org.onebusaway.transit_data_federation.model.ShapePoints;
import org.onebusaway.transit_data_federation.model.modifications.Modifications;
import org.onebusaway.transit_data_federation.model.narrative.AgencyNarrative;
import org.onebusaway.transit_data_federation.model.narrative.RouteAndHeadsignNarrative;
import org.onebusaway.transit_data_federation.model.narrative.RouteCollectionNarrative;
import org.onebusaway.transit_data_federation.model.narrative.StopDirectionKey;
import org.onebusaway.transit_data_federation.model.narrative.StopNarrative;
import org.onebusaway.transit_data_federation.model.narrative.StopTimeNarrative;
import org.onebusaway.transit_data_federation.model.narrative.TripNarrative;
import org.onebusaway.transit_data_federation.services.FederatedTransitDataBundle;
import org.onebusaway.transit_data_federation.services.blocks.BlockIndexService;
import org.onebusaway.transit_data_federation.services.blocks.BlockStopTimeIndex;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockStopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.RouteCollectionEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.RouteEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.StopEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.StopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TransitGraphDao;
import org.onebusaway.transit_data_federation.services.transit_graph.TripEntry;
import org.onebusaway.transit_data_federation.util.LoggingIntervalUtil;
import org.onebusaway.utility.ObjectSerializationLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class GenerateNarrativesTask
implements Runnable {
    private Logger _log = LoggerFactory.getLogger(GenerateNarrativesTask.class);
    private FederatedTransitDataBundle _bundle;
    private GtfsRelationalDao _gtfsDao;
    private TransitGraphDao _transitGraphDao;
    private BlockIndexService _blockIndexService;
    private Modifications _modifications;
    private ShapePointHelper _shapePointsHelper;
    private UniqueService _uniqueService;
    private RefreshService _refreshService;
    private double _stopDirectionStandardDeviationThreshold = 0.7;

    @Autowired
    public void setBundle(FederatedTransitDataBundle bundle) {
        this._bundle = bundle;
    }

    @Autowired
    public void setGtfsDao(GtfsRelationalDao gtfsDao) {
        this._gtfsDao = gtfsDao;
    }

    @Autowired
    public void setTransitGraphDao(TransitGraphDao transitGraphDao) {
        this._transitGraphDao = transitGraphDao;
    }

    @Autowired
    public void setBlockIndexService(BlockIndexService blockIndexService) {
        this._blockIndexService = blockIndexService;
    }

    @Autowired
    public void setModifications(Modifications modifications) {
        this._modifications = modifications;
    }

    @Autowired
    public void setShapePointHelper(ShapePointHelper shapePointHelper) {
        this._shapePointsHelper = shapePointHelper;
    }

    @Autowired
    public void setUniqueService(UniqueService uniqueService) {
        this._uniqueService = uniqueService;
    }

    @Autowired
    public void setRefreshService(RefreshService refreshService) {
        this._refreshService = refreshService;
    }

    public void setStopDirectionStandardDeviationThreshold(double stopDirectionStandardDeviationThreshold) {
        this._stopDirectionStandardDeviationThreshold = stopDirectionStandardDeviationThreshold;
    }

    @Override
    public void run() {
        NarrativeProviderImpl provider = new NarrativeProviderImpl();
        this.generateAgencyNarratives(provider);
        this.generateRouteNarratives(provider);
        this.generateShapePointNarratives(provider);
        this.generateStopNarratives(provider);
        this.generateTripNarratives(provider);
        this.generateRouteHeadsignPatterns(provider);
        try {
            ObjectSerializationLibrary.writeObject((File)this._bundle.getNarrativeProviderPath(), (Object)provider);
            this._refreshService.refresh("narrativeData");
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private void generateRouteHeadsignPatterns(NarrativeProviderImpl provider) {
        if (this._gtfsDao.getAllDirectionEntries() == null) {
            this._log.info("no directionEntries to process");
            return;
        }
        for (DirectionEntry de : this._gtfsDao.getAllDirectionEntries()) {
            List<StopDirectionKey> sdNorths = this.createStopDirectionKey(de, "0");
            RouteAndHeadsignNarrative rhNorth = new RouteAndHeadsignNarrative(de.getHeadsignDirection0(), de.getLine());
            for (StopDirectionKey sdNorth : sdNorths) {
                provider.addRouteAndHeadsign(sdNorth, rhNorth);
            }
            List<StopDirectionKey> sdSouths = this.createStopDirectionKey(de, "1");
            RouteAndHeadsignNarrative rhSouth = new RouteAndHeadsignNarrative(de.getHeadsignDirection1(), de.getLine());
            for (StopDirectionKey sdSouth : sdSouths) {
                provider.addRouteAndHeadsign(sdSouth, rhSouth);
            }
            AgencyAndId northStopId = new AgencyAndId(de.getAgencyId(), de.getGtfsStopIdDirection0());
            AgencyAndId southStopId = new AgencyAndId(de.getAgencyId(), de.getGtfsStopIdDirection1());
            List<AgencyAndId> daytimeRoutes = this.createRoutes(de.getAgencyId(), de.getDaytimeRoutes());
            if (daytimeRoutes == null) continue;
            provider.addStaticRoute(northStopId, daytimeRoutes);
            provider.addStaticRoute(southStopId, daytimeRoutes);
        }
        this._log.info("processed {} directionEntries with cache size {}", (Object)this._gtfsDao.getAllDirectionEntries().size(), (Object)provider.getPatternCount());
    }

    private List<AgencyAndId> createRoutes(String agencyId, String daytimeRoutes) {
        ArrayList<AgencyAndId> routes = new ArrayList<AgencyAndId>();
        if (daytimeRoutes != null) {
            for (String routeId : daytimeRoutes.split("\\s")) {
                if (!StringUtils.isNotBlank((String)routeId)) continue;
                routes.add(new AgencyAndId(agencyId, routeId));
            }
        }
        if (routes.isEmpty()) {
            return null;
        }
        return routes;
    }

    private List<StopDirectionKey> createStopDirectionKey(DirectionEntry de, String directionId) {
        ArrayList<StopDirectionKey> list = new ArrayList<StopDirectionKey>();
        if ("0".equals(directionId)) {
            list.add(new StopDirectionKey(new AgencyAndId(de.getAgencyId(), de.getGtfsStopIdDirection0()), "0"));
        } else if ("1".equals(directionId)) {
            list.add(new StopDirectionKey(new AgencyAndId(de.getAgencyId(), de.getGtfsStopIdDirection1()), "1"));
        }
        return list;
    }

    public void generateAgencyNarratives(NarrativeProviderImpl provider) {
        for (Agency agency : this._gtfsDao.getAllAgencies()) {
            Boolean privateService;
            AgencyNarrative.Builder narrative = AgencyNarrative.builder();
            narrative.setLang(this.deduplicate(agency.getLang()));
            narrative.setName(this.deduplicate(agency.getName()));
            narrative.setPhone(this.deduplicate(agency.getPhone()));
            narrative.setEmail(this.deduplicate(agency.getEmail()));
            narrative.setTimezone(this.deduplicate(agency.getTimezone()));
            narrative.setUrl(this.deduplicate(agency.getUrl()));
            narrative.setFareUrl(agency.getFareUrl());
            String disclaimer = (String)this._modifications.getModificationForTypeAndId(AgencyNarrative.class, agency.getId(), "disclaimer");
            if (disclaimer != null) {
                narrative.setDisclaimer(disclaimer);
            }
            if ((privateService = (Boolean)this._modifications.getModificationForTypeAndId(AgencyNarrative.class, agency.getId(), "privatService")) != null) {
                narrative.setPrivateService(privateService.booleanValue());
            }
            provider.setNarrativeForAgency(agency.getId(), narrative.create());
        }
    }

    public void generateRouteNarratives(NarrativeProviderImpl provider) {
        for (RouteCollectionEntry routeCollectionEntry : this._transitGraphDao.getAllRouteCollections()) {
            ArrayList<Route> routes = new ArrayList<Route>();
            Counter tripCounts = new Counter();
            for (RouteEntry routeEntry : routeCollectionEntry.getChildren()) {
                Route route = this._gtfsDao.getRouteForId(routeEntry.getId());
                routes.add(route);
                int tripCount = routeEntry.getTrips().size();
                tripCounts.increment((Object)route, tripCount);
            }
            RouteCollectionNarrative.Builder builder = RouteCollectionNarrative.builder();
            this.setPropertiesOfRouteCollectionFromRoutes(routes, (Counter<Route>)tripCounts, builder);
            provider.setNarrativeForRouteCollectionId(routeCollectionEntry.getId(), builder.create());
        }
    }

    public void generateShapePointNarratives(NarrativeProviderImpl provider) {
        List shapeIds = this._gtfsDao.getAllShapeIds();
        int shapeSize = shapeIds.size();
        this._log.info("shapes to process=" + shapeSize);
        int logInterval = LoggingIntervalUtil.getAppropriateLoggingInterval((int)shapeSize) * 10;
        int index = 0;
        for (AgencyAndId shapeId : shapeIds) {
            if (index % logInterval == 0) {
                this._log.info("shapes=" + index);
            }
            ++index;
            ShapePoints shapePoints = this._shapePointsHelper.getShapePointsForShapeId(shapeId);
            provider.setShapePointsForId(shapeId, shapePoints);
        }
    }

    public void generateStopNarratives(NarrativeProviderImpl provider) {
        HashMap<AgencyAndId, List<ProjectedPoint>> shapePointCache = new HashMap<AgencyAndId, List<ProjectedPoint>>();
        int index = 0;
        Collection allStops = this._gtfsDao.getAllStops();
        Map stopsById = MappingLibrary.mapToValue((Iterable)allStops, (String)"id");
        int logInterval = LoggingIntervalUtil.getAppropriateLoggingInterval((int)allStops.size());
        for (StopEntry stopEntry : this._transitGraphDao.getAllStops()) {
            if (index % logInterval == 0) {
                this._log.info("stops=" + index);
            }
            ++index;
            Stop stop = (Stop)stopsById.get(stopEntry.getId());
            StopNarrative.Builder narrative = StopNarrative.builder();
            narrative.setCode(this.deduplicate(stop.getCode()));
            narrative.setDescription(this.deduplicate(stop.getDesc()));
            narrative.setName(this.deduplicate(stop.getName()));
            narrative.setUrl(this.deduplicate(stop.getUrl()));
            String direction = this.computeStopDirection(provider, shapePointCache, stop, stopEntry);
            narrative.setDirection(this.deduplicate(direction));
            provider.setNarrativeForStop(stopEntry.getId(), narrative.create());
        }
    }

    public void generateTripNarratives(NarrativeProviderImpl provider) {
        int tripIndex = 0;
        Collection trips = this._gtfsDao.getAllTrips();
        int logInterval = LoggingIntervalUtil.getAppropriateLoggingInterval((int)trips.size());
        for (Trip trip : trips) {
            if (tripIndex % logInterval == 0) {
                this._log.info("trips=" + tripIndex + " of " + trips.size());
            }
            ++tripIndex;
            TripNarrative tripNarrative = this.getTripNarrative(trip);
            provider.setNarrativeForTripId(trip.getId(), tripNarrative);
            List stopTimes = this._gtfsDao.getStopTimesForTrip(trip);
            ArrayList<AgencyAndId> stopIds = new ArrayList<AgencyAndId>();
            for (StopTime stopTime : stopTimes) {
                if (stopTime.getStop() == null) {
                    stopIds.add(new AgencyAndId(trip.getId().getAgencyId(), "null"));
                    continue;
                }
                stopIds.add(stopTime.getStop().getId());
            }
            ArrayList<StopTimeNarrative> narratives = new ArrayList<StopTimeNarrative>();
            int stopTimeIndex = 0;
            for (StopTime stopTime : stopTimes) {
                StopTimeNarrative stopTimeNarrative = this.getStopTimeNarrative(stopTime);
                provider.setNarrativeForStopTimeEntry(trip.getId(), stopTimeIndex++, stopTimeNarrative);
                narratives.add(stopTimeNarrative);
            }
            if (trip.getRoute() == null) continue;
            provider.setNarrativesForStops(trip.getRoute().getId(), trip.getDirectionId(), stopIds, narratives);
        }
    }

    private void setPropertiesOfRouteCollectionFromRoutes(List<Route> routes, Counter<Route> tripCounts, RouteCollectionNarrative.Builder target) {
        Counter shortNames = new Counter();
        Counter longNames = new Counter();
        Counter descriptions = new Counter();
        Counter colors = new Counter();
        Counter textColors = new Counter();
        Counter urls = new Counter();
        Counter types = new Counter();
        for (Route route : routes) {
            int count = tripCounts.getCount((Object)route);
            this.addValueToCounterIfValid(route.getShortName(), (Counter<String>)shortNames, count);
            this.addValueToCounterIfValid(route.getLongName(), (Counter<String>)longNames, count);
            this.addValueToCounterIfValid(route.getDesc(), (Counter<String>)descriptions, count);
            this.addValueToCounterIfValid(route.getColor(), (Counter<String>)colors, count);
            this.addValueToCounterIfValid(route.getTextColor(), (Counter<String>)textColors, count);
            this.addValueToCounterIfValid(route.getUrl(), (Counter<String>)urls, count);
            types.increment((Object)route.getType(), count);
        }
        if (shortNames.size() > 0) {
            target.setShortName(this.deduplicate((String)shortNames.getMax()));
        }
        if (longNames.size() > 0) {
            target.setLongName(this.deduplicate((String)longNames.getMax()));
        }
        if (descriptions.size() > 0) {
            target.setDescription(this.deduplicate((String)descriptions.getMax()));
        }
        if (colors.size() > 0) {
            target.setColor(this.deduplicate((String)colors.getMax()));
        }
        if (textColors.size() > 0) {
            target.setTextColor(this.deduplicate((String)textColors.getMax()));
        }
        if (urls.size() > 0) {
            target.setUrl(this.deduplicate((String)urls.getMax()));
        }
        target.setType(this.deduplicate((Integer)types.getMax()).intValue());
    }

    private <T> void addValueToCounterIfValid(String value, Counter<String> counts, int count) {
        if ((value = this.trim(value)) != null && value.length() > 0) {
            counts.increment((Object)value, count);
        }
    }

    private String computeStopDirection(NarrativeProviderImpl provider, Map<AgencyAndId, List<ProjectedPoint>> shapePointCache, Stop stop, StopEntry stopEntry) {
        String direction = this.translateGtfsDirection(stop.getDirection());
        if (direction != null) {
            return direction;
        }
        Collection<PointAndOrientation> orientations = this.getAllOrientationsForStop(provider, stopEntry);
        DoubleArrayList ys = new DoubleArrayList();
        DoubleArrayList xs = new DoubleArrayList();
        for (PointAndOrientation po : orientations) {
            double orientation = Math.toRadians(po.getOrientation());
            double x = Math.cos(orientation);
            double y = Math.sin(orientation);
            xs.add(x);
            ys.add(y);
        }
        if (ys.isEmpty()) {
            return null;
        }
        if (ys.size() == 1) {
            double theta = Math.atan2(ys.get(0), xs.get(0));
            return this.getAngleAsDirection(theta);
        }
        double yMu = Descriptive.mean((DoubleArrayList)ys);
        double xMu = Descriptive.mean((DoubleArrayList)xs);
        if (yMu == 0.0 && xMu == 0.0) {
            return null;
        }
        double thetaMu = Math.atan2(yMu, xMu);
        double yVariance = Descriptive.sampleVariance((DoubleArrayList)ys, (double)yMu);
        double xVariance = Descriptive.sampleVariance((DoubleArrayList)xs, (double)xMu);
        double yStdDev = Descriptive.sampleStandardDeviation((int)ys.size(), (double)yVariance);
        double xStdDev = Descriptive.sampleStandardDeviation((int)xs.size(), (double)xVariance);
        if (yStdDev > this._stopDirectionStandardDeviationThreshold || xStdDev > this._stopDirectionStandardDeviationThreshold) {
            return null;
        }
        DoubleArrayList normalizedThetas = new DoubleArrayList();
        for (PointAndOrientation po : orientations) {
            double orientation = Math.toRadians(po.getOrientation());
            double delta = orientation - thetaMu;
            delta = this.normalizeDelta(delta);
            orientation = thetaMu + delta;
            normalizedThetas.add(orientation);
        }
        normalizedThetas.sort();
        double thetaMedian = Descriptive.median((DoubleArrayList)normalizedThetas);
        return this.getAngleAsDirection(thetaMedian);
    }

    private double normalizeDelta(double delta) {
        while (delta < -Math.PI) {
            delta += Math.PI * 2;
        }
        while (delta >= Math.PI) {
            delta -= Math.PI * 2;
        }
        return delta;
    }

    private String translateGtfsDirection(String direction) {
        if (direction == null) {
            return null;
        }
        if ((direction = direction.toLowerCase()).equals("north")) {
            return "N";
        }
        if (direction.equals("east")) {
            return "E";
        }
        if (direction.equals("south")) {
            return "S";
        }
        if (direction.equals("west")) {
            return "W";
        }
        if (direction.equals("northeast")) {
            return "NE";
        }
        if (direction.equals("southeast")) {
            return "SE";
        }
        if (direction.equals("southwest")) {
            return "SW";
        }
        if (direction.equals("northwest")) {
            return "NW";
        }
        try {
            double orientation = Double.parseDouble(direction);
            orientation = Math.toRadians(orientation);
            return this.getAngleAsDirection(orientation);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private Collection<PointAndOrientation> getAllOrientationsForStop(NarrativeProviderImpl provider, StopEntry stop) {
        List stopTimeIndices = this._blockIndexService.getStopTimeIndicesForStop(stop);
        ArrayList<PointAndOrientation> pos = new ArrayList<PointAndOrientation>();
        HashMap<ShapeIdAndDistance, PointAndOrientation> orientationsByKey = new HashMap<ShapeIdAndDistance, PointAndOrientation>();
        for (BlockStopTimeIndex stopTimeIndex : stopTimeIndices) {
            for (BlockStopTimeEntry blockStopTime : stopTimeIndex.getStopTimes()) {
                int shapePointIndex;
                ShapePoints shapePoints;
                StopTimeEntry stopTime = blockStopTime.getStopTime();
                TripEntry trip = stopTime.getTrip();
                AgencyAndId shapeId = trip.getShapeId();
                if (shapeId == null || (shapePoints = provider.getShapePointsForId(shapeId)) == null || (shapePointIndex = stopTime.getShapePointIndex()) == -1) continue;
                ShapeIdAndDistance key = new ShapeIdAndDistance(shapeId, stopTime.getShapeDistTraveled());
                PointAndOrientation orientation = (PointAndOrientation)orientationsByKey.get(key);
                if (orientation == null) {
                    int indexFrom = Math.max(0, shapePointIndex - 5);
                    int indexTo = Math.min(shapePoints.getSize(), shapePointIndex + 5);
                    DistanceTraveledShapePointIndex shapePointIndexMethod = new DistanceTraveledShapePointIndex(stopTime.getShapeDistTraveled(), indexFrom, indexTo);
                    orientation = shapePointIndexMethod.getPointAndOrientation(shapePoints);
                    if (orientation == null) continue;
                    orientationsByKey.put(key, orientation);
                }
                pos.add(orientation);
            }
        }
        return orientationsByKey.values();
    }

    private StopTimeNarrative getStopTimeNarrative(StopTime stopTime) {
        StopTimeNarrative.Builder builder = StopTimeNarrative.builder();
        builder.setRouteShortName(this.deduplicate(stopTime.getRouteShortName()));
        builder.setStopHeadsign(this.deduplicate(stopTime.getStopHeadsign()));
        return this.deduplicate(builder.create());
    }

    private TripNarrative getTripNarrative(Trip trip) {
        String headsign = trip.getTripHeadsign();
        if (headsign == null) {
            Route route = trip.getRoute();
            headsign = route.getLongName();
        }
        TripNarrative.Builder builder = TripNarrative.builder();
        builder.setRouteShortName(this.deduplicate(trip.getRouteShortName()));
        builder.setTripHeadsign(this.deduplicate(headsign));
        builder.setTripShortName(this.deduplicate(trip.getTripShortName()));
        builder.setPeakOffpeak(trip.getPeakOffpeak());
        return builder.create();
    }

    private String getAngleAsDirection(double theta) {
        double t = 0.7853981633974483;
        int r = (int)Math.floor((theta + t / 2.0) / t);
        switch (r) {
            case 0: {
                return "E";
            }
            case 1: {
                return "NE";
            }
            case 2: {
                return "N";
            }
            case 3: {
                return "NW";
            }
            case 4: {
                return "W";
            }
            case -1: {
                return "SE";
            }
            case -2: {
                return "S";
            }
            case -3: {
                return "SW";
            }
            case -4: {
                return "W";
            }
        }
        return "?";
    }

    private String trim(String value) {
        if (value == null) {
            return value;
        }
        return value.trim();
    }

    private <T> T deduplicate(T object) {
        if (object == null) {
            return null;
        }
        return this._uniqueService.unique(object);
    }

    private static class ShapeIdAndDistance {
        private final AgencyAndId _shapeId;
        private final double _distanceAlongShape;

        public ShapeIdAndDistance(AgencyAndId shapeId, double distanceAlongShape) {
            this._shapeId = shapeId;
            this._distanceAlongShape = distanceAlongShape;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            long temp = Double.doubleToLongBits(this._distanceAlongShape);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            result = 31 * result + (this._shapeId == null ? 0 : this._shapeId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ShapeIdAndDistance other = (ShapeIdAndDistance)obj;
            if (Double.doubleToLongBits(this._distanceAlongShape) != Double.doubleToLongBits(other._distanceAlongShape)) {
                return false;
            }
            return !(this._shapeId == null ? other._shapeId != null : !this._shapeId.equals((Object)other._shapeId));
        }
    }
}

