/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.bundle.tasks;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.onebusaway.transit_data_federation.bundle.services.EntityReplacementLogger;
import org.onebusaway.transit_data_federation.bundle.services.EntityReplacementStrategy;

public class EntityReplacementStrategyImpl
implements EntityReplacementStrategy {
    private Map<Class<?>, Map<Serializable, Serializable>> _entityReplacement = new HashMap();
    private EntityReplacementLogger _entityLogger = null;

    @Override
    public void setEntityReplacementLogger(EntityReplacementLogger logger) {
        this._entityLogger = logger;
    }

    public void addEntityReplacement(Class<?> entityType, Serializable entityId, Serializable replacementEntityId) {
        Map<Serializable, Serializable> idMappings = this._entityReplacement.get(entityType);
        if (idMappings == null) {
            idMappings = new HashMap<Serializable, Serializable>();
            this._entityReplacement.put(entityType, idMappings);
        }
        idMappings.put(entityId, replacementEntityId);
    }

    @Override
    public boolean hasReplacementEntities(Class<?> entityType) {
        return this._entityReplacement.containsKey(entityType);
    }

    @Override
    public boolean hasReplacementEntity(Class<?> entityType, Serializable entityId) {
        Map<Serializable, Serializable> idMappings = this._entityReplacement.get(entityType);
        if (idMappings == null) {
            return false;
        }
        return idMappings.containsKey(entityId);
    }

    @Override
    public Serializable getReplacementEntityId(Class<?> entityType, Serializable entityId) {
        Map<Serializable, Serializable> idMappings = this._entityReplacement.get(entityType);
        if (idMappings == null) {
            return null;
        }
        return idMappings.get(entityId);
    }

    @Override
    public <T> T logReplacement(Class<T> type, Serializable id, Serializable replacementId, T originalEntity, T replacementEntity) {
        if (this._entityLogger != null) {
            this._entityLogger.log(type, id, replacementId, originalEntity, replacementEntity);
        }
        return replacementEntity;
    }
}

