/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.bundle.tasks;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.transit_data_federation.bundle.services.EntityReplacementStrategy;
import org.onebusaway.transit_data_federation.bundle.tasks.EntityReplacementStrategyImpl;
import org.onebusaway.util.AgencyAndIdLibrary;
import org.onebusaway.utility.IOLibrary;

public class EntityReplacementStrategyFactory {
    private Map<Class<?>, String> _mappings = new HashMap();

    public void setEntityMappings(Map<Class<?>, String> mappings) {
        this._mappings.putAll(mappings);
    }

    public void test() {
    }

    public EntityReplacementStrategy create() throws IOException {
        EntityReplacementStrategyImpl impl = new EntityReplacementStrategyImpl();
        for (Map.Entry<Class<?>, String> entry : this._mappings.entrySet()) {
            Class<?> entityClass = entry.getKey();
            InputStream in = IOLibrary.getPathAsInputStream((String)entry.getValue());
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() == 0 || line.startsWith("#") || line.startsWith("{{{") || line.startsWith("}}}")) continue;
                String[] tokens = line.contains("\"") ? line.split("\"") : line.split("\\s+");
                ArrayList<AgencyAndId> ids = new ArrayList<AgencyAndId>();
                for (String token : tokens) {
                    if (!StringUtils.isNotBlank((String)token)) continue;
                    ids.add(AgencyAndIdLibrary.convertFromString((String)token));
                }
                for (int i = 1; i < ids.size(); ++i) {
                    impl.addEntityReplacement(entityClass, (Serializable)ids.get(i), (Serializable)ids.get(0));
                }
            }
        }
        return impl;
    }
}

