/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.bundle.tasks;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.onebusaway.gtfs.model.Block;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.onebusaway.transit_data_federation.model.bundle.BlockRunIndex;
import org.onebusaway.transit_data_federation.services.FederatedTransitDataBundle;
import org.onebusaway.utility.ObjectSerializationLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class BlockRunTask
implements Runnable {
    private FederatedTransitDataBundle _bundle;
    private GtfsRelationalDao _gtfsDao;
    private Logger _log = LoggerFactory.getLogger(BlockRunTask.class);

    @Autowired
    public void setBundle(FederatedTransitDataBundle bundle) {
        this._bundle = bundle;
    }

    @Autowired
    public void setGtfsDao(GtfsRelationalDao gtfsDao) {
        this._gtfsDao = gtfsDao;
    }

    @Override
    public void run() {
        try {
            this._log.error("BlockRunTask with " + this._gtfsDao.getAllBlocks().size() + " blocks");
            HashMap<String, List<BlockRunIndex>> map = new HashMap<String, List<BlockRunIndex>>();
            for (Block blockRun : this._gtfsDao.getAllBlocks()) {
                this.addRunBlock(map, blockRun.getBlockRun(), blockRun.getBlockRoute(), blockRun.getBlockSequence(), blockRun.getBlockVariable());
            }
            ObjectSerializationLibrary.writeObject((File)this._bundle.getBlockRunDataPath(), map);
        }
        catch (Exception ex) {
            this._log.error("fatal exception building BlockRunIndex:", (Throwable)ex);
        }
    }

    private void addRunBlock(Map<String, List<BlockRunIndex>> map, int blockRun, int blockRoute, int blockSequence, int blockVariable) {
        List<Object> list;
        String key = this.hash(blockRoute, blockRun);
        if (!map.containsKey(key)) {
            list = new ArrayList();
            map.put(key, list);
        } else {
            list = map.get(key);
        }
        BlockRunIndex.Builder index = BlockRunIndex.builder();
        index.setRunId(blockRun);
        index.setRouteKey(blockRoute);
        index.setBlockId(blockSequence);
        list.add(index.create());
    }

    private String hash(Integer routeKey, Integer runId) {
        if (routeKey == null || runId == null) {
            return null;
        }
        return routeKey + ":" + runId;
    }
}

