/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.bundle.tasks;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.onebusaway.gtfs.services.GtfsDao;
import org.onebusaway.transit_data_federation.bundle.tasks.MultiCSVLogger;
import org.onebusaway.transit_data_federation.bundle.tasks.StopVerificationTask;
import org.onebusaway.utility.IOLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractStopTask {
    protected static Logger _log = LoggerFactory.getLogger(StopVerificationTask.class);
    @Autowired
    protected MultiCSVLogger _logger;
    protected GtfsDao _dao;
    private String path = null;

    @Autowired
    public void setGtfsDao(GtfsDao dao) {
        this._dao = dao;
    }

    public void setLogger(MultiCSVLogger logger) {
        this._logger = logger;
    }

    public void setPath(String path) {
        this.path = path;
    }

    protected abstract void insertHeader();

    protected abstract void verifyStops(String var1, List<String> var2);

    public void run() {
        if (this.path == null || this.path.length() == 0) {
            _log.info("path not configured, exiting");
            return;
        }
        this.insertHeader();
        _log.info("running verification task from path=" + this.path);
        try {
            InputStream in = IOLibrary.getPathAsInputStream((String)this.path);
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            String line = null;
            while ((line = reader.readLine()) != null) {
                String[] tokens;
                if ((line = line.trim()).length() == 0 || line.startsWith("#") || line.startsWith("{{{") || line.startsWith("}}}") || (tokens = line.split("\\s+")).length < 1) continue;
                String rootStop = tokens[0];
                ArrayList<String> consolidatedStops = new ArrayList<String>(Arrays.asList(tokens));
                consolidatedStops.remove(0);
                this.verifyStops(rootStop, consolidatedStops);
            }
        }
        catch (Exception e) {
            _log.error("run failed", (Throwable)e);
        }
        _log.info("exiting verification task");
    }
}

