/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.bundle;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import org.onebusaway.collections.CollectionsLibrary;
import org.onebusaway.container.ContainerLibrary;
import org.onebusaway.container.spring.PropertyOverrideConfigurer;
import org.onebusaway.transit_data_federation.bundle.UnknownTaskException;
import org.onebusaway.transit_data_federation.bundle.model.StatusMessages;
import org.onebusaway.transit_data_federation.bundle.model.TaskDefinition;
import org.onebusaway.transit_data_federation.impl.DirectedGraph;
import org.onebusaway.transit_data_federation.services.FederatedTransitDataBundle;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class FederatedTransitDataBundleCreator {
    private static final String BUNDLE_RESOURCE = "classpath:org/onebusaway/transit_data_federation/bundle/application-context-bundle-creator.xml";
    private ConfigurableApplicationContext _context;
    private List<String> _contextPaths = new ArrayList<String>();
    private Map<String, BeanDefinition> _contextBeans = new HashMap<String, BeanDefinition>();
    private Properties _additionalBeanPropertyOverrides;
    private File _outputPath;
    private Set<String> _skipTasks = new HashSet<String>();
    private Set<String> _includeTasks = new HashSet<String>();
    private Set<String> _onlyTasks = new HashSet<String>();
    private String _skipToTask;
    private boolean _randomizeCacheDir = false;
    private String _bundleKey;
    private StatusMessages _status = new StatusMessages();

    @Autowired
    public void setContext(ConfigurableApplicationContext context) {
        this._context = context;
    }

    public void setContextPaths(List<String> paths) {
        this._contextPaths = paths;
    }

    public void setContextBeans(Map<String, BeanDefinition> contextBeans) {
        this._contextBeans = contextBeans;
    }

    public void setOutputPath(File outputPath) {
        this._outputPath = outputPath;
    }

    public void setBundleKey(String key) {
        this._bundleKey = key;
    }

    public void addTaskToOnlyRun(String onlyTask) {
        this._onlyTasks.add(onlyTask);
    }

    public void addTaskToSkip(String taskToSkip) {
        this._skipTasks.add(taskToSkip);
    }

    public void addTaskToInclude(String taskToInclude) {
        this._includeTasks.add(taskToInclude);
    }

    public void setSkipToTask(String taskName) {
        this._skipToTask = taskName;
    }

    public void setRandomizeCacheDir(boolean randomizeCacheDir) {
        this._randomizeCacheDir = randomizeCacheDir;
    }

    public void setAdditionalBeanPropertyOverrides(Properties props) {
        this._additionalBeanPropertyOverrides = props;
    }

    public StatusMessages getStatusMessages() {
        return this._status;
    }

    public void run() throws IOException, ClassNotFoundException, UnknownTaskException {
        this._outputPath.mkdirs();
        this.setSystemProperties();
        ConfigurableApplicationContext context = this._context;
        boolean closeContextOnCompletion = false;
        if (context == null) {
            List<String> contextPaths = this.getPrimaryApplicatonContextPaths();
            Map<String, BeanDefinition> contextBeans = this.getPrimaryBeanDefintions();
            context = ContainerLibrary.createContext(contextPaths, contextBeans);
            closeContextOnCompletion = true;
        }
        List<TaskDefinition> taskDefinitions = this.getTaskList((ApplicationContext)context);
        Set<String> taskNames = this.getReducedTaskList(taskDefinitions);
        FederatedTransitDataBundle bundle = (FederatedTransitDataBundle)context.getBean(FederatedTransitDataBundle.class);
        this.clearExistingCacheFiles(bundle);
        int taskSize = taskNames.size();
        int i = 0;
        for (TaskDefinition def : taskDefinitions) {
            Runnable task;
            String taskName = def.getTaskName();
            if (taskNames.contains(taskName)) {
                System.out.println("== " + taskName + " =====>");
                this._status.addMessage("running task " + taskName + " (" + ++i + "/" + taskSize + ")");
                task = this.getTask((ApplicationContext)context, def.getTask(), def.getTaskBeanName());
                if (task == null) {
                    throw new IllegalStateException("unknown task bean with name: " + taskName);
                }
                task.run();
                continue;
            }
            task = this.getTask((ApplicationContext)context, def.getTaskWhenSkipped(), def.getTaskWhenSkippedBeanName());
            if (task == null) continue;
            System.out.println("== skipping " + taskName + " =====>");
            this._status.addMessage("skipping task " + taskName);
            task.run();
        }
        if (closeContextOnCompletion) {
            context.stop();
            context.close();
            context = null;
        }
    }

    private void setSystemProperties() {
        System.setProperty("bundlePath", this._outputPath.getAbsolutePath());
        String cacheDir = this._outputPath.getAbsolutePath() + File.separator + "cache";
        if (this._randomizeCacheDir) {
            cacheDir = cacheDir + "-" + UUID.randomUUID().toString();
        }
        System.setProperty("bundleCacheDir", cacheDir);
        boolean resetDatabase = this.isDatabaseResetNeeded();
        if (resetDatabase) {
            System.setProperty("hibernate.hbm2ddl.auto", "create");
        } else {
            System.setProperty("hibernate.hbm2ddl.auto", "update");
        }
    }

    private boolean isDatabaseResetNeeded() {
        if (this._skipToTask != null) {
            return "start".equals(this._skipToTask);
        }
        if (!this._onlyTasks.isEmpty()) {
            return this._onlyTasks.contains("start");
        }
        return !this._skipTasks.contains("start");
    }

    private List<String> getPrimaryApplicatonContextPaths() {
        ArrayList<String> paths = new ArrayList<String>();
        paths.add(BUNDLE_RESOURCE);
        for (String contextPath : this._contextPaths) {
            paths.add(contextPath);
        }
        return paths;
    }

    private Map<String, BeanDefinition> getPrimaryBeanDefintions() {
        HashMap<String, BeanDefinition> beans = new HashMap<String, BeanDefinition>();
        beans.putAll(this._contextBeans);
        Properties p = new Properties();
        if (this._bundleKey != null) {
            p.setProperty("bundle.key", this._bundleKey);
        }
        if (this._additionalBeanPropertyOverrides != null) {
            p.putAll((Map<?, ?>)this._additionalBeanPropertyOverrides);
        }
        BeanDefinitionBuilder propertyOverrides = BeanDefinitionBuilder.genericBeanDefinition(PropertyOverrideConfigurer.class);
        propertyOverrides.addPropertyValue("properties", (Object)p);
        beans.put("myCustomPropertyOverrides", (BeanDefinition)propertyOverrides.getBeanDefinition());
        return beans;
    }

    private void clearExistingCacheFiles(FederatedTransitDataBundle bundle) {
        File cacheDir = bundle.getCachePath();
        if (!cacheDir.exists()) {
            return;
        }
        File[] files = cacheDir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (!file.isFile()) continue;
            file.delete();
        }
    }

    private Runnable getTask(ApplicationContext context, Runnable task, String taskBeanName) {
        if (task == null && taskBeanName != null) {
            task = (Runnable)context.getBean(taskBeanName, Runnable.class);
        }
        return task;
    }

    private List<TaskDefinition> getTaskList(ApplicationContext context) throws UnknownTaskException {
        Map taskDefinitions = context.getBeansOfType(TaskDefinition.class);
        Map<String, TaskDefinition> taskDefinitionsByTaskName = this.getTaskDefinitionsByName(taskDefinitions);
        DirectedGraph graph = new DirectedGraph();
        for (TaskDefinition taskDefinition : taskDefinitions.values()) {
            List<String> afters;
            String taskName = taskDefinition.getTaskName();
            graph.addNode((Object)taskName);
            String before = taskDefinition.getBeforeTaskName();
            if (before != null) {
                if (!taskDefinitionsByTaskName.containsKey(before)) {
                    throw new UnknownTaskException(before);
                }
                graph.addEdge((Object)taskName, (Object)before);
            }
            if (CollectionsLibrary.isEmpty(afters = taskDefinition.getAfterTaskNames())) continue;
            for (String after : afters) {
                if (!taskDefinitionsByTaskName.containsKey(after)) {
                    throw new UnknownTaskException(after);
                }
                graph.addEdge((Object)after, (Object)taskName);
            }
        }
        List taskNames = graph.getTopologicalSort(null);
        ArrayList<TaskDefinition> taskDefinitionsInOrder = new ArrayList<TaskDefinition>();
        for (String taskName : taskNames) {
            TaskDefinition task = taskDefinitionsByTaskName.get(taskName);
            taskDefinitionsInOrder.add(task);
        }
        return taskDefinitionsInOrder;
    }

    private Map<String, TaskDefinition> getTaskDefinitionsByName(Map<String, TaskDefinition> taskDefinitions) {
        HashMap<String, TaskDefinition> taskDefinitionsByTaskName = new HashMap<String, TaskDefinition>();
        for (TaskDefinition taskDefinition : taskDefinitions.values()) {
            String taskName = taskDefinition.getTaskName();
            if (taskName == null || taskName.trim().length() == 0) {
                throw new IllegalStateException("no taskName property defined for task definition: " + taskDefinition);
            }
            taskDefinitionsByTaskName.put(taskName, taskDefinition);
        }
        return taskDefinitionsByTaskName;
    }

    private Set<String> getReducedTaskList(List<TaskDefinition> taskDefinitions) throws UnknownTaskException {
        ArrayList<String> tasks = new ArrayList<String>();
        for (TaskDefinition taskDef : taskDefinitions) {
            if (!this.isTaskEnabled(taskDef)) continue;
            String taskName = taskDef.getTaskName();
            tasks.add(taskName);
        }
        for (String task : this._onlyTasks) {
            if (tasks.contains(task)) continue;
            throw new UnknownTaskException(task);
        }
        for (String task : this._skipTasks) {
            if (tasks.contains(task)) continue;
            throw new UnknownTaskException(task);
        }
        if (this._skipToTask != null) {
            int index = tasks.indexOf(this._skipToTask);
            if (index == -1) {
                throw new UnknownTaskException(this._skipToTask);
            }
            for (int i = 0; i < index; ++i) {
                tasks.remove(0);
            }
        }
        if (!this._onlyTasks.isEmpty()) {
            tasks.retainAll(this._onlyTasks);
        }
        tasks.removeAll(this._skipTasks);
        return new HashSet<String>(tasks);
    }

    private boolean isTaskEnabled(TaskDefinition taskDef) {
        return this._onlyTasks.contains(taskDef.getTaskName()) || this._includeTasks.contains(taskDef.getTaskName()) || taskDef.isEnabled();
    }
}

