/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.bundle;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.time.DateUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.onebusaway.gtfs.impl.GtfsRelationalDaoImpl;
import org.onebusaway.transit_data_federation.bundle.FederatedTransitDataBundleCreator;
import org.onebusaway.transit_data_federation.bundle.UnknownTaskException;
import org.onebusaway.transit_data_federation.bundle.model.Bundle;
import org.onebusaway.transit_data_federation.bundle.model.BundleFile;
import org.onebusaway.transit_data_federation.bundle.model.BundleMetadata;
import org.onebusaway.transit_data_federation.bundle.model.GtfsBundle;
import org.onebusaway.transit_data_federation.bundle.model.GtfsBundles;
import org.onebusaway.transit_data_federation.bundle.model.SourceFile;
import org.onebusaway.transit_data_federation.bundle.utilities.BundleUtilties;
import org.onebusaway.transit_data_federation.bundle.utilities.JodaDateTimeAdapter;
import org.onebusaway.transit_data_federation.bundle.utilities.JodaLocalDateAdapter;
import org.onebusaway.transit_data_federation.bundle.utilities.NativeFileUtilities;
import org.onebusaway.util.git.GitRepositoryHelper;
import org.onebusaway.util.git.GitRepositoryState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;

public class FederatedTransitDataBundleConventionMain {
    private static Logger _log = LoggerFactory.getLogger(FederatedTransitDataBundleConventionMain.class);
    public static final String BUNDLE_METADATA_JSON = "BundleMetadata.json";
    public static final String METADATA_JSON = "metadata.json";
    public static final String INPUTS_DIR = "inputs";
    public static final String OUTPUT_DIR = "outputs";
    public static final String DATA_DIR = "data";
    private ObjectMapper mapper = new ObjectMapper();
    private Date toDate = null;
    private Date fromDate = null;

    public String run(String[] args) {
        File outputDir;
        long start = System.currentTimeMillis();
        this.logVersion();
        if (args == null || args.length != 3) {
            throw new IllegalStateException("Expecting input_directory_tree, output_directory, bundle_name");
        }
        Configurator.setRootLevel((Level)Level.INFO);
        String inputPathStr = "/tmp/input";
        Object outputPathStr = "/tmp/bundle";
        String bundleName = "not_specified";
        if (args != null) {
            if (args.length > 0) {
                inputPathStr = args[0];
            }
            if (args.length > 1) {
                outputPathStr = args[1] + File.separator;
            }
            if (args.length > 2) {
                bundleName = args[2];
                outputPathStr = (String)outputPathStr + bundleName;
            }
        }
        if ((outputDir = new File((String)outputPathStr)).exists()) {
            throw new IllegalStateException("Directory " + (String)outputPathStr + " already exists.  Please remove it.");
        }
        outputDir.mkdirs();
        BundleRequest request = this.createRequest(this.handleClassPath(inputPathStr), (String)outputPathStr, bundleName);
        FederatedTransitDataBundleCreator creator = this.setup(request);
        this.build(creator);
        String bundleFile = this.assemble(request, bundleName);
        System.out.println("bundle file stored at " + bundleFile + " in " + (System.currentTimeMillis() - start) / 1000L + "s");
        return bundleFile;
    }

    private String handleClassPath(String inputPathStr) {
        if (inputPathStr == null) {
            throw new NullPointerException("inputPathStr cannot be null");
        }
        if (inputPathStr.startsWith("classpath:")) {
            URL url = Thread.currentThread().getContextClassLoader().getResource(inputPathStr.replace("classpath:", ""));
            if (url == null) {
                throw new RuntimeException("path not found=" + inputPathStr);
            }
            try {
                return url.toURI().toString().replace("file:", "");
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("unexpected input path=" + inputPathStr);
            }
        }
        return inputPathStr;
    }

    private BundleRequest createRequest(String inputPathStr, String outputPathStr, String bundleName) {
        BundleRequest request = new BundleRequest(inputPathStr, outputPathStr);
        request.setDataset("dataset");
        request.setName(bundleName);
        return request;
    }

    private String assemble(BundleRequest request, String bundleName) {
        String indexFile;
        _log.info("creating metadata files...");
        this.generateJsonBundleMetadata(request);
        this.generateJsonMetadata(request);
        _log.info("created metadata files!");
        NativeFileUtilities fs = new NativeFileUtilities();
        String baseDir = request.getOutput().replace(File.separator + bundleName, "");
        String[] paths = new String[]{request.getName()};
        String filename = request.getOutput() + File.separator + request.getName() + ".tar.gz";
        fs.tarcvf(baseDir, paths, filename);
        String outputsPath = request.getBundleOutputDirectory();
        File outputsDestDir = new File(outputsPath);
        outputsDestDir.mkdir();
        File outputPath = new File(request.getBundleDataDirectory());
        String logFilename = outputPath + File.separator + "bundleBuilder.out.txt";
        fs.copyFiles(new File(logFilename), new File(request.getBundleOutputDirectory() + File.separator + "bundleBuilder.out.txt"));
        File outputsDir = new File(request.getBundleOutputDirectory());
        File[] outputFiles = outputsDir.listFiles();
        if (outputFiles != null) {
            for (File output : outputFiles) {
                fs.copyFiles(output, new File(outputsPath + File.separator + output.getName()));
            }
        }
        if ((indexFile = System.getProperty("indexFile")) != null) {
            try {
                _log.info("writing indexFile {}", (Object)indexFile);
                String indexText = "{\"latest\":\"file://" + filename + "\"}";
                FileWriter fw = new FileWriter(indexFile);
                fw.write(indexText);
                fw.close();
            }
            catch (Throwable t) {
                _log.error("unable to create index {}", (Object)indexFile, (Object)t);
            }
        } else {
            _log.info("indexFile not requested");
        }
        return filename;
    }

    private void build(FederatedTransitDataBundleCreator creator) {
        try {
            creator.run();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (UnknownTaskException e) {
            throw new RuntimeException(e);
        }
    }

    private FederatedTransitDataBundleCreator setup(BundleRequest request) {
        FederatedTransitDataBundleCreator creator = new FederatedTransitDataBundleCreator();
        HashMap<String, BeanDefinition> beans = new HashMap<String, BeanDefinition>();
        creator.setContextBeans(beans);
        NativeFileUtilities fs = new NativeFileUtilities();
        String inputsPath = request.getInput();
        File inputsDestDir = new File(request.getInputDirectory());
        inputsDestDir.mkdir();
        File inputsDir = new File(inputsPath);
        File[] inputFiles = inputsDir.listFiles();
        if (inputFiles != null) {
            for (File input : inputFiles) {
                System.out.println("copying " + input + " to " + inputsDestDir);
                fs.copyFiles(input, inputsDestDir);
            }
        }
        File dataDestDir = new File(request.getBundleDataDirectory());
        dataDestDir.mkdir();
        File outputDestDir = new File(request.getBundleOutputDirectory());
        outputDestDir.mkdir();
        ArrayList<GtfsBundle> gtfsBundles = new ArrayList<GtfsBundle>();
        String directoryName = request.getInput();
        List<String> directories = this.listFromPath(directoryName);
        if (directories == null || directories.isEmpty()) {
            throw new IllegalStateException("no gtfs found for path " + directoryName + " and source path" + inputsDir);
        }
        boolean found = false;
        for (String directory : directories) {
            for (String gtfsFile : this.listFiles(directoryName + File.separator + directory)) {
                String agencyName = this.parseAgency(gtfsFile);
                found = true;
                System.out.println("found gtfs at " + gtfsFile);
                GtfsBundle gtfsBundle = new GtfsBundle();
                gtfsBundle.setPath(new File(gtfsFile));
                _log.info("setting default agency id to {} for {} ", (Object)agencyName, (Object)(directoryName + File.separator + directory));
                gtfsBundle.setDefaultAgencyId(agencyName);
                gtfsBundles.add(gtfsBundle);
            }
        }
        if (!found) {
            throw new IllegalStateException("no gtfs found at " + directoryName);
        }
        BeanDefinitionBuilder bean = BeanDefinitionBuilder.genericBeanDefinition(GtfsBundles.class);
        bean.addPropertyValue("bundles", gtfsBundles);
        beans.put("gtfs-bundles", (BeanDefinition)bean.getBeanDefinition());
        creator.setOutputPath(dataDestDir);
        BeanDefinitionBuilder gtfsBean = BeanDefinitionBuilder.genericBeanDefinition(GtfsRelationalDaoImpl.class);
        beans.put("gtfsRelationalDaoImpl", (BeanDefinition)gtfsBean.getBeanDefinition());
        Properties propertyOverrides = new Properties();
        propertyOverrides.setProperty("bundle.path", request.getBundleDataDirectory());
        creator.setAdditionalBeanPropertyOverrides(propertyOverrides);
        return creator;
    }

    private void generateJsonMetadata(BundleRequest request) {
        try {
            BundleMetadata data = new BundleMetadata();
            String outputDirectory = request.getOutput();
            String sourceDirectory = request.getBundleOutputDirectory();
            data.setId(request.getName());
            data.setName(request.getName());
            data.setServiceDateFrom(this.createFromDate());
            data.setServiceDateTo(this.createToDate());
            data.setOutputFiles(this.getBundleFilesWithSumsForDirectory(new File(outputDirectory), new File(request.getBundleDataDirectory()), null));
            data.setSourceData(this.getSourceFilesWithSumsForDirectory(new File(outputDirectory), new File(request.getBundleOutputDirectory()), null));
            String outputFile = request.getBundleDataDirectory() + File.separator + METADATA_JSON;
            _log.info("writing metadata file {}", (Object)outputFile);
            this.mapper.writeValue(new File(outputFile), (Object)data);
            outputFile = sourceDirectory + File.separator + METADATA_JSON;
            this.mapper.writeValue(new File(outputFile), (Object)data);
        }
        catch (Exception any) {
            _log.error("exception serializing metadata.json: ", (Throwable)any);
        }
    }

    private List<SourceFile> getSourceFilesWithSumsForDirectory(File baseDir, File dir, File rootDir) {
        return new BundleUtilties().getSourceFilesWithSumsForDirectory(baseDir, dir, rootDir);
    }

    private List<BundleFile> getBundleFilesWithSumsForDirectory(File baseDir, File dir, File rootDir) {
        return new BundleUtilties().getBundleFilesWithSumsForDirectory(baseDir, dir, rootDir);
    }

    private Date createToDate() {
        if (this.toDate == null) {
            this.toDate = DateUtils.addDays((Date)new Date(), (int)30);
        }
        return this.toDate;
    }

    private Date createFromDate() {
        if (this.fromDate == null) {
            this.fromDate = new Date();
        }
        return this.fromDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateJsonBundleMetadata(BundleRequest request) {
        File bundleDir = new File(request.getInput());
        List<BundleFile> files = new BundleUtilties().getBundleFilesWithSumsForDirectory(bundleDir, bundleDir, bundleDir);
        Bundle bundle = new Bundle();
        bundle.setId(request.getName());
        bundle.setDataset(request.getDataset());
        bundle.setName(request.getName());
        bundle.setServiceDateFrom(this.createFromLocalDate());
        bundle.setServiceDateTo(this.createToLocalDate());
        DateTime now = new DateTime();
        ArrayList<String> applicableAgencyIds = new ArrayList<String>();
        bundle.setApplicableAgencyIds(applicableAgencyIds);
        bundle.setFiles(files);
        String output = this.getGson().toJson((Object)bundle);
        String outputFilename = request.getOutput() + File.separator + BUNDLE_METADATA_JSON;
        File outputFile = new File(outputFilename);
        _log.info("creating metadata file=" + outputFilename);
        try (PrintWriter writer = null;){
            writer = new PrintWriter(outputFile);
            writer.print(output);
        }
    }

    private Gson getGson() {
        return new GsonBuilder().serializeNulls().registerTypeAdapter(DateTime.class, (Object)new JodaDateTimeAdapter()).registerTypeAdapter(LocalDate.class, (Object)new JodaLocalDateAdapter()).setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_DASHES).setPrettyPrinting().create();
    }

    private LocalDate createToLocalDate() {
        return new LocalDate((Object)this.createToDate());
    }

    private LocalDate createFromLocalDate() {
        return new LocalDate((Object)this.createFromDate());
    }

    private List<String> listFiles(String directory) {
        File dir;
        File[] listFiles;
        ArrayList<String> list = new ArrayList<String>();
        if (directory == null) {
            System.out.println("illegal dir=" + directory);
        }
        if ((listFiles = (dir = new File(directory)).listFiles()) != null) {
            for (File file : listFiles) {
                List<String> recurse;
                if (file.isFile()) {
                    list.add(this.sanitize(file.toURI().toString()));
                    continue;
                }
                if (!file.isDirectory() || (recurse = this.listFiles(file.toString())) == null || recurse.isEmpty()) continue;
                list.addAll(recurse);
            }
        }
        return list;
    }

    private String sanitize(String s) {
        return s.replace("file:", "");
    }

    private String parseAgency(String directory) {
        String[] paths = directory.split("/");
        int lastIndex = paths.length - 2;
        return paths[lastIndex];
    }

    private List<String> listFromPath(String directoryName) {
        File dir = new File(directoryName);
        if (!dir.exists() || !dir.isDirectory()) {
            throw new RuntimeException("expecting directory at " + directoryName);
        }
        ArrayList<String> filenames = new ArrayList<String>();
        for (String s : dir.list()) {
            filenames.add(s);
        }
        return filenames;
    }

    private List<String> listFromClasspath(String directoryName) throws URISyntaxException {
        directoryName = directoryName.replace("classpath:", "");
        ArrayList<String> filenames = new ArrayList<String>();
        URL url = Thread.currentThread().getContextClassLoader().getResource(directoryName);
        if (url != null) {
            if (url.getProtocol().equals("file")) {
                File[] files;
                File file = Paths.get(url.toURI()).toFile();
                if (file != null && (files = file.listFiles()) != null) {
                    for (File filename : files) {
                        filenames.add(filename.toString());
                    }
                }
            } else {
                System.out.println("unexpected path " + url);
            }
        }
        return filenames;
    }

    private void logVersion() {
        GitRepositoryState gitRepositoryState = new GitRepositoryHelper().getGitRepositoryState();
        if (gitRepositoryState != null) {
            String msg = "onebusaway-application-modules launch with branch '" + gitRepositoryState.getBranch() + "' commit '" + gitRepositoryState.getCommitId() + "' version/commit message '" + gitRepositoryState.getCommitMessageShort() + "'";
            _log.info(msg);
            System.out.println(msg);
        } else {
            String msg = "onebusaway-application-modules launch running in development mode";
            _log.info("onebusaway-application-modules launch running in development mode");
            System.out.println("onebusaway-application-modules launch running in development mode");
        }
    }

    public static void main(String[] args) throws Exception {
        FederatedTransitDataBundleConventionMain main = new FederatedTransitDataBundleConventionMain();
        main.run(args);
    }

    private static class BundleRequest {
        private String input;
        private String output;
        private String dataset;
        private String name;

        public BundleRequest(String inputPathStr, String outputPathStr) {
            this.input = inputPathStr;
            this.output = outputPathStr;
        }

        public String getInput() {
            return this.input;
        }

        public String getOutput() {
            return this.output;
        }

        public String getDataset() {
            return this.dataset;
        }

        public void setDataset(String dataset) {
            this.dataset = dataset;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getTmpDirectory() {
            return System.getProperty("java.io.tmpdir");
        }

        public String getInputDirectory() {
            return this.output + File.separator + FederatedTransitDataBundleConventionMain.INPUTS_DIR;
        }

        public String getBundleDataDirectory() {
            return this.output + File.separator + FederatedTransitDataBundleConventionMain.DATA_DIR;
        }

        public String getBundleOutputDirectory() {
            return this.output + File.separator + FederatedTransitDataBundleConventionMain.OUTPUT_DIR;
        }
    }
}

