/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.siri.core.versioning;

import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.Map;
import org.onebusaway.collections.tuple.Pair;
import org.onebusaway.collections.tuple.Tuples;
import org.onebusaway.siri.core.exceptions.SiriUnknownVersionException;
import org.onebusaway.siri.core.versioning.ESiriVersion;
import org.onebusaway.siri.core.versioning.FixedValuePropertyConverter;
import org.onebusaway.siri.core.versioning.IntrospectionVersionConverter;
import org.onebusaway.siri.core.versioning.PackageBasedTypeMappingStrategy;
import org.onebusaway.siri.core.versioning.PropertyConverter;
import org.onebusaway.siri.core.versioning.PropertyConverterFactory;
import org.onebusaway.siri.core.versioning.VersionConverter;
import uk.org.siri.siri.Siri;
import uk.org.siri.siri.VehicleMonitoringDeliveryStructure;
import uk.org.siri.siri.VehicleMonitoringRequestStructure;

public class SiriVersioning {
    public static final String SIRI_1_3_PACKAGE = "uk.org.siri.siri";
    public static final String SIRI_1_0_PACKAGE = "uk.org.siri";
    private static SiriVersioning _instance = new SiriVersioning();
    private Map<Pair<ESiriVersion>, VersionConverter> _convertersByVersions = new HashMap<Pair<ESiriVersion>, VersionConverter>();

    public static SiriVersioning getInstance() {
        return _instance;
    }

    private SiriVersioning() {
        PackageBasedTypeMappingStrategy mappingV10ToV13 = new PackageBasedTypeMappingStrategy(SIRI_1_0_PACKAGE, SIRI_1_3_PACKAGE);
        IntrospectionVersionConverter converterV10ToV13 = new IntrospectionVersionConverter(mappingV10ToV13);
        VersionPropertyConverterFactory v13VersionFactory = new VersionPropertyConverterFactory("1.3");
        converterV10ToV13.addPropertyConverterFactory(uk.org.siri.Siri.class, "version", v13VersionFactory);
        converterV10ToV13.addPropertyConverterFactory(uk.org.siri.VehicleMonitoringDeliveryStructure.class, "version", v13VersionFactory);
        Pair pairV10ToV13 = Tuples.pair((Object)((Object)ESiriVersion.V1_0), (Object)((Object)ESiriVersion.V1_3));
        this._convertersByVersions.put((Pair<ESiriVersion>)pairV10ToV13, converterV10ToV13);
        PackageBasedTypeMappingStrategy mappingV13ToV10 = new PackageBasedTypeMappingStrategy(SIRI_1_3_PACKAGE, SIRI_1_0_PACKAGE);
        IntrospectionVersionConverter converterV13ToV10 = new IntrospectionVersionConverter(mappingV13ToV10);
        VersionPropertyConverterFactory v10VersionFactory = new VersionPropertyConverterFactory("1.0");
        converterV13ToV10.addPropertyConverterFactory(Siri.class, "version", v10VersionFactory);
        converterV13ToV10.addPropertyConverterFactory(VehicleMonitoringDeliveryStructure.class, "version", v10VersionFactory);
        converterV13ToV10.addPropertyConverterFactory(VehicleMonitoringRequestStructure.class, "version", v10VersionFactory);
        Pair pairV13ToV10 = Tuples.pair((Object)((Object)ESiriVersion.V1_3), (Object)((Object)ESiriVersion.V1_0));
        this._convertersByVersions.put((Pair<ESiriVersion>)pairV13ToV10, converterV13ToV10);
    }

    public ESiriVersion getDefaultVersion() {
        return ESiriVersion.V1_3;
    }

    public ESiriVersion getVersionOfObject(Object payload) {
        Class<?> type = payload.getClass();
        String typeName = type.getName();
        if (typeName.startsWith(SIRI_1_3_PACKAGE)) {
            return ESiriVersion.V1_3;
        }
        if (typeName.startsWith(SIRI_1_0_PACKAGE)) {
            return ESiriVersion.V1_0;
        }
        throw new SiriUnknownVersionException(typeName);
    }

    public Object getPayloadAsVersion(Object payload, ESiriVersion targetVersion) {
        if (payload == null || targetVersion == null) {
            return payload;
        }
        ESiriVersion sourceVersion = this.getVersionOfObject(payload);
        if (sourceVersion != targetVersion) {
            VersionConverter converter = this.getVersionConverter(sourceVersion, targetVersion);
            payload = converter.convert(payload);
        }
        return payload;
    }

    private VersionConverter getVersionConverter(ESiriVersion versionFrom, ESiriVersion versionTo) {
        Pair pair = Tuples.pair((Object)((Object)versionFrom), (Object)((Object)versionTo));
        return this._convertersByVersions.get(pair);
    }

    private static class VersionPropertyConverterFactory
    implements PropertyConverterFactory {
        private String _version;

        public VersionPropertyConverterFactory(String version) {
            this._version = version;
        }

        @Override
        public PropertyConverter createConverter(VersionConverter versionConverter, Class<?> sourceType, Class<?> targetType, String fromName, PropertyDescriptor fromDesc, PropertyDescriptor toDesc) {
            return new FixedValuePropertyConverter(toDesc.getWriteMethod(), this._version);
        }
    }
}

