/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.siri.core.versioning;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.onebusaway.siri.core.versioning.PropertyConverter;
import org.onebusaway.siri.core.versioning.PropertyConverterSupport;
import org.onebusaway.siri.core.versioning.VersionConverter;

public class MethodPropertyConverter
implements PropertyConverter {
    private final VersionConverter _converter;
    private final Method _from;
    private final Method _to;

    public MethodPropertyConverter(VersionConverter converter, Method from, Method to) {
        this._converter = converter;
        this._from = from;
        this._to = to;
    }

    @Override
    public void convert(Object source, Object target) {
        Object sourceProperty = PropertyConverterSupport.getSourcePropertyValue(source, this._from);
        if (sourceProperty == null) {
            return;
        }
        if (sourceProperty instanceof List) {
            List sourceList = (List)sourceProperty;
            ArrayList<Object> targetList = new ArrayList<Object>(sourceList.size());
            for (Object sourceValue : sourceList) {
                Object targetProperty = this._converter.convert(sourceValue);
                targetList.add(targetProperty);
                PropertyConverterSupport.setTargetPropertyValue(target, this._to, targetList);
            }
        } else {
            Object targetProperty = this._converter.convert(sourceProperty);
            PropertyConverterSupport.setTargetPropertyValue(target, this._to, targetProperty);
        }
    }
}

