/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.siri.core.versioning;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.onebusaway.siri.core.versioning.PropertyConverter;
import org.onebusaway.siri.core.versioning.PropertyConverterSupport;
import org.onebusaway.siri.core.versioning.VersionConverter;

public class ListPropertyConverter
implements PropertyConverter {
    private final VersionConverter _converter;
    private final Method _from;
    private final Method _to;

    public ListPropertyConverter(VersionConverter converter, Method from, Method to) {
        this._converter = converter;
        this._from = from;
        this._to = to;
    }

    @Override
    public void convert(Object source, Object target) {
        Object sourceProperty = PropertyConverterSupport.getSourcePropertyValue(source, this._from);
        if (sourceProperty == null) {
            return;
        }
        List sourceList = (List)sourceProperty;
        if (sourceList.isEmpty()) {
            return;
        }
        ArrayList<Object> targetList = new ArrayList<Object>(sourceList.size());
        for (Object sourceValue : sourceList) {
            Object targetProperty = this._converter.convert(sourceValue);
            targetList.add(targetProperty);
        }
        PropertyConverterSupport.setTargetPropertyValues(target, this._to, targetList);
    }
}

