/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.siri.core.versioning;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.onebusaway.collections.MappingLibrary;
import org.onebusaway.siri.core.versioning.ElementToListPropertyConverter;
import org.onebusaway.siri.core.versioning.ListPropertyConverter;
import org.onebusaway.siri.core.versioning.MethodPropertyConverter;
import org.onebusaway.siri.core.versioning.PropertyConverter;
import org.onebusaway.siri.core.versioning.PropertyConverterFactory;
import org.onebusaway.siri.core.versioning.TypeMappingStrategy;
import org.onebusaway.siri.core.versioning.VersionConverter;
import org.onebusaway.siri.core.versioning.VersionConverterImpl;

public class IntrospectionVersionConverter
implements VersionConverter {
    private static VersionConverter _passThroughConverter = new PassThroughConverter();
    private ConcurrentMap<Class<?>, VersionConverter> _convertersBySourceType = new ConcurrentHashMap();
    private final TypeMappingStrategy _typeMappingStrategy;
    private final Set<TypeAndPropertyName> _propertiesToIgnore = new HashSet<TypeAndPropertyName>();
    private final Map<TypeAndPropertyName, PropertyConverterFactory> _propertyConverterFactories = new HashMap<TypeAndPropertyName, PropertyConverterFactory>();

    public IntrospectionVersionConverter(TypeMappingStrategy typeMappingStrategy) {
        this._typeMappingStrategy = typeMappingStrategy;
    }

    public void addPropertyToIgnore(Class<?> fromType, String propertyName) {
        this._propertiesToIgnore.add(new TypeAndPropertyName(fromType, propertyName));
    }

    public void addPropertyConverterFactory(Class<?> fromType, String propertyName, PropertyConverterFactory factory) {
        this._propertyConverterFactories.put(new TypeAndPropertyName(fromType, propertyName), factory);
    }

    @Override
    public Object convert(Object source) {
        Class<?> sourceType = source.getClass();
        VersionConverter converter = this.getConverterForSourceType(sourceType);
        if (converter == null) {
            throw new IllegalStateException("version converter not found for source type " + sourceType.getName());
        }
        return converter.convert(source);
    }

    private VersionConverter getConverterForSourceType(Class<?> sourceType) {
        VersionConverter newConverter;
        VersionConverter converter = (VersionConverter)this._convertersBySourceType.get(sourceType);
        if (converter == null && (converter = this._convertersBySourceType.putIfAbsent(sourceType, newConverter = this.createConverter(sourceType))) == null) {
            converter = newConverter;
        }
        return converter;
    }

    private VersionConverter createConverter(Class<?> sourceType) {
        if (this.isPrimitiveType(sourceType)) {
            return _passThroughConverter;
        }
        Class<?> targetType = this.determineTargetTypeForSourceType(sourceType);
        List<PropertyConverter> converters = this.getPropertyConvertersForTypes(sourceType, targetType);
        return new VersionConverterImpl(targetType, converters);
    }

    private boolean isPrimitiveType(Class<? extends Object> sourceType) {
        String name = sourceType.getName();
        return sourceType.isPrimitive() || sourceType.isEnum() || name.startsWith("java") || name.startsWith("com.sun");
    }

    private Class<?> determineTargetTypeForSourceType(Class<?> sourceType) {
        Class<?> targetType = this._typeMappingStrategy.getTargetTypeForSourceType(sourceType);
        if (targetType == null) {
            throw new IllegalStateException("could not find type mapping for " + sourceType.getName());
        }
        return targetType;
    }

    private List<PropertyConverter> getPropertyConvertersForTypes(Class<?> sourceType, Class<?> targetType) {
        BeanInfo fromInfo = null;
        BeanInfo toInfo = null;
        try {
            fromInfo = Introspector.getBeanInfo(sourceType);
            toInfo = Introspector.getBeanInfo(targetType);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
        Map<String, PropertyDescriptor> fromDescs = this.getDescriptorsByName(fromInfo);
        Map<String, PropertyDescriptor> toDescs = this.getDescriptorsByName(toInfo);
        ArrayList<PropertyConverter> converters = new ArrayList<PropertyConverter>();
        for (String name : fromDescs.keySet()) {
            PropertyConverter converter;
            TypeAndPropertyName fromPropertyKey;
            if (!toDescs.containsKey(name) || "class".equals(name) || "declaringClass".equals(name) || this._propertiesToIgnore.contains(fromPropertyKey = new TypeAndPropertyName(sourceType, name))) continue;
            PropertyDescriptor fromDesc = fromDescs.get(name);
            PropertyDescriptor toDesc = toDescs.get(name);
            PropertyConverterFactory factory = this._propertyConverterFactories.get(fromPropertyKey);
            if (factory != null) {
                converter = factory.createConverter(this, sourceType, targetType, name, fromDesc, toDesc);
                if (converter == null) continue;
                converters.add(converter);
                continue;
            }
            converter = this.getPropertyConverter(sourceType, targetType, name, fromDesc, toDesc);
            if (converter == null) continue;
            converters.add(converter);
        }
        return converters;
    }

    private Map<String, PropertyDescriptor> getDescriptorsByName(BeanInfo fromInfo) {
        PropertyDescriptor[] descs = fromInfo.getPropertyDescriptors();
        return MappingLibrary.mapToValue(Arrays.asList(descs), (String)"name");
    }

    private PropertyConverter getPropertyConverter(Class<?> sourceType, Class<?> targetType, String name, PropertyDescriptor fromDesc, PropertyDescriptor toDesc) {
        try {
            Method readMethod = fromDesc.getReadMethod();
            Method writeMethod = toDesc.getWriteMethod();
            Class<?> fromPropertyType = fromDesc.getPropertyType();
            Class<?> toPropertyType = toDesc.getPropertyType();
            if (readMethod == null && fromPropertyType == Boolean.class) {
                String getter = "is" + name.substring(0, 1).toUpperCase() + name.substring(1);
                readMethod = sourceType.getMethod(getter, new Class[0]);
            }
            if (writeMethod == null && toPropertyType == List.class) {
                if (fromPropertyType == List.class) {
                    return new ListPropertyConverter(this, readMethod, toDesc.getReadMethod());
                }
                return new ElementToListPropertyConverter(this, readMethod, toDesc.getReadMethod());
            }
            if (writeMethod == null && toPropertyType == Boolean.TYPE) {
                String setter = "set" + name.substring(0, 1).toUpperCase() + name.substring(1);
                writeMethod = sourceType.getMethod(setter, Boolean.class);
            }
            if (readMethod == null) {
                throw new IllegalStateException("no read method for property \"" + name + "\" of source type " + sourceType.getName());
            }
            if (writeMethod == null) {
                throw new IllegalStateException("no write method for property \"" + name + "\" of target type " + targetType.getName());
            }
            return new MethodPropertyConverter(this, readMethod, writeMethod);
        }
        catch (Throwable ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static class TypeAndPropertyName {
        private final Class<?> type;
        private final String propertyName;

        public TypeAndPropertyName(Class<?> type, String propertyName) {
            if (type == null) {
                throw new IllegalArgumentException();
            }
            if (propertyName == null) {
                throw new IllegalArgumentException();
            }
            this.type = type;
            this.propertyName = propertyName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.propertyName.hashCode();
            result = 31 * result + this.type.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TypeAndPropertyName other = (TypeAndPropertyName)obj;
            if (!this.propertyName.equals(other.propertyName)) {
                return false;
            }
            return this.type.equals(other.type);
        }
    }

    private static class PassThroughConverter
    implements VersionConverter {
        private PassThroughConverter() {
        }

        @Override
        public Object convert(Object source) {
            return source;
        }
    }
}

