/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.siri.core.versioning;

import java.util.HashMap;
import java.util.Map;

public enum ESiriVersion {
    V1_0("1.0"),
    V1_3("1.3");

    private final String _versionId;
    private static Map<String, ESiriVersion> _versionsByVersionId;

    private ESiriVersion(String versionId) {
        this._versionId = versionId;
    }

    public String getVersionId() {
        return this._versionId;
    }

    public static ESiriVersion getVersionForVersionId(String versionId) {
        return _versionsByVersionId.get(versionId);
    }

    static {
        _versionsByVersionId = new HashMap<String, ESiriVersion>();
        for (ESiriVersion version : ESiriVersion.values()) {
            _versionsByVersionId.put(version.getVersionId(), version);
        }
    }
}

