/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.siri.core.subscriptions.server;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.xml.datatype.Duration;
import org.onebusaway.collections.tuple.T2;
import org.onebusaway.collections.tuple.Tuples;
import org.onebusaway.siri.core.ESiriModuleType;
import org.onebusaway.siri.core.SiriClientRequest;
import org.onebusaway.siri.core.SiriLibrary;
import org.onebusaway.siri.core.SiriServer;
import org.onebusaway.siri.core.SiriTypeFactory;
import org.onebusaway.siri.core.exceptions.SiriConnectionException;
import org.onebusaway.siri.core.exceptions.SiriMissingArgumentException;
import org.onebusaway.siri.core.filters.ModuleDeliveryFilterFactory;
import org.onebusaway.siri.core.filters.SiriModuleDeliveryFilter;
import org.onebusaway.siri.core.filters.SiriModuleDeliveryFilterMatcher;
import org.onebusaway.siri.core.handlers.SiriClientHandler;
import org.onebusaway.siri.core.handlers.SiriSubscriptionManagerListener;
import org.onebusaway.siri.core.services.SchedulingService;
import org.onebusaway.siri.core.services.StatusProviderService;
import org.onebusaway.siri.core.subscriptions.SubscriptionId;
import org.onebusaway.siri.core.subscriptions.server.ServerSubscriptionChannel;
import org.onebusaway.siri.core.subscriptions.server.ServerSubscriptionInstance;
import org.onebusaway.siri.core.subscriptions.server.ServerSupport;
import org.onebusaway.siri.core.subscriptions.server.SiriServerSubscriptionEvent;
import org.onebusaway.siri.core.versioning.ESiriVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.siri.siri.AbstractServiceDeliveryStructure;
import uk.org.siri.siri.AbstractSubscriptionStructure;
import uk.org.siri.siri.HeartbeatNotificationStructure;
import uk.org.siri.siri.MessageQualifierStructure;
import uk.org.siri.siri.ParticipantRefStructure;
import uk.org.siri.siri.ServiceDelivery;
import uk.org.siri.siri.Siri;
import uk.org.siri.siri.StatusResponseStructure;
import uk.org.siri.siri.SubscriptionContextStructure;
import uk.org.siri.siri.SubscriptionQualifierStructure;
import uk.org.siri.siri.SubscriptionRequest;
import uk.org.siri.siri.TerminateSubscriptionRequestStructure;
import uk.org.siri.siri.TerminateSubscriptionResponseStructure;

@Singleton
public class SiriServerSubscriptionManager
implements StatusProviderService {
    private static Logger _log = LoggerFactory.getLogger(SiriServerSubscriptionManager.class);
    private SchedulingService _schedulingService;
    private ServerSupport _support = new ServerSupport();
    private SiriClientHandler _client;
    private SiriServer _server;
    private Map<SubscriptionId, ServerSubscriptionInstance> _activeSubscriptionsById = new HashMap<SubscriptionId, ServerSubscriptionInstance>();
    private Map<String, Set<SubscriptionId>> _activeSubscriptionsBySubscriberId = new HashMap<String, Set<SubscriptionId>>();
    private ConcurrentMap<String, ServerSubscriptionChannel> _channelsByAddress = new ConcurrentHashMap<String, ServerSubscriptionChannel>();
    private Map<ESiriModuleType, ConcurrentMap<SubscriptionId, ServerSubscriptionInstance>> _subscriptionsByModuleType = new HashMap<ESiriModuleType, ConcurrentMap<SubscriptionId, ServerSubscriptionInstance>>();
    private ModuleDeliveryFilterFactory _deliveryFilterFactory = new ModuleDeliveryFilterFactory();
    private List<T2<SiriModuleDeliveryFilterMatcher, SiriModuleDeliveryFilter>> _filters = new ArrayList<T2<SiriModuleDeliveryFilterMatcher, SiriModuleDeliveryFilter>>();
    private List<SiriSubscriptionManagerListener> _listeners = new ArrayList<SiriSubscriptionManagerListener>();
    private Map<String, String> _consumerAddressDefaultsByRequestorRef = new HashMap<String, String>();
    private String _consumerAddressDefault = null;

    public SiriServerSubscriptionManager() {
        for (ESiriModuleType moduleType : ESiriModuleType.values()) {
            ConcurrentHashMap m = new ConcurrentHashMap();
            this._subscriptionsByModuleType.put(moduleType, m);
        }
    }

    @Inject
    public void setSchedulingService(SchedulingService schedulingService) {
        this._schedulingService = schedulingService;
    }

    public void addListener(SiriSubscriptionManagerListener listener) {
        this._listeners.add(listener);
    }

    public void removeListener(SiriSubscriptionManagerListener listener) {
        this._listeners.remove(listener);
    }

    public void setConsumerAddressDefaultForRequestorRef(String requestorRef, String consumerAddressDefault) {
        this._consumerAddressDefaultsByRequestorRef.put(requestorRef, consumerAddressDefault);
    }

    public void setConsumerAddressDefault(String consumerAddressDefault) {
        this._consumerAddressDefault = consumerAddressDefault;
    }

    public void addModuleDeliveryFilter(SiriModuleDeliveryFilterMatcher matcher, SiriModuleDeliveryFilter filter) {
        T2 tuple = Tuples.tuple((Object)matcher, (Object)filter);
        this._filters.add((T2<SiriModuleDeliveryFilterMatcher, SiriModuleDeliveryFilter>)tuple);
    }

    public void setServer(SiriServer server) {
        this._server = server;
    }

    @PreDestroy
    public void stop() {
        this._activeSubscriptionsById.clear();
        this._activeSubscriptionsBySubscriberId.clear();
        this._channelsByAddress.clear();
        for (ConcurrentMap<SubscriptionId, ServerSubscriptionInstance> m : this._subscriptionsByModuleType.values()) {
            m.clear();
        }
    }

    public List<String> getActiveSubscriptionChannels() {
        return new ArrayList<String>(this._channelsByAddress.keySet());
    }

    public synchronized void handleSubscriptionRequest(SubscriptionRequest subscriptionRequest, ESiriVersion originalVersion, List<StatusResponseStructure> statuses) throws SiriMissingArgumentException {
        for (ESiriModuleType moduleType : ESiriModuleType.values()) {
            List<AbstractSubscriptionStructure> subscriptionRequests = SiriLibrary.getSubscriptionRequestsForModule(subscriptionRequest, moduleType);
            for (AbstractSubscriptionStructure moduleRequest : subscriptionRequests) {
                this.handleSubscriptionRequests(subscriptionRequest, moduleType, moduleRequest, statuses, originalVersion);
            }
        }
    }

    public synchronized void terminateSubscriptionChannelWithAddress(String address) {
        ServerSubscriptionChannel existing = (ServerSubscriptionChannel)this._channelsByAddress.remove(address);
        if (existing != null) {
            ArrayList<SubscriptionId> ids = new ArrayList<SubscriptionId>(existing.getSubscriptions());
            for (SubscriptionId id : ids) {
                this.terminateSubscriptionWithId(id);
            }
            for (SiriSubscriptionManagerListener listener : this._listeners) {
                listener.subscriptionRemoved(this);
            }
        }
    }

    public synchronized void terminateSubscriptionsForRequest(TerminateSubscriptionRequestStructure request, List<TerminateSubscriptionResponseStructure.TerminationResponseStatus> statuses) {
        String subscriberId = this._support.getSubscriberIdForTerminateSubscriptionRequest(request);
        ParticipantRefStructure subscriberRef = SiriTypeFactory.particpantRef(subscriberId);
        if (subscriberId == null) {
            this._support.addTerminateSubscriptionStatusForMissingSubscriberRef(request, statuses);
            return;
        }
        HashSet<SubscriptionId> idsToTerminate = new HashSet<SubscriptionId>();
        if (request.getAll() != null) {
            Set<SubscriptionId> ids = this._activeSubscriptionsBySubscriberId.get(subscriberId);
            if (ids != null) {
                idsToTerminate.addAll(ids);
            }
        } else {
            List refs = request.getSubscriptionRef();
            for (SubscriptionQualifierStructure ref : refs) {
                if (ref == null || ref.getValue() == null) continue;
                idsToTerminate.add(new SubscriptionId(subscriberId, ref.getValue()));
            }
        }
        Date timestamp = new Date();
        for (SubscriptionId id : idsToTerminate) {
            TerminateSubscriptionResponseStructure.TerminationResponseStatus status = new TerminateSubscriptionResponseStructure.TerminationResponseStatus();
            status.setResponseTimestamp(timestamp);
            status.setStatus(Boolean.TRUE.booleanValue());
            status.setSubscriberRef(subscriberRef);
            status.setSubscriptionRef(SiriTypeFactory.subscriptionId(id.getSubscriptionId()));
            try {
                if (this._activeSubscriptionsById.containsKey(id)) {
                    this.terminateSubscriptionWithId(id);
                } else {
                    this._support.setTerminationResponseErrorConditionWithUnknownSubscription(status);
                }
            }
            catch (Throwable ex) {
                this._support.setTerminationResponseErrorConditionWithException(status, ex);
            }
            statuses.add(status);
        }
    }

    public synchronized void terminateSubscriptionWithId(SubscriptionId id) {
        ServerSubscriptionInstance instance = this._activeSubscriptionsById.remove(id);
        if (instance == null) {
            return;
        }
        String subscriberId = id.getSubscriberId();
        Set<SubscriptionId> ids = this._activeSubscriptionsBySubscriberId.get(subscriberId);
        if (ids != null) {
            ids.remove(id);
            if (ids.isEmpty()) {
                this._activeSubscriptionsBySubscriberId.remove(subscriberId);
            }
        }
        ConcurrentMap<SubscriptionId, ServerSubscriptionInstance> subscriptionsForModule = this._subscriptionsByModuleType.get((Object)instance.getModuleType());
        subscriptionsForModule.remove(id);
        ServerSubscriptionChannel channel = instance.getChannel();
        Set<SubscriptionId> subscriptions = channel.getSubscriptions();
        subscriptions.remove(id);
        if (subscriptions.isEmpty()) {
            this._channelsByAddress.remove(channel.getAddress());
            this.clearHeartbeatTask(channel);
        }
        for (SiriSubscriptionManagerListener listener : this._listeners) {
            listener.subscriptionRemoved(this);
        }
    }

    public List<SiriServerSubscriptionEvent> publish(ServiceDelivery delivery) {
        ArrayList<SiriServerSubscriptionEvent> events = new ArrayList<SiriServerSubscriptionEvent>();
        for (ESiriModuleType moduleType : ESiriModuleType.values()) {
            this.handlePublication(moduleType, delivery, events);
        }
        return events;
    }

    public void recordPublicationStatistics(SiriServerSubscriptionEvent event, long timeNeededToPublish, boolean connectionError) {
        ServerSubscriptionChannel channel = (ServerSubscriptionChannel)this._channelsByAddress.get(event.getAddress());
        if (channel == null) {
            return;
        }
        channel.updatePublicationStatistics(event, timeNeededToPublish, connectionError);
    }

    private String getConsumerAddressForSubscriptionRequest(SubscriptionRequest subscriptionRequest, String subscriberId) {
        String consumerAddress = subscriptionRequest.getAddress();
        if (subscriptionRequest.getConsumerAddress() != null) {
            consumerAddress = subscriptionRequest.getConsumerAddress();
        }
        if (consumerAddress == null) {
            consumerAddress = this._consumerAddressDefaultsByRequestorRef.get(subscriberId);
        }
        if (consumerAddress == null) {
            consumerAddress = this._consumerAddressDefault;
        }
        return consumerAddress;
    }

    private ServerSubscriptionChannel getChannelForAddress(String address, ESiriVersion channelVersion) {
        ServerSubscriptionChannel newChannel;
        ServerSubscriptionChannel channel = (ServerSubscriptionChannel)this._channelsByAddress.get(address);
        if (channel == null && (channel = this._channelsByAddress.putIfAbsent(address, newChannel = new ServerSubscriptionChannel(address, channelVersion))) == null) {
            channel = newChannel;
            for (SiriSubscriptionManagerListener listener : this._listeners) {
                listener.subscriptionAdded(this);
            }
        }
        return channel;
    }

    private <T extends AbstractSubscriptionStructure> void handleSubscriptionRequests(SubscriptionRequest subscriptionRequest, ESiriModuleType moduleType, AbstractSubscriptionStructure moduleRequest, List<StatusResponseStructure> statuses, ESiriVersion originalVersion) {
        String subscriberId;
        String messageId = null;
        if (subscriptionRequest.getMessageIdentifier() != null) {
            messageId = subscriptionRequest.getMessageIdentifier().getValue();
        }
        if ((subscriberId = this._support.getSubscriberIdForSubscriptionRequest(subscriptionRequest, moduleRequest)) == null) {
            StatusResponseStructure status = this._support.getStatusResponseWithErrorMessage(subscriptionRequest, "The specified subscription request is missing a RequestorRef and SubscriberRef", null);
            statuses.add(status);
            return;
        }
        String consumerAddress = this.getConsumerAddressForSubscriptionRequest(subscriptionRequest, subscriberId);
        if (consumerAddress == null) {
            StatusResponseStructure status = this._support.getStatusResponseWithErrorMessage(subscriptionRequest, "The specified subscription request is missing a subscription Address", null);
            statuses.add(status);
            return;
        }
        ServerSubscriptionChannel channel = this.getChannelForAddress(consumerAddress, originalVersion);
        SubscriptionQualifierStructure subscriptionRef = moduleRequest.getSubscriptionIdentifier();
        if (subscriptionRef == null || subscriptionRef.getValue() == null) {
            StatusResponseStructure status = this._support.getStatusResponseWithErrorMessage(subscriptionRequest, "The specified subscription request is missing a SubscriptionIdentifier", null);
            statuses.add(status);
            return;
        }
        String subscriptionId = subscriptionRef.getValue();
        SubscriptionId id = new SubscriptionId(subscriberId, subscriptionId);
        _log.info("subscription request: subscriberId=" + subscriberId + " subscriptionId=" + subscriptionId + " address=" + consumerAddress);
        ServerSubscriptionInstance existing = this._activeSubscriptionsById.get(id);
        if (existing != null) {
            ServerSubscriptionChannel existingChannel = existing.getChannel();
            if (existingChannel != channel) {
                StatusResponseStructure status = this._support.getStatusResponseWithErrorMessage(subscriptionRequest, "A subscription already existed with the specified subscriber/subscription id on another channel", id);
                statuses.add(status);
                return;
            }
            _log.warn("overwriting existing subscription: id={} address={}", (Object)id, (Object)consumerAddress);
        }
        List<SiriModuleDeliveryFilter> filters = this.computeFilterSetForSubscriptionRequest(subscriptionRequest, moduleType, moduleRequest);
        ServerSubscriptionInstance instance = new ServerSubscriptionInstance(id, channel, moduleType, messageId, moduleRequest, filters);
        this._activeSubscriptionsById.put(id, instance);
        Set<SubscriptionId> channelSubscriptions = channel.getSubscriptions();
        channelSubscriptions.add(id);
        Set<SubscriptionId> ids = this._activeSubscriptionsBySubscriberId.get(id.getSubscriberId());
        if (ids == null) {
            ids = new HashSet<SubscriptionId>();
            this._activeSubscriptionsBySubscriberId.put(id.getSubscriberId(), ids);
        }
        ids.add(id);
        ConcurrentMap<SubscriptionId, ServerSubscriptionInstance> subscriptionsForModule = this._subscriptionsByModuleType.get((Object)moduleType);
        subscriptionsForModule.put(id, instance);
        this.updateChannel(subscriptionRequest, channel);
        StatusResponseStructure status = this._support.getStatusResponse(subscriptionRequest, id);
        statuses.add(status);
    }

    private List<SiriModuleDeliveryFilter> computeFilterSetForSubscriptionRequest(SubscriptionRequest subscriptionRequest, ESiriModuleType moduleType, AbstractSubscriptionStructure moduleSubscriptionRequest) {
        ArrayList<SiriModuleDeliveryFilter> filters = new ArrayList<SiriModuleDeliveryFilter>();
        for (T2<SiriModuleDeliveryFilterMatcher, SiriModuleDeliveryFilter> tuple : this._filters) {
            SiriModuleDeliveryFilterMatcher matcher = (SiriModuleDeliveryFilterMatcher)tuple.getFirst();
            if (!matcher.isMatch(subscriptionRequest, moduleType, moduleSubscriptionRequest)) continue;
            filters.add((SiriModuleDeliveryFilter)tuple.getSecond());
        }
        SiriModuleDeliveryFilter filter = this._deliveryFilterFactory.createFilter(moduleType, moduleSubscriptionRequest);
        filters.add(filter);
        return filters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateChannel(SubscriptionRequest subscriptionRequest, ServerSubscriptionChannel channel) {
        ServerSubscriptionChannel serverSubscriptionChannel = channel;
        synchronized (serverSubscriptionChannel) {
            SubscriptionContextStructure context = subscriptionRequest.getSubscriptionContext();
            if (context == null) {
                return;
            }
            long heartbeatInterval = 0L;
            Duration interval = context.getHeartbeatInterval();
            if (interval != null) {
                heartbeatInterval = interval.getTimeInMillis(new Date());
            }
            if (channel.getHeartbeatInterval() != heartbeatInterval) {
                channel.setHeartbeatInterval(heartbeatInterval);
                ScheduledFuture<Object> task = channel.getHeartbeatTask();
                if (task != null) {
                    task.cancel(true);
                    channel.setHeartbeatTask(null);
                }
                if (heartbeatInterval > 0L) {
                    HeartbeatTask heartbeatTask = new HeartbeatTask(channel);
                    task = this._schedulingService.scheduleAtFixedRate(heartbeatTask, heartbeatInterval, heartbeatInterval, TimeUnit.MILLISECONDS);
                    channel.setHeartbeatTask(task);
                }
            }
        }
    }

    private <T extends AbstractServiceDeliveryStructure> void handlePublication(ESiriModuleType moduleType, ServiceDelivery delivery, List<SiriServerSubscriptionEvent> events) {
        List deliveries = SiriLibrary.getServiceDeliveriesForModule(delivery, moduleType);
        ConcurrentMap<SubscriptionId, ServerSubscriptionInstance> subscriptionsById = this._subscriptionsByModuleType.get((Object)moduleType);
        for (ServerSubscriptionInstance instance : subscriptionsById.values()) {
            ServiceDelivery updatedDelivery = this.copyDeliveryShallow(delivery);
            List applicableResponses = this.getApplicableResponses(updatedDelivery, moduleType, instance, deliveries);
            if (applicableResponses == null || applicableResponses.isEmpty()) continue;
            List specifiedDeliveries = SiriLibrary.getServiceDeliveriesForModule(updatedDelivery, moduleType);
            SiriLibrary.copyList(applicableResponses, specifiedDeliveries);
            SubscriptionId id = instance.getId();
            ServerSubscriptionChannel channel = instance.getChannel();
            String address = channel.getAddress();
            ESiriVersion targetVersion = channel.getTargetVersion();
            SiriServerSubscriptionEvent event = new SiriServerSubscriptionEvent(id, address, targetVersion, updatedDelivery);
            events.add(event);
        }
    }

    private <T extends AbstractServiceDeliveryStructure> List<T> getApplicableResponses(ServiceDelivery delivery, ESiriModuleType type, ServerSubscriptionInstance instance, List<T> responses) {
        SubscriptionId id = instance.getId();
        AbstractSubscriptionStructure moduleSub = instance.getModuleSubscription();
        List<SiriModuleDeliveryFilter> filters = instance.getFilters();
        ArrayList<AbstractServiceDeliveryStructure> applicable = new ArrayList<AbstractServiceDeliveryStructure>();
        for (AbstractServiceDeliveryStructure element : responses) {
            SiriModuleDeliveryFilter filter;
            element = SiriLibrary.deepCopyModuleDelivery(type, element);
            ParticipantRefStructure subscriberRef = SiriTypeFactory.particpantRef(id.getSubscriberId());
            element.setSubscriberRef(subscriberRef);
            SubscriptionQualifierStructure subcriptionRef = SiriTypeFactory.subscriptionId(id.getSubscriptionId());
            element.setSubscriptionRef(subcriptionRef);
            element.setValidUntil(moduleSub.getInitialTerminationTime());
            if (element.getResponseTimestamp() == null) {
                element.setResponseTimestamp(new Date());
            }
            if (instance.getMessageId() != null) {
                MessageQualifierStructure messageId = SiriTypeFactory.messageId(instance.getMessageId());
                element.setRequestMessageRef(messageId);
            }
            Iterator<SiriModuleDeliveryFilter> i$ = filters.iterator();
            while (i$.hasNext() && (element = (filter = i$.next()).filter(delivery, element)) != null) {
            }
            if (element == null) continue;
            applicable.add(element);
        }
        return applicable;
    }

    private ServiceDelivery copyDeliveryShallow(ServiceDelivery delivery) {
        ServiceDelivery d = new ServiceDelivery();
        d.setAddress(delivery.getAddress());
        d.setErrorCondition(delivery.getErrorCondition());
        d.setMoreData(delivery.isMoreData());
        d.setProducerRef(delivery.getProducerRef());
        d.setRequestMessageRef(delivery.getRequestMessageRef());
        d.setResponseMessageIdentifier(delivery.getResponseMessageIdentifier());
        d.setResponseTimestamp(delivery.getResponseTimestamp());
        d.setSrsName(delivery.getSrsName());
        d.setStatus(delivery.isStatus());
        for (ESiriModuleType moduleType : ESiriModuleType.values()) {
            List from = SiriLibrary.getServiceDeliveriesForModule(delivery, moduleType);
            if (from.isEmpty()) continue;
            List to = SiriLibrary.getServiceDeliveriesForModule(d, moduleType);
            SiriLibrary.copyList(from, to);
        }
        return d;
    }

    private void clearHeartbeatTask(ServerSubscriptionChannel channel) {
        ScheduledFuture<?> heartbeatTask = channel.getHeartbeatTask();
        if (heartbeatTask != null) {
            heartbeatTask.cancel(true);
            channel.setHeartbeatTask(null);
        }
    }

    @Override
    public synchronized void getStatus(Map<String, String> status) {
        status.put("siri.server.activeChannels", Integer.toString(this._channelsByAddress.size()));
        status.put("siri.server.activeSubscriptions", Integer.toString(this._activeSubscriptionsById.size()));
        for (ServerSubscriptionInstance instance : this._activeSubscriptionsById.values()) {
            SubscriptionId id = instance.getId();
            String prefix = "siri.server.activeSubscription[" + id.getSubscriptionId() + "," + id.getSubscriptionId() + "]";
            status.put(prefix + ".address", instance.getChannel().getAddress());
            status.put(prefix + ".module_type", instance.getModuleType().toString());
        }
        for (ServerSubscriptionChannel channel : this._channelsByAddress.values()) {
            String prefix = "siri.server.channel[" + channel.getAddress() + "]";
            channel.getStatus(prefix, status);
        }
    }

    private class HeartbeatTask
    implements Runnable {
        private final ServerSubscriptionChannel _channel;

        public HeartbeatTask(ServerSubscriptionChannel channel) {
            this._channel = channel;
        }

        @Override
        public void run() {
            HeartbeatNotificationStructure heartbeat = new HeartbeatNotificationStructure();
            heartbeat.setServiceStartedTime(new Date(SiriServerSubscriptionManager.this._server.getServiceStartedTimestamp()));
            heartbeat.setStatus(Boolean.TRUE);
            heartbeat.setProducerRef(SiriTypeFactory.particpantRef(SiriServerSubscriptionManager.this._server.getIdentity()));
            heartbeat.setMessageIdentifier(SiriTypeFactory.randomMessageId());
            heartbeat.setRequestTimestamp(new Date());
            Siri siri = new Siri();
            siri.setHeartbeatNotification(heartbeat);
            SiriClientRequest request = new SiriClientRequest();
            request.setTargetUrl(this._channel.getAddress());
            request.setTargetVersion(this._channel.getTargetVersion());
            request.setPayload(siri);
            try {
                SiriServerSubscriptionManager.this._client.handleRequest(request);
            }
            catch (SiriConnectionException ex) {
                _log.warn("error publishing heartbeat to " + this._channel.getAddress(), (Throwable)ex);
                SiriServerSubscriptionManager.this.terminateSubscriptionChannelWithAddress(this._channel.getAddress());
            }
        }
    }
}

