/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.siri.core.subscriptions.server;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.List;
import org.onebusaway.siri.core.SiriTypeFactory;
import org.onebusaway.siri.core.subscriptions.SubscriptionId;
import uk.org.siri.siri.AbstractSubscriptionStructure;
import uk.org.siri.siri.OtherErrorStructure;
import uk.org.siri.siri.ParticipantRefStructure;
import uk.org.siri.siri.ServiceDeliveryErrorConditionStructure;
import uk.org.siri.siri.StatusResponseStructure;
import uk.org.siri.siri.SubscriptionRequest;
import uk.org.siri.siri.TerminateSubscriptionRequestStructure;
import uk.org.siri.siri.TerminateSubscriptionResponseStructure;
import uk.org.siri.siri.UnknownSubscriberErrorStructure;
import uk.org.siri.siri.UnknownSubscriptionErrorStructure;

class ServerSupport {
    ServerSupport() {
    }

    public String getSubscriberIdForSubscriptionRequest(SubscriptionRequest subscriptionRequest, AbstractSubscriptionStructure moduleRequest) {
        ParticipantRefStructure subscriberRef = moduleRequest.getSubscriberRef();
        if (subscriberRef != null && subscriberRef.getValue() != null) {
            return subscriberRef.getValue();
        }
        subscriberRef = subscriptionRequest.getRequestorRef();
        if (subscriberRef != null && subscriberRef.getValue() != null) {
            return subscriberRef.getValue();
        }
        return null;
    }

    public String getSubscriberIdForTerminateSubscriptionRequest(TerminateSubscriptionRequestStructure request) {
        ParticipantRefStructure ref = request.getSubscriberRef();
        if (ref != null && ref.getValue() != null) {
            return ref.getValue();
        }
        ref = request.getRequestorRef();
        if (ref != null && ref.getValue() != null) {
            return ref.getValue();
        }
        return null;
    }

    public StatusResponseStructure getStatusResponse(SubscriptionRequest request, SubscriptionId id) {
        StatusResponseStructure status = new StatusResponseStructure();
        status.setRequestMessageRef(request.getMessageIdentifier());
        status.setResponseTimestamp(new Date());
        status.setStatus(Boolean.TRUE);
        if (id != null) {
            status.setSubscriberRef(SiriTypeFactory.particpantRef(id.getSubscriberId()));
            status.setSubscriptionRef(SiriTypeFactory.subscriptionId(id.getSubscriptionId()));
        }
        return status;
    }

    public StatusResponseStructure getStatusResponseWithErrorMessage(SubscriptionRequest request, String errorText, SubscriptionId subscriptionId) {
        StatusResponseStructure status = this.getStatusResponse(request, null);
        status.setStatus(Boolean.FALSE);
        ServiceDeliveryErrorConditionStructure error = new ServiceDeliveryErrorConditionStructure();
        error.setDescription(SiriTypeFactory.errorDescription(errorText));
        OtherErrorStructure otherError = new OtherErrorStructure();
        otherError.setErrorText(errorText);
        error.setOtherError(otherError);
        status.setErrorCondition(error);
        return status;
    }

    public void addTerminateSubscriptionStatusForMissingSubscriberRef(TerminateSubscriptionRequestStructure request, List<TerminateSubscriptionResponseStructure.TerminationResponseStatus> statuses) {
        TerminateSubscriptionResponseStructure.TerminationResponseStatus status = new TerminateSubscriptionResponseStructure.TerminationResponseStatus();
        status.setStatus(false);
        status.setRequestMessageRef(request.getMessageIdentifier());
        TerminateSubscriptionResponseStructure.TerminationResponseStatus.ErrorCondition condition = new TerminateSubscriptionResponseStructure.TerminationResponseStatus.ErrorCondition();
        condition.setDescription(SiriTypeFactory.errorDescription("Missing SubscriberRef"));
        UnknownSubscriberErrorStructure error = new UnknownSubscriberErrorStructure();
        error.setErrorText("Missing SubscriberRef");
        condition.setUnknownSubscriberError(error);
        status.setErrorCondition(condition);
        statuses.add(status);
    }

    public void setTerminationResponseErrorConditionWithUnknownSubscription(TerminateSubscriptionResponseStructure.TerminationResponseStatus status) {
        status.setStatus(Boolean.FALSE.booleanValue());
        String errorMessage = "Unknown subscription";
        TerminateSubscriptionResponseStructure.TerminationResponseStatus.ErrorCondition condition = new TerminateSubscriptionResponseStructure.TerminationResponseStatus.ErrorCondition();
        status.setErrorCondition(condition);
        condition.setDescription(SiriTypeFactory.errorDescription(errorMessage));
        UnknownSubscriptionErrorStructure error = new UnknownSubscriptionErrorStructure();
        error.setErrorText(errorMessage);
        condition.setUnknownSubscriptionError(error);
    }

    public void setTerminationResponseErrorConditionWithException(TerminateSubscriptionResponseStructure.TerminationResponseStatus status, Throwable ex) {
        status.setStatus(Boolean.FALSE.booleanValue());
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        writer.append("Exception thropw on subscription termination:\n");
        ex.printStackTrace(printWriter);
        String errorMessage = writer.toString();
        TerminateSubscriptionResponseStructure.TerminationResponseStatus.ErrorCondition condition = new TerminateSubscriptionResponseStructure.TerminationResponseStatus.ErrorCondition();
        status.setErrorCondition(condition);
        condition.setDescription(SiriTypeFactory.errorDescription(errorMessage));
        OtherErrorStructure error = new OtherErrorStructure();
        error.setErrorText(errorMessage);
        condition.setOtherError(error);
    }
}

