/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.siri.core.subscriptions.server;

import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import org.onebusaway.siri.core.services.ExponentialWeightedAverageForTimeWindow;
import org.onebusaway.siri.core.subscriptions.SubscriptionId;
import org.onebusaway.siri.core.subscriptions.server.SiriServerSubscriptionEvent;
import org.onebusaway.siri.core.versioning.ESiriVersion;
import uk.org.siri.siri.ServiceDelivery;

class ServerSubscriptionChannel {
    private final String address;
    private final ESiriVersion targetVersion;
    private final Set<SubscriptionId> subscriptions = new HashSet<SubscriptionId>();
    private long heartbeatInterval = 0L;
    private ScheduledFuture<?> heartbeatTask;
    private final ExponentialWeightedAverageForTimeWindow _averageTimeNeededToPublish = new ExponentialWeightedAverageForTimeWindow(300000L);
    private final ExponentialWeightedAverageForTimeWindow _averagePublicationDelay = new ExponentialWeightedAverageForTimeWindow(300000L);
    private int _connectionErrorCount = 0;

    public ServerSubscriptionChannel(String address, ESiriVersion targetVersion) {
        this.address = address;
        this.targetVersion = targetVersion;
    }

    public String getAddress() {
        return this.address;
    }

    public ESiriVersion getTargetVersion() {
        return this.targetVersion;
    }

    public Set<SubscriptionId> getSubscriptions() {
        return this.subscriptions;
    }

    public long getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public void setHeartbeatInterval(long heartbeatInterval) {
        this.heartbeatInterval = heartbeatInterval;
    }

    public ScheduledFuture<?> getHeartbeatTask() {
        return this.heartbeatTask;
    }

    public void setHeartbeatTask(ScheduledFuture<?> heartbeatTask) {
        this.heartbeatTask = heartbeatTask;
    }

    public synchronized void updatePublicationStatistics(SiriServerSubscriptionEvent event, long timeNeededToPublish, boolean connectionError) {
        long now = System.currentTimeMillis();
        this._averageTimeNeededToPublish.addValueAtTime(timeNeededToPublish, now);
        ServiceDelivery delivery = event.getDelivery();
        Date responseTimestamp = delivery.getResponseTimestamp();
        long delay = now - responseTimestamp.getTime();
        this._averagePublicationDelay.addValueAtTime(delay, now);
        if (connectionError) {
            ++this._connectionErrorCount;
        }
    }

    public synchronized void getStatus(String prefix, Map<String, String> status) {
        status.put(prefix + ".averageTimeNeededToPublish", Long.toString((long)this._averageTimeNeededToPublish.getAverage()));
        status.put(prefix + ".averagePublicationDelay", Long.toString((long)this._averagePublicationDelay.getAverage()));
        status.put(prefix + ".connectionErrorCount", Integer.toString(this._connectionErrorCount));
    }
}

