/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.siri.core.subscriptions.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.onebusaway.collections.MappingLibrary;
import org.onebusaway.siri.core.SiriClientRequest;
import org.onebusaway.siri.core.SiriTypeFactory;
import org.onebusaway.siri.core.handlers.SiriClientHandler;
import org.onebusaway.siri.core.services.SchedulingService;
import org.onebusaway.siri.core.subscriptions.SubscriptionId;
import org.onebusaway.siri.core.subscriptions.client.ClientSubscriptionChannel;
import org.onebusaway.siri.core.subscriptions.client.ClientSubscriptionInstance;
import org.onebusaway.siri.core.subscriptions.client.ClientSupport;
import org.onebusaway.siri.core.subscriptions.client.SiriClientSubscriptionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.siri.siri.ErrorCodeStructure;
import uk.org.siri.siri.MessageQualifierStructure;
import uk.org.siri.siri.ParticipantRefStructure;
import uk.org.siri.siri.Siri;
import uk.org.siri.siri.SubscriptionQualifierStructure;
import uk.org.siri.siri.TerminateSubscriptionRequestStructure;
import uk.org.siri.siri.TerminateSubscriptionResponseStructure;

@Singleton
class TerminateSubscriptionsManager {
    private static final Logger _log = LoggerFactory.getLogger(TerminateSubscriptionsManager.class);
    private ConcurrentMap<String, PendingTermination> _pendingSubscriptionTerminations = new ConcurrentHashMap<String, PendingTermination>();
    private SiriClientSubscriptionManager _subscriptionManager;
    private SiriClientHandler _client;
    private SchedulingService _schedulingService;

    TerminateSubscriptionsManager() {
    }

    @Inject
    public void setSubscriptionManager(SiriClientSubscriptionManager subscriptionManager) {
        this._subscriptionManager = subscriptionManager;
    }

    @Inject
    public void setClient(SiriClientHandler client) {
        this._client = client;
    }

    @Inject
    public void setScheduleService(SchedulingService schedulingService) {
        this._schedulingService = schedulingService;
    }

    public String requestTerminationOfSubscription(ClientSubscriptionInstance instance, boolean resubscribeAfterTermination) {
        List<String> messageIds = this.requestTerminationOfSubscriptions(Arrays.asList(instance), resubscribeAfterTermination);
        return messageIds.get(0);
    }

    public List<String> requestTerminationOfSubscriptions(Collection<ClientSubscriptionInstance> instances, boolean resubscribeAfterTermination) {
        ArrayList<String> pendingTerminationMessageIds = new ArrayList<String>();
        Map instancesByChannel = MappingLibrary.mapToValueList(instances, (String)"channel");
        for (Map.Entry channelEntry : instancesByChannel.entrySet()) {
            ClientSubscriptionChannel channel = (ClientSubscriptionChannel)channelEntry.getKey();
            List channelInstances = (List)channelEntry.getValue();
            Map instancesBySubscriber = MappingLibrary.mapToValueList((Iterable)channelInstances, (String)"subscriptionId.subscriberId");
            for (Map.Entry entry : instancesBySubscriber.entrySet()) {
                String subscriberId = (String)entry.getKey();
                List subscriberInstances = (List)entry.getValue();
                ArrayList<SubscriptionId> subscriptionIds = new ArrayList<SubscriptionId>();
                ArrayList<SiriClientRequest> originalSubscriptionRequests = new ArrayList<SiriClientRequest>();
                for (ClientSubscriptionInstance instance : subscriberInstances) {
                    subscriptionIds.add(instance.getSubscriptionId());
                    originalSubscriptionRequests.add(instance.getRequest());
                }
                MessageQualifierStructure messageId = this.constructAndSubmitPendingTerminationRequest(channel, subscriberId, subscriptionIds, originalSubscriptionRequests, resubscribeAfterTermination);
                pendingTerminationMessageIds.add(messageId.getValue());
            }
        }
        return pendingTerminationMessageIds;
    }

    public String requestTerminationOfInitiatedSubscription(SiriClientRequest originalSubscriptionRequest, SubscriptionId subscriptionId, boolean resubscribeAfterTermination) {
        ClientSubscriptionChannel channel = new ClientSubscriptionChannel(originalSubscriptionRequest.getTargetUrl(), originalSubscriptionRequest.getTargetVersion());
        channel.setManageSubscriptionUrl(originalSubscriptionRequest.getManageSubscriptionUrl());
        String subscriberId = subscriptionId.getSubscriberId();
        List<SubscriptionId> subscriptionIds = Arrays.asList(subscriptionId);
        List<SiriClientRequest> originalSubscriptionRequests = Arrays.asList(originalSubscriptionRequest);
        MessageQualifierStructure messageId = this.constructAndSubmitPendingTerminationRequest(channel, subscriberId, subscriptionIds, originalSubscriptionRequests, resubscribeAfterTermination);
        return messageId.getValue();
    }

    public boolean isTerminationOfSubscriptionPending(String messageId) {
        return this._pendingSubscriptionTerminations.containsKey(messageId);
    }

    public void waitForPendingSubscriptionTerminationResponses(List<String> messageIds, int responseTimeout) {
        long waitUntil = System.currentTimeMillis() + (long)(responseTimeout * 1000) + 500L;
        for (String id : messageIds) {
            PendingTermination pending = (PendingTermination)this._pendingSubscriptionTerminations.get(id);
            if (pending == null) continue;
            long remaining = waitUntil - System.currentTimeMillis();
            if (remaining <= 0L) break;
            try {
                ScheduledFuture<?> task = pending.getTimeoutTask();
                task.get(remaining, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                break;
            }
        }
    }

    public void handleTerminateSubscriptionResponse(TerminateSubscriptionResponseStructure response) {
        MessageQualifierStructure messageIdRef = response.getRequestMessageRef();
        if (messageIdRef == null || messageIdRef.getValue() == null) {
            this.logTerminateSubscriptionResponseWithoutRequestMessageRef(response);
            return;
        }
        String messageId = messageIdRef.getValue();
        PendingTermination pending = (PendingTermination)this._pendingSubscriptionTerminations.remove(messageId);
        if (pending == null) {
            this.logUnknownTerminateSubscriptionResponse(response);
            return;
        }
        ScheduledFuture<?> timeoutTask = pending.getTimeoutTask();
        timeoutTask.cancel(true);
        String subscriberId = pending.getSubscriberId();
        for (TerminateSubscriptionResponseStructure.TerminationResponseStatus status : response.getTerminationResponseStatus()) {
            SubscriptionId id = this.getSubscriptionIdForTerminationStatusResponse(status, subscriberId);
            if (status.isStatus()) {
                _log.info("removing subscription after terminate-subscription-response received: id={}", (Object)id);
            } else {
                this.logErrorInTerminateSubscriptionResponse(response, status, id);
            }
            this._subscriptionManager.removeSubscription(id);
        }
        if (pending.isResubscribe()) {
            for (SiriClientRequest request : pending.getSubscriptionRequests()) {
                this._client.handleRequest(request);
            }
        }
    }

    private SubscriptionId getSubscriptionIdForTerminationStatusResponse(TerminateSubscriptionResponseStructure.TerminationResponseStatus status, String subscriberId) {
        ParticipantRefStructure subscriberRef = status.getSubscriberRef();
        SubscriptionQualifierStructure subscriptionRef = status.getSubscriptionRef();
        if (subscriberRef == null || subscriberRef.getValue() == null) {
            subscriberRef = SiriTypeFactory.particpantRef(subscriberId);
        }
        return ClientSupport.getSubscriptionId(subscriberRef, subscriptionRef);
    }

    private MessageQualifierStructure constructAndSubmitPendingTerminationRequest(ClientSubscriptionChannel channel, String subscriberId, List<SubscriptionId> subscriptionIds, List<SiriClientRequest> originalSubscriptionRequests, boolean resubscribeAfterTermination) {
        MessageQualifierStructure messageId = SiriTypeFactory.randomMessageId();
        PendingSubscriptionTerminationTimeoutTask timeoutTask = new PendingSubscriptionTerminationTimeoutTask(messageId.getValue());
        ScheduledFuture scheduled = this._schedulingService.scheduleResponseTimeoutTask(timeoutTask);
        PendingTermination pending = new PendingTermination(scheduled, subscriberId, subscriptionIds, resubscribeAfterTermination, originalSubscriptionRequests);
        this._pendingSubscriptionTerminations.put(messageId.getValue(), pending);
        SiriClientRequest request = this.getTerminateSubscriptionRequestForSubscriptions(channel, messageId, subscriberId, subscriptionIds);
        this._client.handleRequest(request);
        return messageId;
    }

    private SiriClientRequest getTerminateSubscriptionRequestForSubscriptions(ClientSubscriptionChannel channel, MessageQualifierStructure messageId, String subscriberId, List<SubscriptionId> subscriptionIds) {
        TerminateSubscriptionRequestStructure terminateRequest = new TerminateSubscriptionRequestStructure();
        terminateRequest.setMessageIdentifier(messageId);
        ParticipantRefStructure subscriberRef = SiriTypeFactory.particpantRef(subscriberId);
        terminateRequest.setSubscriberRef(subscriberRef);
        for (SubscriptionId id : subscriptionIds) {
            SubscriptionQualifierStructure value = new SubscriptionQualifierStructure();
            value.setValue(id.getSubscriptionId());
            terminateRequest.getSubscriptionRef().add(value);
        }
        Siri payload = new Siri();
        payload.setTerminateSubscriptionRequest(terminateRequest);
        String url = channel.getManageSubscriptionUrl();
        if (url == null) {
            url = channel.getAddress();
        }
        SiriClientRequest request = new SiriClientRequest();
        request.setTargetUrl(url);
        request.setTargetVersion(channel.getTargetVersion());
        request.setPayload(payload);
        return request;
    }

    private void logTerminateSubscriptionResponseWithoutRequestMessageRef(TerminateSubscriptionResponseStructure response) {
        StringBuilder b = new StringBuilder();
        b.append("A <TerminateSubscriptionResponse/> was received with no <RequestMessageRef/> value: ");
        if (response.getAddress() != null) {
            b.append(" address=").append(response.getAddress());
        }
        if (response.getResponderRef() != null && response.getResponderRef().getValue() != null) {
            b.append(" responderRef=").append(response.getResponderRef().getValue());
        }
        _log.warn(b.toString());
    }

    private void logUnknownTerminateSubscriptionResponse(TerminateSubscriptionResponseStructure response) {
        StringBuilder b = new StringBuilder();
        b.append("A <TerminateSubscriptionResponse/> was received with no pending <TerminateSubscriptionRequest/> having been sent:");
        if (response.getAddress() != null) {
            b.append(" address=").append(response.getAddress());
        }
        if (response.getResponderRef() != null && response.getResponderRef().getValue() != null) {
            b.append(" responderRef=").append(response.getResponderRef().getValue());
        }
        if (response.getRequestMessageRef() != null && response.getRequestMessageRef().getValue() != null) {
            b.append(" requestMessageRef=").append(response.getRequestMessageRef().getValue());
        }
        _log.warn(b.toString());
    }

    private void logErrorInTerminateSubscriptionResponse(TerminateSubscriptionResponseStructure response, TerminateSubscriptionResponseStructure.TerminationResponseStatus status, SubscriptionId subId) {
        StringBuilder b = new StringBuilder();
        b.append("We received an error response for a subscription termination request:");
        if (response.getAddress() != null) {
            b.append(" address=").append(response.getAddress());
        }
        if (response.getResponderRef() != null && response.getResponderRef().getValue() != null) {
            b.append(" responderRef=" + response.getResponderRef().getValue());
        }
        b.append(" subscriptionId=" + subId);
        TerminateSubscriptionResponseStructure.TerminationResponseStatus.ErrorCondition error = status.getErrorCondition();
        if (error != null) {
            ClientSupport.appendError((ErrorCodeStructure)error.getCapabilityNotSupportedError(), b);
            ClientSupport.appendError((ErrorCodeStructure)error.getUnknownSubscriberError(), b);
            ClientSupport.appendError((ErrorCodeStructure)error.getUnknownSubscriptionError(), b);
            ClientSupport.appendError((ErrorCodeStructure)error.getOtherError(), b);
            if (error.getDescription() != null && error.getDescription().getValue() != null) {
                b.append(" errorDescription=").append(error.getDescription().getValue());
            }
        }
        _log.warn(b.toString());
    }

    private static class PendingTermination {
        private final ScheduledFuture<?> _timeoutTask;
        private final String _subscriberId;
        private final List<SubscriptionId> _subscriptionIds;
        private final boolean _resubscribe;
        private final List<SiriClientRequest> _subscriptionRequests;

        public PendingTermination(ScheduledFuture<?> timeoutTask, String subscriberId, List<SubscriptionId> subscriptionIds, boolean resubscribe, List<SiriClientRequest> subscriptionRequests) {
            this._timeoutTask = timeoutTask;
            this._subscriberId = subscriberId;
            this._subscriptionIds = subscriptionIds;
            this._resubscribe = resubscribe;
            this._subscriptionRequests = subscriptionRequests;
        }

        public ScheduledFuture<?> getTimeoutTask() {
            return this._timeoutTask;
        }

        public String getSubscriberId() {
            return this._subscriberId;
        }

        public List<SubscriptionId> getSubscriptionIds() {
            return this._subscriptionIds;
        }

        public boolean isResubscribe() {
            return this._resubscribe;
        }

        public List<SiriClientRequest> getSubscriptionRequests() {
            return this._subscriptionRequests;
        }
    }

    private class PendingSubscriptionTerminationTimeoutTask
    implements Runnable {
        private final String _messageId;

        public PendingSubscriptionTerminationTimeoutTask(String messageId) {
            this._messageId = messageId;
        }

        @Override
        public void run() {
            PendingTermination pending = (PendingTermination)TerminateSubscriptionsManager.this._pendingSubscriptionTerminations.remove(this._messageId);
            if (pending != null) {
                _log.warn("pending subscription termination expired before receiving a subscription termination response from server: requestMessageRef=" + this._messageId + " timeout=" + TerminateSubscriptionsManager.this._schedulingService.getResponseTimeout() + "s");
                for (SubscriptionId subscriptionId : pending.getSubscriptionIds()) {
                    TerminateSubscriptionsManager.this._subscriptionManager.removeSubscription(subscriptionId);
                }
                if (pending.isResubscribe()) {
                    for (SiriClientRequest request : pending.getSubscriptionRequests()) {
                        TerminateSubscriptionsManager.this._client.handleRequest(request);
                    }
                }
            }
        }
    }
}

