/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.siri.core.subscriptions.client;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.onebusaway.siri.core.ESiriModuleType;
import org.onebusaway.siri.core.SiriChannelInfo;
import org.onebusaway.siri.core.SiriClientRequest;
import org.onebusaway.siri.core.SiriLibrary;
import org.onebusaway.siri.core.exceptions.SiriException;
import org.onebusaway.siri.core.services.SchedulingService;
import org.onebusaway.siri.core.services.StatusProviderService;
import org.onebusaway.siri.core.subscriptions.SubscriptionId;
import org.onebusaway.siri.core.subscriptions.client.CheckStatusManager;
import org.onebusaway.siri.core.subscriptions.client.ClientSubscriptionChannel;
import org.onebusaway.siri.core.subscriptions.client.ClientSubscriptionInstance;
import org.onebusaway.siri.core.subscriptions.client.ClientSupport;
import org.onebusaway.siri.core.subscriptions.client.HeartbeatManager;
import org.onebusaway.siri.core.subscriptions.client.InitiateSubscriptionsManager;
import org.onebusaway.siri.core.subscriptions.client.SubscriptionExpirationTask;
import org.onebusaway.siri.core.subscriptions.client.TerminateSubscriptionsManager;
import org.onebusaway.siri.core.versioning.ESiriVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.siri.siri.AbstractServiceDeliveryStructure;
import uk.org.siri.siri.CheckStatusResponseStructure;
import uk.org.siri.siri.HeartbeatNotificationStructure;
import uk.org.siri.siri.ServiceDelivery;
import uk.org.siri.siri.StatusResponseStructure;
import uk.org.siri.siri.SubscriptionRequest;
import uk.org.siri.siri.SubscriptionResponseStructure;
import uk.org.siri.siri.TerminateSubscriptionResponseStructure;

@Singleton
public class SiriClientSubscriptionManager
implements StatusProviderService {
    private static Logger _log = LoggerFactory.getLogger(SiriClientSubscriptionManager.class);
    private ConcurrentMap<String, ClientSubscriptionChannel> _activeChannels = new ConcurrentHashMap<String, ClientSubscriptionChannel>();
    private ConcurrentMap<SubscriptionId, ClientSubscriptionInstance> _activeSubscriptions = new ConcurrentHashMap<SubscriptionId, ClientSubscriptionInstance>();
    private SchedulingService _schedulingService;
    private InitiateSubscriptionsManager _initiateSubscriptionsManager;
    private CheckStatusManager _checkStatusManager;
    private HeartbeatManager _heartbeatManager;
    private TerminateSubscriptionsManager _terminateSubscriptionsManager;

    @Inject
    public void setSchedulingService(SchedulingService schedulingService) {
        this._schedulingService = schedulingService;
    }

    @Inject
    void setInitiateSubscriptionManager(InitiateSubscriptionsManager initiateSubscriptionsManager) {
        this._initiateSubscriptionsManager = initiateSubscriptionsManager;
    }

    @Inject
    void setCheckStatusManager(CheckStatusManager checkStatusManager) {
        this._checkStatusManager = checkStatusManager;
    }

    @Inject
    public void setHeartbeatManager(HeartbeatManager heartbeatManager) {
        this._heartbeatManager = heartbeatManager;
    }

    @Inject
    void setTerminateSubscriptionsManager(TerminateSubscriptionsManager terminateSubscriptionsManager) {
        this._terminateSubscriptionsManager = terminateSubscriptionsManager;
    }

    public void registerPendingSubscription(SiriClientRequest request, SubscriptionRequest subscriptionRequest) {
        _log.info("pending subscription: {}", (Object)request);
        this._initiateSubscriptionsManager.registerPendingSubscription(request, subscriptionRequest);
    }

    public void clearPendingSubscription(SiriClientRequest request, SubscriptionRequest subscriptionRequest) {
        _log.info("clear pending subscription: {}", (Object)request);
        this._initiateSubscriptionsManager.clearPendingSubscription(request, subscriptionRequest);
    }

    public void handleSubscriptionResponse(SubscriptionResponseStructure response) {
        this._initiateSubscriptionsManager.handleSubscriptionResponse(response);
    }

    public boolean isSubscriptionActive(SubscriptionId subscriptionId) {
        return this._activeSubscriptions.containsKey(subscriptionId);
    }

    public boolean isSubscriptionActiveForModuleDelivery(AbstractServiceDeliveryStructure moduleDelivery) {
        SubscriptionId id = ClientSupport.getSubscriptionIdForModuleDelivery(moduleDelivery);
        return this.isSubscriptionActive(id);
    }

    public SiriChannelInfo getChannelInfoForServiceDelivery(ServiceDelivery serviceDelivery) {
        ClientSubscriptionChannel channel;
        SiriChannelInfo channelInfo = new SiriChannelInfo();
        HashSet<ClientSubscriptionChannel> channels = new HashSet<ClientSubscriptionChannel>();
        HashSet<SiriClientRequest> requests = new HashSet<SiriClientRequest>();
        String address = serviceDelivery.getAddress();
        if (address != null && (channel = (ClientSubscriptionChannel)this._activeChannels.get(address)) != null) {
            channels.add(channel);
        }
        for (ESiriModuleType moduleType : ESiriModuleType.values()) {
            List<AbstractServiceDeliveryStructure> moduleDeliveries = SiriLibrary.getServiceDeliveriesForModule(serviceDelivery, moduleType);
            for (AbstractServiceDeliveryStructure moduleDelivery : moduleDeliveries) {
                SubscriptionId subscriptionId;
                ClientSubscriptionInstance instance;
                if (!ClientSupport.hasSubscriptionIdForModuleDelivery(moduleDelivery) || (instance = (ClientSubscriptionInstance)this._activeSubscriptions.get(subscriptionId = ClientSupport.getSubscriptionIdForModuleDelivery(moduleDelivery))) == null) continue;
                channels.add(instance.getChannel());
                requests.add(instance.getRequest());
            }
        }
        channelInfo.setSiriClientRequests(new ArrayList<SiriClientRequest>(requests));
        if (!channels.isEmpty()) {
            if (channels.size() > 1) {
                _log.warn("multiple channels found for a single service delivery");
            } else {
                channel = (ClientSubscriptionChannel)channels.iterator().next();
                channelInfo.setContext(channel.getContext());
            }
        }
        return channelInfo;
    }

    public void handleTerminateSubscriptionResponse(TerminateSubscriptionResponseStructure response) {
        this._terminateSubscriptionsManager.handleTerminateSubscriptionResponse(response);
    }

    public void terminateAllSubscriptions(boolean waitForTerminateSubscriptionResponseOnExit) {
        _log.info("terminate all subscriptions");
        List<String> allPendings = this._terminateSubscriptionsManager.requestTerminationOfSubscriptions(this._activeSubscriptions.values(), false);
        if (waitForTerminateSubscriptionResponseOnExit) {
            this._terminateSubscriptionsManager.waitForPendingSubscriptionTerminationResponses(allPendings, this._schedulingService.getResponseTimeout());
        }
    }

    public void handleCheckStatusNotification(CheckStatusResponseStructure response) {
        this._checkStatusManager.handleCheckStatusResponse(response);
    }

    public void handleHeartbeatNotification(HeartbeatNotificationStructure heartbeat) {
        _log.debug("hearbeat notification");
        ClientSubscriptionChannel channel = (ClientSubscriptionChannel)this._activeChannels.get(heartbeat.getAddress());
        if (channel != null) {
            this._heartbeatManager.resetHeartbeat(channel, channel.getHeartbeatInterval());
        }
    }

    @Override
    public void getStatus(Map<String, String> status) {
        status.put("siri.client.activeChannels", Integer.toString(this._activeChannels.size()));
        status.put("siri.client.activeSubscriptions", Integer.toString(this._activeSubscriptions.size()));
    }

    synchronized void upgradePendingSubscription(SubscriptionResponseStructure response, StatusResponseStructure status, SubscriptionId subscriptionId, ESiriModuleType moduleType, SiriClientRequest originalSubscriptionRequest) {
        _log.info("upgrade pending subscription: {}", (Object)originalSubscriptionRequest);
        ClientSubscriptionChannel channel = this.getChannelForServer(originalSubscriptionRequest.getTargetUrl(), originalSubscriptionRequest.getTargetVersion());
        ScheduledFuture<?> expiration = this.registerSubscriptionExpirationTask(subscriptionId, status, originalSubscriptionRequest);
        ClientSubscriptionInstance instance = new ClientSubscriptionInstance(channel, subscriptionId, originalSubscriptionRequest, moduleType, expiration);
        ClientSubscriptionInstance existing = this._activeSubscriptions.put(subscriptionId, instance);
        if (existing != null) {
            _log.info("overwriting existing subscription: " + subscriptionId);
        }
        Set<SubscriptionId> channelSubscriptions = channel.getSubscriptions();
        channelSubscriptions.add(subscriptionId);
        this.updateChannelWithClientRequest(channel, originalSubscriptionRequest, response);
    }

    ESiriModuleType getModuleTypeForSubscriptionId(SubscriptionId subId) {
        ClientSubscriptionInstance instance = (ClientSubscriptionInstance)this._activeSubscriptions.get(subId);
        if (instance == null) {
            return null;
        }
        return instance.getModuleType();
    }

    void requestSubscriptionTerminationAndResubscription(SubscriptionId subscriptionId) {
        ClientSubscriptionInstance instance = (ClientSubscriptionInstance)this._activeSubscriptions.get(subscriptionId);
        if (instance == null) {
            _log.warn("no subscription found to unsubscribe/resubscribe with id={}", (Object)subscriptionId);
            return;
        }
        this._terminateSubscriptionsManager.requestTerminationOfSubscription(instance, true);
    }

    synchronized void removeSubscription(SubscriptionId subscriptionId) {
        ClientSubscriptionInstance instance = (ClientSubscriptionInstance)this._activeSubscriptions.remove(subscriptionId);
        if (instance == null) {
            _log.warn("subscription has already been removed: {}", (Object)subscriptionId);
            return;
        }
        ScheduledFuture<?> expirationTask = instance.getExpirationTask();
        if (expirationTask != null) {
            expirationTask.cancel(true);
        }
        ClientSubscriptionChannel channel = instance.getChannel();
        Set<SubscriptionId> subscriptions = channel.getSubscriptions();
        subscriptions.remove(instance.getSubscriptionId());
        if (subscriptions.isEmpty()) {
            _log.debug("channel has no more subscriptions: {}", (Object)channel.getAddress());
            this._checkStatusManager.resetCheckStatusTask(channel, 0);
            this._heartbeatManager.resetHeartbeat(channel, 0);
            this._activeChannels.remove(channel.getAddress());
        }
    }

    void handleChannelDisconnectAndReconnect(ClientSubscriptionChannel channel) {
        _log.info("channel disconnect: {}", (Object)channel.getAddress());
        HashSet<SubscriptionId> channelSubscriptionIds = new HashSet<SubscriptionId>(channel.getSubscriptions());
        ArrayList<ClientSubscriptionInstance> instances = new ArrayList<ClientSubscriptionInstance>();
        for (SubscriptionId subscriptionId : channelSubscriptionIds) {
            ClientSubscriptionInstance instance = (ClientSubscriptionInstance)this._activeSubscriptions.get(subscriptionId);
            if (instance == null) continue;
            instances.add(instance);
        }
        this._terminateSubscriptionsManager.requestTerminationOfSubscriptions(instances, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateChannelWithClientRequest(ClientSubscriptionChannel channel, SiriClientRequest request, SubscriptionResponseStructure response) {
        ClientSubscriptionChannel clientSubscriptionChannel = channel;
        synchronized (clientSubscriptionChannel) {
            Date serviceStartedTime = response.getServiceStartedTime();
            if (serviceStartedTime != null) {
                channel.setLastServiceStartedTime(serviceStartedTime);
            }
            channel.setManageSubscriptionUrl(request.getManageSubscriptionUrl());
            channel.setCheckStatusUrl(request.getCheckStatusUrl());
            channel.setReconnectionAttempts(request.getReconnectionAttempts());
            channel.setReconnectionInterval(request.getReconnectionInterval());
            channel.setContext(request.getChannelContext());
            int heartbeatInterval = request.getHeartbeatInterval();
            this._heartbeatManager.resetHeartbeat(channel, heartbeatInterval);
            int checkStatusInterval = request.getCheckStatusInterval();
            this._checkStatusManager.resetCheckStatusTask(channel, checkStatusInterval);
        }
    }

    private synchronized ClientSubscriptionChannel getChannelForServer(String address, ESiriVersion targetVersion) {
        ClientSubscriptionChannel newChannel;
        ClientSubscriptionChannel channel = (ClientSubscriptionChannel)this._activeChannels.get(address);
        if (channel == null && (channel = this._activeChannels.putIfAbsent(address, newChannel = new ClientSubscriptionChannel(address, targetVersion))) == null) {
            channel = newChannel;
        }
        if (channel.getTargetVersion() != targetVersion) {
            throw new SiriException("existing channel with address " + address + " has SIRI version " + (Object)((Object)channel.getTargetVersion()) + " but a new subscription wants to use version " + (Object)((Object)targetVersion));
        }
        return channel;
    }

    private ScheduledFuture<?> registerSubscriptionExpirationTask(SubscriptionId subscriptionId, StatusResponseStructure status, SiriClientRequest originalSubscriptionRequest) {
        Date validUntil;
        long newDelay;
        long delay = originalSubscriptionRequest.getInitialTerminationDuration();
        if (status.getValidUntil() != null && (newDelay = (validUntil = status.getValidUntil()).getTime() - System.currentTimeMillis()) < delay) {
            delay = newDelay;
        }
        _log.debug("subscription is valid for {} secs", (Object)(delay / 1000L));
        ScheduledFuture expiration = null;
        if (delay > 0L) {
            SubscriptionExpirationTask task = new SubscriptionExpirationTask(this, subscriptionId);
            expiration = this._schedulingService.schedule(task, delay, TimeUnit.MILLISECONDS);
        } else {
            _log.warn("subscription has already expired before it had a chance to start: id={} delay={}", (Object)subscriptionId, (Object)(delay / 1000L));
        }
        return expiration;
    }
}

