/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.siri.core.subscriptions.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.onebusaway.siri.core.ESiriModuleType;
import org.onebusaway.siri.core.SiriClientRequest;
import org.onebusaway.siri.core.SiriLibrary;
import org.onebusaway.siri.core.exceptions.SiriSubscriptionModuleTypeConflictException;
import org.onebusaway.siri.core.services.SchedulingService;
import org.onebusaway.siri.core.subscriptions.SubscriptionId;
import org.onebusaway.siri.core.subscriptions.client.ClientPendingSubscription;
import org.onebusaway.siri.core.subscriptions.client.ClientSupport;
import org.onebusaway.siri.core.subscriptions.client.SiriClientSubscriptionManager;
import org.onebusaway.siri.core.subscriptions.client.TerminateSubscriptionsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.siri.siri.AbstractSubscriptionStructure;
import uk.org.siri.siri.ErrorCodeStructure;
import uk.org.siri.siri.ParticipantRefStructure;
import uk.org.siri.siri.ServiceDeliveryErrorConditionStructure;
import uk.org.siri.siri.StatusResponseStructure;
import uk.org.siri.siri.SubscriptionQualifierStructure;
import uk.org.siri.siri.SubscriptionRequest;
import uk.org.siri.siri.SubscriptionResponseStructure;

@Singleton
class InitiateSubscriptionsManager {
    private static final Logger _log = LoggerFactory.getLogger(InitiateSubscriptionsManager.class);
    private ConcurrentMap<SubscriptionId, ClientPendingSubscription> _pendingSubscriptionRequests = new ConcurrentHashMap<SubscriptionId, ClientPendingSubscription>();
    private SiriClientSubscriptionManager _subscriptionManager;
    private SchedulingService _schedulingService;
    private TerminateSubscriptionsManager _terminateSubscriptionManager;

    InitiateSubscriptionsManager() {
    }

    @Inject
    public void setSubscriptionManager(SiriClientSubscriptionManager subscriptionManager) {
        this._subscriptionManager = subscriptionManager;
    }

    @Inject
    public void setScheduleService(SchedulingService schedulingService) {
        this._schedulingService = schedulingService;
    }

    @Inject
    public void setTerminateSubscriptionManager(TerminateSubscriptionsManager terminateSubscriptionManager) {
        this._terminateSubscriptionManager = terminateSubscriptionManager;
    }

    public boolean isSubscriptionPending(SubscriptionId subscriptionId) {
        return this._pendingSubscriptionRequests.containsKey(subscriptionId);
    }

    public void registerPendingSubscription(SiriClientRequest request, SubscriptionRequest subscriptionRequest) {
        _log.debug("register pending subscription request");
        HashMap<SubscriptionId, ClientPendingSubscription> pendingSubscriptions = new HashMap<SubscriptionId, ClientPendingSubscription>();
        for (ESiriModuleType moduleType : ESiriModuleType.values()) {
            List<AbstractSubscriptionStructure> requests = SiriLibrary.getSubscriptionRequestsForModule(subscriptionRequest, moduleType);
            for (AbstractSubscriptionStructure subRequest : requests) {
                SubscriptionId subId = this.getSubscriptionIdForSubscriptionRequest(subscriptionRequest, subRequest);
                this.checkForModuleTypeConflict(subId, moduleType, pendingSubscriptions);
                ClientPendingSubscription pending = new ClientPendingSubscription(subId, request, moduleType, subRequest);
                pendingSubscriptions.put(subId, pending);
            }
        }
        this._pendingSubscriptionRequests.putAll(pendingSubscriptions);
        PendingSubscriptionTimeoutTask task = new PendingSubscriptionTimeoutTask(pendingSubscriptions.keySet());
        this._schedulingService.scheduleResponseTimeoutTask(task);
    }

    public void clearPendingSubscription(SiriClientRequest request, SubscriptionRequest subscriptionRequest) {
        for (ESiriModuleType moduleType : ESiriModuleType.values()) {
            List<AbstractSubscriptionStructure> requests = SiriLibrary.getSubscriptionRequestsForModule(subscriptionRequest, moduleType);
            for (AbstractSubscriptionStructure subRequest : requests) {
                SubscriptionId subId = this.getSubscriptionIdForSubscriptionRequest(subscriptionRequest, subRequest);
                this._pendingSubscriptionRequests.remove(subId);
            }
        }
    }

    public void handleSubscriptionResponse(SubscriptionResponseStructure response) {
        for (StatusResponseStructure status : response.getResponseStatus()) {
            SubscriptionId subId = this.getSubscriptionIdForStatusResponse(status);
            ClientPendingSubscription pending = (ClientPendingSubscription)this._pendingSubscriptionRequests.remove(subId);
            if (pending == null) {
                this.logUnknownSubscriptionResponse(response, subId);
                continue;
            }
            if (status.isStatus().booleanValue()) {
                this._subscriptionManager.upgradePendingSubscription(response, status, subId, pending.getModuleType(), pending.getRequest());
                continue;
            }
            this.logErrorInSubscriptionResponse(response, status, subId);
        }
    }

    private void checkForModuleTypeConflict(SubscriptionId subId, ESiriModuleType moduleType, Map<SubscriptionId, ClientPendingSubscription> pendingSubscriptions) throws SiriSubscriptionModuleTypeConflictException {
        ESiriModuleType existingModuleType = this._subscriptionManager.getModuleTypeForSubscriptionId(subId);
        if (existingModuleType != null && existingModuleType != moduleType) {
            this.logWarningAboutActiveSubscriptionsWithDifferentModuleTypes(subId, moduleType, existingModuleType);
            throw new SiriSubscriptionModuleTypeConflictException(subId, existingModuleType, moduleType);
        }
        ClientPendingSubscription pending = (ClientPendingSubscription)this._pendingSubscriptionRequests.get(subId);
        if (pending != null && pending.getModuleType() != moduleType) {
            this.logWarningAboutPendingSubscriptionsWithDifferentModuleTypes(subId, moduleType, pending);
            throw new SiriSubscriptionModuleTypeConflictException(subId, pending.getModuleType(), moduleType);
        }
        pending = pendingSubscriptions.get(subId);
        if (pending != null && pending.getModuleType() != moduleType) {
            this.logWarningAboutPendingSubscriptionsWithDifferentModuleTypes(subId, moduleType, pending);
            throw new SiriSubscriptionModuleTypeConflictException(subId, pending.getModuleType(), moduleType);
        }
    }

    private SubscriptionId getSubscriptionIdForSubscriptionRequest(SubscriptionRequest subscriptionRequest, AbstractSubscriptionStructure functionalSubscriptionRequest) {
        ParticipantRefStructure subscriberRef = this.getBestSubscriberRef(functionalSubscriptionRequest.getSubscriberRef(), subscriptionRequest.getRequestorRef());
        SubscriptionQualifierStructure subscriptionRef = functionalSubscriptionRequest.getSubscriptionIdentifier();
        return ClientSupport.getSubscriptionId(subscriberRef, subscriptionRef);
    }

    private ParticipantRefStructure getBestSubscriberRef(ParticipantRefStructure ... refs) {
        for (ParticipantRefStructure ref : refs) {
            if (ref == null || ref.getValue() == null) continue;
            return ref;
        }
        return null;
    }

    private SubscriptionId getSubscriptionIdForStatusResponse(StatusResponseStructure status) {
        ParticipantRefStructure subscriberRef = status.getSubscriberRef();
        SubscriptionQualifierStructure subscriptionRef = status.getSubscriptionRef();
        return ClientSupport.getSubscriptionId(subscriberRef, subscriptionRef);
    }

    private void logUnknownSubscriptionResponse(SubscriptionResponseStructure response, SubscriptionId subId) {
        StringBuilder b = new StringBuilder();
        b.append("A <SubscriptionResponse/ResponseStatus/> was received with no pending <SubscriptionRequest/> having been sent:");
        if (response.getAddress() != null) {
            b.append(" address=").append(response.getAddress());
        }
        if (response.getSubscriptionManagerAddress() != null) {
            b.append(" subscriptionManagerAddress=").append(response.getSubscriptionManagerAddress());
        }
        if (response.getResponderRef() != null && response.getResponderRef().getValue() != null) {
            b.append(" responderRef=" + response.getResponderRef().getValue());
        }
        b.append(" subscriptionId=" + subId);
        _log.warn(b.toString());
    }

    private void logErrorInSubscriptionResponse(SubscriptionResponseStructure response, StatusResponseStructure status, SubscriptionId subId) {
        StringBuilder b = new StringBuilder();
        b.append("We received an error response for a subscription request:");
        if (response.getAddress() != null) {
            b.append(" address=").append(response.getAddress());
        }
        if (response.getSubscriptionManagerAddress() != null) {
            b.append(" subscriptionManagerAddress=").append(response.getSubscriptionManagerAddress());
        }
        if (response.getResponderRef() != null && response.getResponderRef().getValue() != null) {
            b.append(" responderRef=" + response.getResponderRef().getValue());
        }
        b.append(" subscriptionId=" + subId);
        ServiceDeliveryErrorConditionStructure error = status.getErrorCondition();
        if (error != null) {
            ClientSupport.appendError((ErrorCodeStructure)error.getAccessNotAllowedError(), b);
            ClientSupport.appendError((ErrorCodeStructure)error.getAllowedResourceUsageExceededError(), b);
            ClientSupport.appendError((ErrorCodeStructure)error.getCapabilityNotSupportedError(), b);
            ClientSupport.appendError((ErrorCodeStructure)error.getNoInfoForTopicError(), b);
            ClientSupport.appendError((ErrorCodeStructure)error.getOtherError(), b);
            if (error.getDescription() != null && error.getDescription().getValue() != null) {
                b.append(" errorDescription=").append(error.getDescription().getValue());
            }
        }
        _log.warn(b.toString());
    }

    private void logWarningAboutActiveSubscriptionsWithDifferentModuleTypes(SubscriptionId subId, ESiriModuleType newModuleType, ESiriModuleType existingModuleType) {
        _log.warn("An existing subscription (" + subId + ") already exists for module type " + (Object)((Object)existingModuleType) + " but a new subscription has been requested for module type " + (Object)((Object)newModuleType) + ".  Reuse of the same subscription id across different module types is not supported.");
    }

    private void logWarningAboutPendingSubscriptionsWithDifferentModuleTypes(SubscriptionId subId, ESiriModuleType moduleType, ClientPendingSubscription pending) {
        _log.warn("An existing pending subscription (" + subId + ") already exists for module type " + (Object)((Object)pending.getModuleType()) + " but a new subscription has been requested for module type " + (Object)((Object)moduleType) + ".  Reuse of the same subscription id across different module types is not supported.");
    }

    private class PendingSubscriptionTimeoutTask
    implements Runnable {
        private final List<SubscriptionId> _subscriptionIds;

        public PendingSubscriptionTimeoutTask(Set<SubscriptionId> subscriptionIds) {
            this._subscriptionIds = new ArrayList<SubscriptionId>(subscriptionIds);
        }

        @Override
        public void run() {
            for (SubscriptionId subscriptionId : this._subscriptionIds) {
                ClientPendingSubscription pending = (ClientPendingSubscription)InitiateSubscriptionsManager.this._pendingSubscriptionRequests.remove(subscriptionId);
                if (pending == null) continue;
                SiriClientRequest request = pending.getRequest();
                _log.warn("pending subscription expired before receiving a subscription response from server: url=" + request.getTargetUrl() + " subscriptionId=" + subscriptionId + " remainingConnectionAttempts=" + request.getRemainingReconnectionAttempts() + " connectionErrorCount=" + request.getConnectionErrorCount() + " timeout=" + InitiateSubscriptionsManager.this._schedulingService.getResponseTimeout() + "s");
                request.incrementConnectionErrorCount();
                boolean resubscribe = request.getRemainingReconnectionAttempts() != 0;
                request.decrementRemainingReconnctionAttempts();
                InitiateSubscriptionsManager.this._terminateSubscriptionManager.requestTerminationOfInitiatedSubscription(request, subscriptionId, resubscribe);
            }
        }
    }
}

