/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.siri.core.subscriptions.client;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.onebusaway.siri.core.services.SchedulingService;
import org.onebusaway.siri.core.subscriptions.client.ClientSubscriptionChannel;
import org.onebusaway.siri.core.subscriptions.client.SiriClientSubscriptionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
class HeartbeatManager {
    private static final Logger _log = LoggerFactory.getLogger(HeartbeatManager.class);
    private SchedulingService _schedulingService;
    private SiriClientSubscriptionManager _subscriptionManager;

    HeartbeatManager() {
    }

    @Inject
    public void setSchedulingService(SchedulingService schedulingService) {
        this._schedulingService = schedulingService;
    }

    @Inject
    public void setSubscriptionManager(SiriClientSubscriptionManager subscriptionManager) {
        this._subscriptionManager = subscriptionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetHeartbeat(ClientSubscriptionChannel channel, int heartbeatInterval) {
        ClientSubscriptionChannel clientSubscriptionChannel = channel;
        synchronized (clientSubscriptionChannel) {
            channel.setHeartbeatInterval(heartbeatInterval);
            ScheduledFuture<Object> heartbeatTask = channel.getHeartbeatTask();
            if (heartbeatTask != null) {
                heartbeatTask.cancel(true);
                channel.setHeartbeatTask(null);
            }
            if (heartbeatInterval > 0) {
                HeartbeatTimeoutTask task = new HeartbeatTimeoutTask(this._subscriptionManager, channel);
                long interval = heartbeatInterval + this._schedulingService.getResponseTimeout();
                heartbeatTask = this._schedulingService.schedule(task, interval, TimeUnit.SECONDS);
                channel.setHeartbeatTask(heartbeatTask);
            }
        }
    }

    private static class HeartbeatTimeoutTask
    implements Runnable {
        private final SiriClientSubscriptionManager manager;
        private final ClientSubscriptionChannel channel;

        public HeartbeatTimeoutTask(SiriClientSubscriptionManager manager, ClientSubscriptionChannel channel) {
            this.manager = manager;
            this.channel = channel;
        }

        @Override
        public void run() {
            _log.warn("heartbeat interval timeout: " + this.channel.getAddress());
            this.manager.handleChannelDisconnectAndReconnect(this.channel);
        }
    }
}

