/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.siri.core.subscriptions.client;

import org.onebusaway.siri.core.exceptions.SiriMissingArgumentException;
import org.onebusaway.siri.core.subscriptions.SubscriptionId;
import uk.org.siri.siri.AbstractServiceDeliveryStructure;
import uk.org.siri.siri.ErrorCodeStructure;
import uk.org.siri.siri.ParticipantRefStructure;
import uk.org.siri.siri.SubscriptionQualifierStructure;

class ClientSupport {
    ClientSupport() {
    }

    public static boolean hasSubscriptionId(ParticipantRefStructure subscriberRef, SubscriptionQualifierStructure subscriptionRef) {
        if (subscriberRef == null || subscriberRef.getValue() == null) {
            return false;
        }
        return subscriptionRef != null && subscriptionRef.getValue() != null;
    }

    public static SubscriptionId getSubscriptionId(ParticipantRefStructure subscriberRef, SubscriptionQualifierStructure subscriptionRef) {
        if (subscriberRef == null || subscriberRef.getValue() == null) {
            throw new SiriMissingArgumentException("SubscriberRef");
        }
        if (subscriptionRef == null || subscriptionRef.getValue() == null) {
            throw new SiriMissingArgumentException("SubscriptionRef");
        }
        return new SubscriptionId(subscriberRef.getValue(), subscriptionRef.getValue());
    }

    public static void appendError(ErrorCodeStructure code, StringBuilder b) {
        if (code == null) {
            return;
        }
        Class<?> clazz = code.getClass();
        String name = clazz.getName();
        int index = name.lastIndexOf(46);
        if (index != -1) {
            name = name.substring(index + 1);
        }
        b.append(" errorType=").append(name);
        if (code.getErrorText() != null) {
            b.append(" errorText=").append(code.getErrorText());
        }
    }

    public static boolean hasSubscriptionIdForModuleDelivery(AbstractServiceDeliveryStructure moduleDelivery) {
        ParticipantRefStructure subscriberRef = moduleDelivery.getSubscriberRef();
        SubscriptionQualifierStructure subscriptionRef = moduleDelivery.getSubscriptionRef();
        return ClientSupport.hasSubscriptionId(subscriberRef, subscriptionRef);
    }

    public static SubscriptionId getSubscriptionIdForModuleDelivery(AbstractServiceDeliveryStructure moduleDelivery) {
        ParticipantRefStructure subscriberRef = moduleDelivery.getSubscriberRef();
        SubscriptionQualifierStructure subscriptionRef = moduleDelivery.getSubscriptionRef();
        return ClientSupport.getSubscriptionId(subscriberRef, subscriptionRef);
    }
}

