/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.siri.core.subscriptions.client;

import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.onebusaway.siri.core.SiriClientRequest;
import org.onebusaway.siri.core.SiriTypeFactory;
import org.onebusaway.siri.core.exceptions.SiriMissingArgumentException;
import org.onebusaway.siri.core.handlers.SiriClientHandler;
import org.onebusaway.siri.core.services.SchedulingService;
import org.onebusaway.siri.core.subscriptions.client.ClientSubscriptionChannel;
import org.onebusaway.siri.core.subscriptions.client.ClientSupport;
import org.onebusaway.siri.core.subscriptions.client.SiriClientSubscriptionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.siri.siri.CheckStatusRequestStructure;
import uk.org.siri.siri.CheckStatusResponseBodyStructure;
import uk.org.siri.siri.CheckStatusResponseStructure;
import uk.org.siri.siri.ErrorCodeStructure;
import uk.org.siri.siri.MessageQualifierStructure;
import uk.org.siri.siri.MessageRefStructure;
import uk.org.siri.siri.Siri;

@Singleton
class CheckStatusManager {
    private static final Logger _log = LoggerFactory.getLogger(CheckStatusManager.class);
    private ConcurrentMap<String, PendingCheckStatusRequest> _pendingCheckStatusRequests = new ConcurrentHashMap<String, PendingCheckStatusRequest>();
    private SiriClientSubscriptionManager _subscriptionManager;
    private SiriClientHandler _client;
    private SchedulingService _schedulingService;

    CheckStatusManager() {
    }

    @Inject
    public void setSubscriptionManager(SiriClientSubscriptionManager subscriptionManager) {
        this._subscriptionManager = subscriptionManager;
    }

    @Inject
    public void setClient(SiriClientHandler client) {
        this._client = client;
    }

    @Inject
    public void setScheduleService(SchedulingService schedulingService) {
        this._schedulingService = schedulingService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetCheckStatusTask(ClientSubscriptionChannel channel, int checkStatusInterval) {
        ClientSubscriptionChannel clientSubscriptionChannel = channel;
        synchronized (clientSubscriptionChannel) {
            channel.setCheckStatusInterval(checkStatusInterval);
            _log.debug("resetting check status task: channel={} interval={}", (Object)channel.getAddress(), (Object)checkStatusInterval);
            ScheduledFuture<Object> checkStatusTask = channel.getCheckStatusTask();
            if (checkStatusTask != null) {
                checkStatusTask.cancel(true);
                channel.setCheckStatusTask(null);
            }
            if (checkStatusInterval > 0) {
                CheckStatusTask task = new CheckStatusTask(channel);
                checkStatusTask = this._schedulingService.scheduleAtFixedRate(task, checkStatusInterval, checkStatusInterval, TimeUnit.SECONDS);
                channel.setCheckStatusTask(checkStatusTask);
            }
        }
    }

    public void handleCheckStatusResponse(CheckStatusResponseStructure response) {
        boolean isInError;
        _log.debug("handle check status response");
        MessageRefStructure messageRef = response.getRequestMessageRef();
        if (messageRef == null || messageRef.getValue() == null) {
            throw new SiriMissingArgumentException("RequestMessageRef");
        }
        PendingCheckStatusRequest pending = (PendingCheckStatusRequest)this._pendingCheckStatusRequests.remove(messageRef.getValue());
        if (pending == null) {
            _log.warn("Pending CheckStatus channel not found for messageId=" + messageRef.getValue());
            return;
        }
        ScheduledFuture<?> task = pending.getTimeoutTask();
        task.cancel(true);
        ClientSubscriptionChannel channel = pending.getChannel();
        boolean isNewer = this.isCheckStatusNewer(channel, response);
        boolean bl = isInError = response.isStatus() == null || response.isStatus() == false;
        if (!isNewer && !isInError) {
            return;
        }
        this.logErrorInCheckStatusResponse(channel, response, isNewer, isInError);
        this._subscriptionManager.handleChannelDisconnectAndReconnect(channel);
    }

    private void checkStatus(ClientSubscriptionChannel channel) {
        MessageQualifierStructure messageId = SiriTypeFactory.randomMessageId();
        CheckStatusRequestStructure checkStatus = new CheckStatusRequestStructure();
        checkStatus.setRequestTimestamp(new Date());
        checkStatus.setMessageIdentifier(messageId);
        Siri siri = new Siri();
        siri.setCheckStatusRequest(checkStatus);
        String url = channel.getCheckStatusUrl();
        if (url == null) {
            url = channel.getAddress();
        }
        SiriClientRequest request = new SiriClientRequest();
        request.setTargetUrl(url);
        request.setTargetVersion(channel.getTargetVersion());
        request.setPayload(siri);
        PendingCheckStatusTimeoutTask timeoutTask = new PendingCheckStatusTimeoutTask(channel, messageId.getValue());
        ScheduledFuture future = this._schedulingService.scheduleResponseTimeoutTask(timeoutTask);
        PendingCheckStatusRequest pending = new PendingCheckStatusRequest(channel, future);
        this._pendingCheckStatusRequests.put(messageId.getValue(), pending);
        _log.debug("sending check status request for channel={} messageId={}", (Object)channel.getAddress(), (Object)messageId.getValue());
        this._client.handleRequest(request);
    }

    private boolean isCheckStatusNewer(ClientSubscriptionChannel channel, CheckStatusResponseStructure response) {
        Date serviceStartedTime = response.getServiceStartedTime();
        if (serviceStartedTime == null) {
            return false;
        }
        Date lastServiceStartedTime = channel.getLastServiceStartedTime();
        if (lastServiceStartedTime == null) {
            channel.setLastServiceStartedTime(serviceStartedTime);
        } else if (serviceStartedTime.after(lastServiceStartedTime)) {
            return true;
        }
        return false;
    }

    public void logErrorInCheckStatusResponse(ClientSubscriptionChannel channel, CheckStatusResponseStructure response, boolean isNewer, boolean isInError) {
        StringBuilder b = new StringBuilder();
        b.append("check status failed for channel:");
        b.append(" address=").append(channel.getAddress());
        if (isNewer) {
            b.append(" prevServiceStartedTime=");
            b.append(channel.getLastServiceStartedTime());
            b.append(" newServiceStartedTime=");
            b.append(response.getServiceStartedTime());
        }
        CheckStatusResponseBodyStructure.ErrorCondition error = response.getErrorCondition();
        if (isInError && error != null) {
            ClientSupport.appendError((ErrorCodeStructure)error.getServiceNotAvailableError(), b);
            ClientSupport.appendError((ErrorCodeStructure)error.getOtherError(), b);
            if (error.getDescription() != null && error.getDescription().getValue() != null) {
                b.append(" errorDescription=" + error.getDescription().getValue());
            }
        }
        _log.warn(b.toString());
    }

    private static class PendingCheckStatusRequest {
        private final ClientSubscriptionChannel _channel;
        private ScheduledFuture<?> _timeoutTask;

        public PendingCheckStatusRequest(ClientSubscriptionChannel channel, ScheduledFuture<?> timeoutTask) {
            this._channel = channel;
            this._timeoutTask = timeoutTask;
        }

        public ClientSubscriptionChannel getChannel() {
            return this._channel;
        }

        public ScheduledFuture<?> getTimeoutTask() {
            return this._timeoutTask;
        }
    }

    private class PendingCheckStatusTimeoutTask
    implements Runnable {
        private final ClientSubscriptionChannel _channel;
        private final String _messageId;

        public PendingCheckStatusTimeoutTask(ClientSubscriptionChannel channel, String messageId) {
            this._channel = channel;
            this._messageId = messageId;
        }

        @Override
        public void run() {
            _log.debug("check status timeout task: messageId={}", (Object)this._messageId);
            PendingCheckStatusRequest pending = (PendingCheckStatusRequest)CheckStatusManager.this._pendingCheckStatusRequests.remove(this._messageId);
            if (pending == null) {
                return;
            }
            _log.warn("no check status response received: address=" + this._channel.getAddress() + " messageId=" + this._messageId + " timeout=" + CheckStatusManager.this._schedulingService.getResponseTimeout() + "s");
            CheckStatusManager.this._subscriptionManager.handleChannelDisconnectAndReconnect(this._channel);
        }
    }

    private class CheckStatusTask
    implements Runnable {
        private final ClientSubscriptionChannel _channel;

        public CheckStatusTask(ClientSubscriptionChannel channel) {
            this._channel = channel;
        }

        @Override
        public void run() {
            CheckStatusManager.this.checkStatus(this._channel);
        }
    }
}

