/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.siri.core.services;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Singleton;
import org.onebusaway.siri.core.services.SchedulingService;

@Singleton
class SchedulingServiceImpl
implements SchedulingService {
    private ExecutorService _executor = null;
    private ScheduledExecutorService _scheduledExecutor = null;
    private int _responseTimeout = 10;

    SchedulingServiceImpl() {
    }

    @PostConstruct
    public void start() {
        this._executor = Executors.newCachedThreadPool();
        this._scheduledExecutor = Executors.newScheduledThreadPool(1);
    }

    @PreDestroy
    public void stop() {
        if (this._executor != null) {
            this._executor.shutdownNow();
        }
        if (this._scheduledExecutor != null) {
            this._scheduledExecutor.shutdownNow();
        }
    }

    @Override
    public int getResponseTimeout() {
        return this._responseTimeout;
    }

    @Override
    public void setResponseTimeout(int responseTimeout) {
        this._responseTimeout = responseTimeout;
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this._executor.submit(task);
    }

    @Override
    public <T> ScheduledFuture<T> schedule(Runnable command, long delay, TimeUnit unit) {
        return this._scheduledExecutor.schedule(command, delay, unit);
    }

    @Override
    public <T> ScheduledFuture<T> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this._scheduledExecutor.scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    @Override
    public <T> ScheduledFuture<T> scheduleResponseTimeoutTask(Runnable task) {
        return this._scheduledExecutor.schedule(task, (long)this._responseTimeout, TimeUnit.SECONDS);
    }
}

